/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.FileDataEntry;
import proguard.io.ZipDataEntry;
import proguard.io.ZipFileDataEntry;

public class JarReader
implements DataEntryReader {
    private final boolean jmod;
    private final DataEntryReader dataEntryReader;

    public JarReader(DataEntryReader dataEntryReader) {
        this(false, dataEntryReader);
    }

    public JarReader(boolean jmod, DataEntryReader dataEntryReader) {
        this.jmod = jmod;
        this.dataEntryReader = dataEntryReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataEntry dataEntry) throws IOException {
        if (dataEntry instanceof FileDataEntry) {
            FileDataEntry fileDataEntry = (FileDataEntry)dataEntry;
            try (ZipFile zipFile = new ZipFile(fileDataEntry.getFile(), StandardCharsets.UTF_8);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    this.dataEntryReader.read(new ZipFileDataEntry(dataEntry, zipEntry, zipFile));
                }
            }
        }
        if (this.jmod) {
            dataEntry.getInputStream().read(new byte[4]);
        }
        ZipInputStream zipInputStream = new ZipInputStream(dataEntry.getInputStream(), StandardCharsets.UTF_8);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                this.dataEntryReader.read(new ZipDataEntry(dataEntry, zipEntry, zipInputStream));
            }
        }
        finally {
            dataEntry.closeInputStream();
        }
    }
}

