// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListClustersWithDialerEligibilityParams creates a new ListClustersWithDialerEligibilityParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListClustersWithDialerEligibilityParams() *ListClustersWithDialerEligibilityParams {
	return &ListClustersWithDialerEligibilityParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListClustersWithDialerEligibilityParamsWithTimeout creates a new ListClustersWithDialerEligibilityParams object
// with the ability to set a timeout on a request.
func NewListClustersWithDialerEligibilityParamsWithTimeout(timeout time.Duration) *ListClustersWithDialerEligibilityParams {
	return &ListClustersWithDialerEligibilityParams{
		timeout: timeout,
	}
}

// NewListClustersWithDialerEligibilityParamsWithContext creates a new ListClustersWithDialerEligibilityParams object
// with the ability to set a context for a request.
func NewListClustersWithDialerEligibilityParamsWithContext(ctx context.Context) *ListClustersWithDialerEligibilityParams {
	return &ListClustersWithDialerEligibilityParams{
		Context: ctx,
	}
}

// NewListClustersWithDialerEligibilityParamsWithHTTPClient creates a new ListClustersWithDialerEligibilityParams object
// with the ability to set a custom HTTPClient for a request.
func NewListClustersWithDialerEligibilityParamsWithHTTPClient(client *http.Client) *ListClustersWithDialerEligibilityParams {
	return &ListClustersWithDialerEligibilityParams{
		HTTPClient: client,
	}
}

/*
ListClustersWithDialerEligibilityParams contains all the parameters to send to the API endpoint

	for the list clusters with dialer eligibility operation.

	Typically these are written to a http.Request.
*/
type ListClustersWithDialerEligibilityParams struct {

	/* AcceptorClusterID.

	     acceptor_cluster_id is the user settable GNM cluster name of the acceptor cluster to
	check eligibility with
	*/
	AcceptorClusterID *string

	/* AcceptorClusterPartitionName.

	     acceptor_cluster_partition_name is the name of the partition of the acceptor cluster to
	check eligibility with
	*/
	AcceptorClusterPartitionName *string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list clusters with dialer eligibility params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClustersWithDialerEligibilityParams) WithDefaults() *ListClustersWithDialerEligibilityParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list clusters with dialer eligibility params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClustersWithDialerEligibilityParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithTimeout(timeout time.Duration) *ListClustersWithDialerEligibilityParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithContext(ctx context.Context) *ListClustersWithDialerEligibilityParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithHTTPClient(client *http.Client) *ListClustersWithDialerEligibilityParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAcceptorClusterID adds the acceptorClusterID to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithAcceptorClusterID(acceptorClusterID *string) *ListClustersWithDialerEligibilityParams {
	o.SetAcceptorClusterID(acceptorClusterID)
	return o
}

// SetAcceptorClusterID adds the acceptorClusterId to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetAcceptorClusterID(acceptorClusterID *string) {
	o.AcceptorClusterID = acceptorClusterID
}

// WithAcceptorClusterPartitionName adds the acceptorClusterPartitionName to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithAcceptorClusterPartitionName(acceptorClusterPartitionName *string) *ListClustersWithDialerEligibilityParams {
	o.SetAcceptorClusterPartitionName(acceptorClusterPartitionName)
	return o
}

// SetAcceptorClusterPartitionName adds the acceptorClusterPartitionName to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetAcceptorClusterPartitionName(acceptorClusterPartitionName *string) {
	o.AcceptorClusterPartitionName = acceptorClusterPartitionName
}

// WithLocationOrganizationID adds the locationOrganizationID to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithLocationOrganizationID(locationOrganizationID string) *ListClustersWithDialerEligibilityParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithLocationProjectID(locationProjectID string) *ListClustersWithDialerEligibilityParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithLocationRegionProvider(locationRegionProvider *string) *ListClustersWithDialerEligibilityParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) WithLocationRegionRegion(locationRegionRegion *string) *ListClustersWithDialerEligibilityParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list clusters with dialer eligibility params
func (o *ListClustersWithDialerEligibilityParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *ListClustersWithDialerEligibilityParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AcceptorClusterID != nil {

		// query param acceptor_cluster_id
		var qrAcceptorClusterID string

		if o.AcceptorClusterID != nil {
			qrAcceptorClusterID = *o.AcceptorClusterID
		}
		qAcceptorClusterID := qrAcceptorClusterID
		if qAcceptorClusterID != "" {

			if err := r.SetQueryParam("acceptor_cluster_id", qAcceptorClusterID); err != nil {
				return err
			}
		}
	}

	if o.AcceptorClusterPartitionName != nil {

		// query param acceptor_cluster_partition_name
		var qrAcceptorClusterPartitionName string

		if o.AcceptorClusterPartitionName != nil {
			qrAcceptorClusterPartitionName = *o.AcceptorClusterPartitionName
		}
		qAcceptorClusterPartitionName := qrAcceptorClusterPartitionName
		if qAcceptorClusterPartitionName != "" {

			if err := r.SetQueryParam("acceptor_cluster_partition_name", qAcceptorClusterPartitionName); err != nil {
				return err
			}
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
