/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.problems.secrets;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.problems.secrets.Secret;
import org.jetbrains.security.project.CodeSnippet;
import org.jetbrains.security.utils.Hashing;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/security/problems/secrets/HashedSecret;", "Lorg/jetbrains/security/problems/secrets/Secret;", "secret", "hashing", "Lorg/jetbrains/security/utils/Hashing;", "(Lorg/jetbrains/security/problems/secrets/Secret;Lorg/jetbrains/security/utils/Hashing;)V", "code", "Lorg/jetbrains/security/project/CodeSnippet;", "getCode", "()Lorg/jetbrains/security/project/CodeSnippet;", "pathToFile", "Ljava/nio/file/Path;", "getPathToFile", "()Ljava/nio/file/Path;", "token", "", "getToken", "()Ljava/lang/String;", "type", "getType", "model"})
public final class HashedSecret
implements Secret {
    @NotNull
    private final String token;
    @NotNull
    private final Path pathToFile;
    @NotNull
    private final CodeSnippet code;
    @NotNull
    private final String type;

    public HashedSecret(@NotNull Secret secret, @NotNull Hashing hashing) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)hashing, (String)"hashing");
        this.token = hashing.hash(secret.getToken());
        this.pathToFile = secret.getPathToFile();
        this.code = secret.getCode();
        this.type = secret.getType();
    }

    @Override
    @NotNull
    public String getToken() {
        return this.token;
    }

    @Override
    @NotNull
    public Path getPathToFile() {
        return this.pathToFile;
    }

    @Override
    @NotNull
    public CodeSnippet getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }
}

