/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.ui.CommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentsUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public final class SvnMergeSourceDetails
extends MasterDetailsComponent {
    private final Project myProject;
    private final SvnFileRevision myRevision;
    private final VirtualFile myFile;
    private final Map<Long, SvnChangeList> myListsMap;

    private SvnMergeSourceDetails(Project project, SvnFileRevision revision, VirtualFile file) {
        this.myProject = project;
        this.myRevision = revision;
        this.myFile = file;
        this.myListsMap = new HashMap<Long, SvnChangeList>();
        this.initTree();
        this.fillTree();
        this.getSplitter().setProportion(0.5f);
    }

    public static void showMe(Project project, SvnFileRevision revision, VirtualFile file) {
        if (ModalityState.nonModal().equals(ModalityState.current())) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
            ContentManager contentManager = toolWindow.getContentManager();
            MyDialog dialog = new MyDialog(project, revision, file);
            Disposer.register((Disposable)project, (Disposable)dialog.getDisposable());
            Content content = ContentFactory.getInstance().createContent(dialog.createCenterPanel(), SvnBundle.message("merge.source.details.title", file == null ? revision.getURL().toDecodedString() : file.getName(), revision.getRevisionNumber().asString()), true);
            ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content, (boolean)true);
            toolWindow.activate(null);
        } else {
            new MyDialog(project, revision, file).show();
        }
    }

    @Nls
    public String getDisplayName() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    private void addRecursively(SvnFileRevision revision, MasterDetailsComponent.MyNode node, List<TreePath> nodesToExpand) {
        MasterDetailsComponent.MyNode current = new MasterDetailsComponent.MyNode((NamedConfigurable)new MyNamedConfigurable(revision, this.myFile, this.myProject, this.myListsMap));
        node.add((MutableTreeNode)current);
        Object[] path = ((DefaultTreeModel)this.myTree.getModel()).getPathToRoot((TreeNode)node);
        nodesToExpand.add(new TreePath(path));
        List<SvnFileRevision> mergeSources = revision.getMergeSources();
        for (SvnFileRevision source : mergeSources) {
            this.addRecursively(source, current, nodesToExpand);
        }
    }

    private void fillTree() {
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        this.myRoot.removeAllChildren();
        ArrayList<TreePath> nodesToExpand = new ArrayList<TreePath>();
        this.addRecursively(this.myRevision, this.myRoot, nodesToExpand);
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        for (TreePath treePath : nodesToExpand) {
            this.myTree.expandPath(treePath);
        }
        this.myTree.getSelectionModel().setSelectionMode(1);
    }

    private static final class MyDialog
    extends DialogWrapper {
        private final Project myProject;
        private final SvnFileRevision myRevision;
        private final VirtualFile myFile;

        private MyDialog(Project project, SvnFileRevision revision, VirtualFile file) {
            super(project, true);
            this.myProject = project;
            this.myRevision = revision;
            this.myFile = file;
            this.setTitle(SvnBundle.message("merge.source.details.title", this.myFile == null ? this.myRevision.getURL().toDecodedString() : this.myFile.getName(), this.myRevision.getRevisionNumber().asString()));
            this.init();
        }

        public JComponent createCenterPanel() {
            JComponent component = new SvnMergeSourceDetails(this.myProject, this.myRevision, this.myFile).createComponent();
            component.setMinimumSize(new Dimension(300, 200));
            return component;
        }
    }

    private static final class MyNamedConfigurable
    extends NamedConfigurable<SvnFileRevision> {
        private final SvnFileRevision myRevision;
        private final VirtualFile myFile;
        private final Project myProject;
        private final Map<Long, SvnChangeList> myListsMap;
        private JComponent myPanel;

        private MyNamedConfigurable(SvnFileRevision revision, VirtualFile file, Project project, Map<Long, SvnChangeList> listsMap) {
            this.myRevision = revision;
            this.myFile = file;
            this.myProject = project;
            this.myListsMap = listsMap;
        }

        public void setDisplayName(String name) {
        }

        public SvnFileRevision getEditableObject() {
            return this.myRevision;
        }

        public String getBannerSlogan() {
            return this.myRevision.getRevisionNumber().asString();
        }

        private SvnChangeList getList() {
            SvnChangeList list = this.myListsMap.get(this.myRevision.getRevision().getNumber());
            if (list == null) {
                list = (SvnChangeList)SvnVcs.getInstance(this.myProject).loadRevisions(this.myFile, this.myRevision.getRevisionNumber());
                this.myListsMap.put(this.myRevision.getRevision().getNumber(), list);
            }
            return list;
        }

        public JComponent createOptionsPanel() {
            if (this.myPanel == null) {
                SvnChangeList list = this.getList();
                if (list == null) {
                    this.myPanel = new JPanel();
                } else {
                    CommittedChangeListPanel panel2 = new CommittedChangeListPanel(this.myProject);
                    panel2.setChangeList((CommittedChangeList)list);
                    this.myPanel = panel2;
                }
            }
            return this.myPanel;
        }

        @Nls
        public String getDisplayName() {
            return this.getBannerSlogan();
        }

        public String getHelpTopic() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() {
        }

        public SvnFileRevision getRevision() {
            return this.myRevision;
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private static final int ourMaxWidth = 100;

        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SvnFileRevision revision;
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            FontMetrics metrics = tree.getFontMetrics(tree.getFont());
            if (value instanceof MasterDetailsComponent.MyRootNode) {
                revision = SvnMergeSourceDetails.this.myRevision;
            } else {
                MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)value;
                MyNamedConfigurable configurable = (MyNamedConfigurable)myNode.getConfigurable();
                revision = configurable.getRevision();
            }
            Object description = CommittedChangeListRenderer.getDescriptionOfChangeList((String)revision.getCommitMessage());
            if (metrics.stringWidth((String)description) > 100) {
                description = CommittedChangeListRenderer.truncateDescription((String)description, (FontMetrics)metrics, (int)(100 - metrics.stringWidth(MyTreeCellRenderer.getTruncatedSuffix())));
                description = (String)description + MyTreeCellRenderer.getTruncatedSuffix();
            }
            this.append(revision.getRevisionNumber().asString() + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append((String)description + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(StringUtil.notNullize((String)revision.getAuthor()), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(", " + DateFormatUtil.formatPrettyDateTime((Date)revision.getRevisionDate()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @Nls
        @NotNull
        private static String getTruncatedSuffix() {
            return "(\u2026)";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/svn/history/SvnMergeSourceDetails$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

