/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;

abstract class SearchScrollAsyncAction<T extends SearchPhaseResult>
implements Runnable {
    protected final Logger logger;
    protected final ActionListener<SearchResponse> listener;
    protected final ParsedScrollId scrollId;
    protected final DiscoveryNodes nodes;
    protected final SearchScrollRequest request;
    protected final SearchTransportService searchTransportService;
    private final long startTime;
    private final List<ShardSearchFailure> shardFailures = new ArrayList<ShardSearchFailure>();
    private final AtomicInteger successfulOps;

    protected SearchScrollAsyncAction(ParsedScrollId scrollId, Logger logger, DiscoveryNodes nodes, ActionListener<SearchResponse> listener, SearchScrollRequest request, SearchTransportService searchTransportService) {
        this.startTime = System.currentTimeMillis();
        this.scrollId = scrollId;
        this.successfulOps = new AtomicInteger(scrollId.getContext().length);
        this.logger = logger;
        this.listener = listener;
        this.nodes = nodes;
        this.request = request;
        this.searchTransportService = searchTransportService;
    }

    private long buildTookInMillis() {
        return Math.max(1L, System.currentTimeMillis() - this.startTime);
    }

    @Override
    public final void run() {
        SearchContextIdForNode[] context = this.scrollId.getContext();
        if (context.length == 0) {
            this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", ShardSearchFailure.EMPTY_ARRAY));
        } else {
            SearchScrollAsyncAction.collectNodesAndRun(Arrays.asList(context), this.nodes, this.searchTransportService, this.listener.delegateFailureAndWrap((l, lookup) -> this.run((BiFunction<String, String, DiscoveryNode>)lookup, context)));
        }
    }

    static void collectNodesAndRun(Iterable<SearchContextIdForNode> scrollIds, DiscoveryNodes nodes, SearchTransportService searchTransportService, ActionListener<BiFunction<String, String, DiscoveryNode>> listener) {
        HashSet<String> clusters = new HashSet<String>();
        for (SearchContextIdForNode target : scrollIds) {
            if (target.getClusterAlias() == null) continue;
            clusters.add(target.getClusterAlias());
        }
        if (clusters.isEmpty()) {
            listener.onResponse((cluster, node) -> nodes.get((String)node));
        } else {
            RemoteClusterService remoteClusterService = searchTransportService.getRemoteClusterService();
            remoteClusterService.collectNodes(clusters, listener.map(nodeFunction -> (clusterAlias, node) -> clusterAlias == null ? nodes.get((String)node) : (DiscoveryNode)nodeFunction.apply(clusterAlias, node)));
        }
    }

    private void run(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup, SearchContextIdForNode[] context) {
        final CountDown counter = new CountDown(this.scrollId.getContext().length);
        for (int i = 0; i < context.length; ++i) {
            Transport.Connection connection;
            final SearchContextIdForNode target = context[i];
            final int shardIndex = i;
            try {
                DiscoveryNode node = clusterNodeLookup.apply(target.getClusterAlias(), target.getNode());
                if (node == null) {
                    throw new IllegalStateException("node [" + target.getNode() + "] is not available");
                }
                connection = this.getConnection(target.getClusterAlias(), node);
            }
            catch (Exception ex) {
                this.onShardFailure("query", counter, target.getSearchContextId(), ex, null, () -> this.moveToNextPhase(clusterNodeLookup));
                continue;
            }
            InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest(target.getSearchContextId(), this.request);
            SearchActionListener searchActionListener = new SearchActionListener<T>(null, shardIndex){

                @Override
                protected void setSearchShardTarget(T response) {
                    assert (((SearchPhaseResult)response).getSearchShardTarget() != null) : "search shard target must not be null";
                    if (target.getClusterAlias() != null) {
                        SearchShardTarget searchShardTarget = ((SearchPhaseResult)response).getSearchShardTarget();
                        ((SearchPhaseResult)response).setSearchShardTarget(new SearchShardTarget(searchShardTarget.getNodeId(), searchShardTarget.getShardId(), target.getClusterAlias()));
                    }
                }

                @Override
                protected void innerOnResponse(T result) {
                    assert (shardIndex == ((SearchPhaseResult)result).getShardIndex()) : "shard index mismatch: " + shardIndex + " but got: " + ((SearchPhaseResult)result).getShardIndex();
                    SearchScrollAsyncAction.this.onFirstPhaseResult(shardIndex, result);
                    if (counter.countDown()) {
                        SearchPhase phase = SearchScrollAsyncAction.this.moveToNextPhase(clusterNodeLookup);
                        try {
                            phase.run();
                        }
                        catch (Exception e) {
                            SearchScrollAsyncAction.this.listener.onFailure(new SearchPhaseExecutionException(phase.getName(), "Phase failed", e, ShardSearchFailure.EMPTY_ARRAY));
                        }
                    }
                }

                @Override
                public void onFailure(Exception t) {
                    SearchScrollAsyncAction.this.onShardFailure("query", counter, target.getSearchContextId(), t, null, () -> SearchScrollAsyncAction.this.moveToNextPhase(clusterNodeLookup));
                }
            };
            this.executeInitialPhase(connection, internalRequest, searchActionListener);
        }
    }

    synchronized ShardSearchFailure[] buildShardFailures() {
        if (this.shardFailures.isEmpty()) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        return this.shardFailures.toArray(ShardSearchFailure.EMPTY_ARRAY);
    }

    private synchronized void addShardFailure(ShardSearchFailure failure) {
        this.shardFailures.add(failure);
    }

    protected abstract void executeInitialPhase(Transport.Connection var1, InternalScrollSearchRequest var2, ActionListener<T> var3);

    protected abstract SearchPhase moveToNextPhase(BiFunction<String, String, DiscoveryNode> var1);

    protected abstract void onFirstPhaseResult(int var1, T var2);

    protected SearchPhase sendResponsePhase(final SearchPhaseController.ReducedQueryPhase queryPhase, final AtomicArray<? extends SearchPhaseResult> fetchResults) {
        return new SearchPhase("fetch"){

            public void run() {
                SearchScrollAsyncAction.this.sendResponse(queryPhase, fetchResults);
            }
        };
    }

    protected final void sendResponse(SearchPhaseController.ReducedQueryPhase queryPhase, AtomicArray<? extends SearchPhaseResult> fetchResults) {
        try {
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            try (SearchResponseSections sections = SearchPhaseController.merge(true, queryPhase, fetchResults);){
                ActionListener.respondAndRelease(this.listener, new SearchResponse(sections, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), 0, this.buildTookInMillis(), this.buildShardFailures(), SearchResponse.Clusters.EMPTY, null));
            }
        }
        catch (Exception e) {
            this.listener.onFailure(new ReduceSearchPhaseException("fetch", "inner finish failed", e, this.buildShardFailures()));
        }
    }

    protected void onShardFailure(String phaseName, CountDown counter, ShardSearchContextId searchId, Exception failure, @Nullable SearchShardTarget searchShardTarget, Supplier<SearchPhase> nextPhaseSupplier) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> Strings.format((String)"[%s] Failed to execute %s phase", (Object[])new Object[]{searchId, phaseName}), (Throwable)failure);
        }
        this.addShardFailure(new ShardSearchFailure(failure, searchShardTarget));
        int successfulOperations = this.successfulOps.decrementAndGet();
        assert (successfulOperations >= 0) : "successfulOperations must be >= 0 but was: " + successfulOperations;
        if (counter.countDown()) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException(phaseName, "all shards failed", failure, this.buildShardFailures()));
            } else {
                SearchPhase phase = nextPhaseSupplier.get();
                try {
                    phase.run();
                }
                catch (Exception e) {
                    e.addSuppressed(failure);
                    this.listener.onFailure(new SearchPhaseExecutionException(phase.getName(), "Phase failed", e, ShardSearchFailure.EMPTY_ARRAY));
                }
            }
        }
    }

    protected Transport.Connection getConnection(String clusterAlias, DiscoveryNode node) {
        return this.searchTransportService.getConnection(clusterAlias, node);
    }
}

