/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record ClusterBalanceStats(int shards, int undesiredShardAllocations, Map<String, TierBalanceStats> tiers, Map<String, NodeBalanceStats> nodes) implements Writeable,
ToXContentObject
{
    public static ClusterBalanceStats EMPTY = new ClusterBalanceStats(0, 0, Map.of(), Map.of());

    public static ClusterBalanceStats createFrom(ClusterState clusterState, DesiredBalance desiredBalance, ClusterInfo clusterInfo, WriteLoadForecaster writeLoadForecaster) {
        HashMap<String, List> tierToNodeStats = new HashMap<String, List>();
        HashMap<String, NodeBalanceStats> nodes = new HashMap<String, NodeBalanceStats>();
        for (RoutingNode routingNode : clusterState.getRoutingNodes()) {
            List<DiscoveryNodeRole> dataRoles = routingNode.node().getRoles().stream().filter(DiscoveryNodeRole::canContainData).toList();
            if (dataRoles.isEmpty()) continue;
            NodeBalanceStats nodeStats = NodeBalanceStats.createFrom(routingNode, clusterState.metadata(), desiredBalance, clusterInfo, writeLoadForecaster);
            nodes.put(routingNode.node().getName(), nodeStats);
            for (DiscoveryNodeRole role : dataRoles) {
                tierToNodeStats.computeIfAbsent(role.roleName(), ignored -> new ArrayList()).add(nodeStats);
            }
        }
        return new ClusterBalanceStats(nodes.values().stream().mapToInt(NodeBalanceStats::shards).sum(), nodes.values().stream().mapToInt(NodeBalanceStats::undesiredShardAllocations).sum(), Maps.transformValues(tierToNodeStats, TierBalanceStats::createFrom), nodes);
    }

    public static ClusterBalanceStats readFrom(StreamInput in) throws IOException {
        return new ClusterBalanceStats(in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVInt() : -1, in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVInt() : -1, in.readImmutableMap(TierBalanceStats::readFrom), in.readImmutableMap(NodeBalanceStats::readFrom));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeVInt(this.shards);
            out.writeVInt(this.undesiredShardAllocations);
        }
        out.writeMap(this.tiers, StreamOutput::writeWriteable);
        out.writeMap(this.nodes, StreamOutput::writeWriteable);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("shard_count", this.shards).field("undesired_shard_allocation_count", this.undesiredShardAllocations).field("tiers", this.tiers).field("nodes", this.nodes).endObject();
    }

    public record NodeBalanceStats(String nodeId, List<String> roles, int shards, int undesiredShardAllocations, double forecastWriteLoad, long forecastShardSize, long actualShardSize) implements Writeable,
    ToXContentObject
    {
        private static final String UNKNOWN_NODE_ID = "UNKNOWN";

        private static NodeBalanceStats createFrom(RoutingNode routingNode, Metadata metadata, DesiredBalance desiredBalance, ClusterInfo clusterInfo, WriteLoadForecaster writeLoadForecaster) {
            int undesired = 0;
            double forecastWriteLoad = 0.0;
            long forecastShardSize = 0L;
            long actualShardSize = 0L;
            for (ShardRouting shardRouting : routingNode) {
                IndexMetadata indexMetadata = metadata.index(shardRouting.index());
                long shardSize = clusterInfo.getShardSize(shardRouting, 0L);
                assert (indexMetadata != null);
                forecastWriteLoad += writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
                forecastShardSize += indexMetadata.getForecastedShardSizeInBytes().orElse(shardSize);
                actualShardSize += shardSize;
                if (NodeBalanceStats.isDesiredShardAllocation(shardRouting, desiredBalance)) continue;
                ++undesired;
            }
            return new NodeBalanceStats(routingNode.nodeId(), routingNode.node().getRoles().stream().map(DiscoveryNodeRole::roleName).toList(), routingNode.size(), undesired, forecastWriteLoad, forecastShardSize, actualShardSize);
        }

        private static boolean isDesiredShardAllocation(ShardRouting shardRouting, DesiredBalance desiredBalance) {
            if (shardRouting.relocating()) {
                return true;
            }
            ShardAssignment assignment = desiredBalance.getAssignment(shardRouting.shardId());
            return assignment != null && assignment.nodeIds().contains(shardRouting.currentNodeId());
        }

        public static NodeBalanceStats readFrom(StreamInput in) throws IOException {
            return new NodeBalanceStats(in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readString() : UNKNOWN_NODE_ID, in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readStringCollectionAsList() : List.of(), in.readInt(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVInt() : -1, in.readDouble(), in.readLong(), in.readLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
                out.writeString(this.nodeId);
                out.writeStringCollection(this.roles);
            }
            out.writeInt(this.shards);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
                out.writeVInt(this.undesiredShardAllocations);
            }
            out.writeDouble(this.forecastWriteLoad);
            out.writeLong(this.forecastShardSize);
            out.writeLong(this.actualShardSize);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (!UNKNOWN_NODE_ID.equals(this.nodeId)) {
                builder.field("node_id", this.nodeId);
            }
            return builder.field("roles", this.roles).field("shard_count", this.shards).field("undesired_shard_allocation_count", this.undesiredShardAllocations).field("forecast_write_load", this.forecastWriteLoad).humanReadableField("forecast_disk_usage_bytes", "forecast_disk_usage", (Object)ByteSizeValue.ofBytes(this.forecastShardSize)).humanReadableField("actual_disk_usage_bytes", "actual_disk_usage", (Object)ByteSizeValue.ofBytes(this.actualShardSize)).endObject();
        }
    }

    public record MetricStats(double total, double min, double max, double average, double stdDev) implements Writeable,
    ToXContentObject
    {
        private static MetricStats createFrom(List<NodeBalanceStats> nodes, ToDoubleFunction<NodeBalanceStats> metricExtractor) {
            assert (!nodes.isEmpty()) : "Stats must be created from non empty nodes";
            double total = 0.0;
            double total2 = 0.0;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int count = 0;
            for (NodeBalanceStats node : nodes) {
                double metric = metricExtractor.applyAsDouble(node);
                if (Double.isNaN(metric)) continue;
                total += metric;
                total2 += Math.pow(metric, 2.0);
                min = Math.min(min, metric);
                max = Math.max(max, metric);
                ++count;
            }
            double average = count == 0 ? Double.NaN : total / (double)count;
            double stdDev = count == 0 ? Double.NaN : Math.sqrt(total2 / (double)count - Math.pow(average, 2.0));
            return new MetricStats(total, min, max, average, stdDev);
        }

        public static MetricStats readFrom(StreamInput in) throws IOException {
            return new MetricStats(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.total);
            out.writeDouble(this.min);
            out.writeDouble(this.max);
            out.writeDouble(this.average);
            out.writeDouble(this.stdDev);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("total", this.total).field("min", this.min).field("max", this.max).field("average", this.average).field("std_dev", this.stdDev).endObject();
        }
    }

    public record TierBalanceStats(MetricStats shardCount, MetricStats undesiredShardAllocations, MetricStats forecastWriteLoad, MetricStats forecastShardSize, MetricStats actualShardSize) implements Writeable,
    ToXContentObject
    {
        private static TierBalanceStats createFrom(List<NodeBalanceStats> nodes) {
            return new TierBalanceStats(MetricStats.createFrom(nodes, it -> it.shards), MetricStats.createFrom(nodes, it -> it.undesiredShardAllocations), MetricStats.createFrom(nodes, it -> it.forecastWriteLoad), MetricStats.createFrom(nodes, it -> it.forecastShardSize), MetricStats.createFrom(nodes, it -> it.actualShardSize));
        }

        public static TierBalanceStats readFrom(StreamInput in) throws IOException {
            return new TierBalanceStats(MetricStats.readFrom(in), in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? MetricStats.readFrom(in) : new MetricStats(0.0, 0.0, 0.0, 0.0, 0.0), MetricStats.readFrom(in), MetricStats.readFrom(in), MetricStats.readFrom(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardCount.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
                this.undesiredShardAllocations.writeTo(out);
            }
            this.forecastWriteLoad.writeTo(out);
            this.forecastShardSize.writeTo(out);
            this.actualShardSize.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("shard_count", (ToXContent)this.shardCount).field("undesired_shard_allocation_count", (ToXContent)this.undesiredShardAllocations).field("forecast_write_load", (ToXContent)this.forecastWriteLoad).field("forecast_disk_usage", (ToXContent)this.forecastShardSize).field("actual_disk_usage", (ToXContent)this.actualShardSize).endObject();
        }
    }
}

