/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;

public interface ShardsAllocator {
    public void allocate(RoutingAllocation var1);

    default public void allocate(RoutingAllocation allocation, ActionListener<Void> listener) {
        this.allocate(allocation);
        listener.onResponse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public RoutingExplanations execute(RoutingAllocation allocation, AllocationCommands commands, boolean explain, boolean retryFailed) {
        RoutingAllocation.DebugMode originalDebugMode = allocation.getDebugMode();
        allocation.debugDecision(true);
        allocation.ignoreDisable(true);
        try {
            if (retryFailed) {
                allocation.routingNodes().resetFailedCounter(allocation.changes());
            }
            RoutingExplanations routingExplanations = commands.execute(allocation, explain);
            return routingExplanations;
        }
        finally {
            allocation.ignoreDisable(false);
            allocation.setDebugMode(originalDebugMode);
        }
    }

    public ShardAllocationDecision decideShardAllocation(ShardRouting var1, RoutingAllocation var2);
}

