/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.LongArray;

public class ReleasableLongArray
implements LongArray {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ReleasableLongArray.class);
    private final ReleasableBytesReference ref;

    ReleasableLongArray(StreamInput in) throws IOException {
        this.ref = in.readReleasableBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.ref);
    }

    @Override
    public long size() {
        return this.ref.length() / 8;
    }

    @Override
    public long get(long index) {
        if (index > 0xFFFFFFFL) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ref.getLongLE((int)index * 8);
    }

    @Override
    public long getAndSet(long index, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long increment(long index, long inc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(long fromIndex, long toIndex, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillWith(StreamInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE;
    }

    public void close() {
        this.ref.decRef();
    }
}

