/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;

public class StoredValueFetcher
implements ValueFetcher {
    private final SearchLookup lookup;
    private LeafSearchLookup leafSearchLookup;
    private final String fieldname;
    private final StoredFieldsSpec storedFieldsSpec;

    public StoredValueFetcher(SearchLookup lookup, String fieldname) {
        this.lookup = lookup;
        this.fieldname = fieldname;
        this.storedFieldsSpec = new StoredFieldsSpec(false, false, Set.of(fieldname));
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.leafSearchLookup = this.lookup.getLeafSearchLookup(context);
    }

    @Override
    public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
        this.leafSearchLookup.setDocument(doc);
        List<Object> values = this.leafSearchLookup.fields().get(this.fieldname).getValues();
        if (values == null) {
            return values;
        }
        return this.parseStoredValues(List.copyOf(values));
    }

    protected List<Object> parseStoredValues(List<Object> values) {
        return values;
    }

    @Override
    public StoredFieldsSpec storedFieldsSpec() {
        return this.storedFieldsSpec;
    }
}

