/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.FieldFetcher;

public final class FetchFieldsPhase
implements FetchSubPhase {
    private static final List<FieldAndFormat> DEFAULT_METADATA_FIELDS = List.of(new FieldAndFormat("_ignored", null), new FieldAndFormat("_routing", null), new FieldAndFormat("_type", null));

    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) {
        FieldFetcher metadataFieldFetcher;
        boolean fetchStoredFields;
        FetchFieldsContext fetchFieldsContext = fetchContext.fetchFieldsContext();
        StoredFieldsContext storedFieldsContext = fetchContext.storedFieldsContext();
        boolean bl = fetchStoredFields = storedFieldsContext != null && storedFieldsContext.fetchFields();
        if (fetchFieldsContext == null && !fetchStoredFields) {
            return null;
        }
        SearchExecutionContext searchExecutionContext = fetchContext.getSearchExecutionContext();
        final FieldFetcher fieldFetcher = fetchFieldsContext == null ? null : (fetchFieldsContext.fields() == null ? null : (fetchFieldsContext.fields().isEmpty() ? null : FieldFetcher.create(searchExecutionContext, fetchFieldsContext.fields())));
        HashSet<FieldAndFormat> fetchContextMetadataFields = new HashSet<FieldAndFormat>();
        if (fetchFieldsContext != null && fetchFieldsContext.fields() != null && !fetchFieldsContext.fields().isEmpty()) {
            for (FieldAndFormat fieldAndFormat : fetchFieldsContext.fields()) {
                if ("_source".equals(fieldAndFormat.field) || "_id".equals(fieldAndFormat.field) || !searchExecutionContext.isMetadataField(fieldAndFormat.field) || !searchExecutionContext.getFieldType(fieldAndFormat.field).isStored()) continue;
                fetchContextMetadataFields.add(fieldAndFormat);
            }
        }
        if (storedFieldsContext != null && storedFieldsContext.fieldNames() != null && !storedFieldsContext.fieldNames().isEmpty()) {
            HashSet<FieldAndFormat> metadataFields = new HashSet<FieldAndFormat>(DEFAULT_METADATA_FIELDS);
            for (String storedField : storedFieldsContext.fieldNames()) {
                Set<String> matchingFieldNames = searchExecutionContext.getMatchingFieldNames(storedField);
                for (String matchingFieldName : matchingFieldNames) {
                    if ("_source".equals(matchingFieldName) || "_id".equals(matchingFieldName)) continue;
                    MappedFieldType fieldType = searchExecutionContext.getFieldType(matchingFieldName);
                    if (matchingFieldName.equals("_ignored_source") && Regex.isSimpleMatchPattern(storedField) || !searchExecutionContext.isMetadataField(matchingFieldName) || !fieldType.isStored()) continue;
                    metadataFields.add(new FieldAndFormat(matchingFieldName, null));
                }
            }
            metadataFields.addAll(fetchContextMetadataFields);
            metadataFieldFetcher = FieldFetcher.create(searchExecutionContext, metadataFields);
        } else {
            HashSet<FieldAndFormat> allMetadataFields = new HashSet<FieldAndFormat>(DEFAULT_METADATA_FIELDS);
            allMetadataFields.addAll(fetchContextMetadataFields);
            metadataFieldFetcher = FieldFetcher.create(searchExecutionContext, allMetadataFields);
        }
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
                if (fieldFetcher != null) {
                    fieldFetcher.setNextReader(readerContext);
                }
                metadataFieldFetcher.setNextReader(readerContext);
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                if (fieldFetcher != null) {
                    return metadataFieldFetcher.storedFieldsSpec().merge(fieldFetcher.storedFieldsSpec());
                }
                return metadataFieldFetcher.storedFieldsSpec();
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                Map<String, DocumentField> fields = fieldFetcher != null ? fieldFetcher.fetch(hitContext.source(), hitContext.docId()) : Collections.emptyMap();
                Map<String, DocumentField> metadataFields = metadataFieldFetcher.fetch(hitContext.source(), hitContext.docId());
                hitContext.hit().addDocumentFields(fields, metadataFields);
            }
        };
    }
}

