/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.RegisteredPolicySnapshots;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotNameAlreadyInUseException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class SnapshotsService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    public static final IndexVersion SHARD_GEN_IN_REPO_DATA_VERSION = IndexVersions.V_7_6_0;
    public static final IndexVersion INDEX_GEN_IN_REPO_DATA_VERSION = IndexVersions.V_7_9_0;
    public static final IndexVersion UUIDS_IN_REPO_DATA_VERSION = IndexVersions.V_7_12_0;
    public static final TransportVersion UUIDS_IN_REPO_DATA_TRANSPORT_VERSION = TransportVersions.V_7_12_0;
    public static final IndexVersion FILE_INFO_WRITER_UUIDS_IN_SHARD_DATA_VERSION = IndexVersions.V_7_16_0;
    public static final IndexVersion OLD_SNAPSHOT_FORMAT = IndexVersions.V_7_5_0;
    public static final String POLICY_ID_METADATA_FIELD = "policy";
    private static final Logger logger = LogManager.getLogger(SnapshotsService.class);
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    public static final String NO_FEATURE_STATES_VALUE = "none";
    private final ClusterService clusterService;
    private final RerouteService rerouteService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, List<ActionListener<SnapshotInfo>>> snapshotCompletionListeners = new ConcurrentHashMap<Snapshot, List<ActionListener<SnapshotInfo>>>();
    private final Map<String, List<ActionListener<Void>>> snapshotDeletionListeners = new ConcurrentHashMap<String, List<ActionListener<Void>>>();
    private final Set<String> currentlyFinalizing = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> endingSnapshots = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> initializingClones = Collections.synchronizedSet(new HashSet());
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;
    private final TransportService transportService;
    private final OngoingRepositoryOperations repositoryOperations = new OngoingRepositoryOperations();
    private final SystemIndices systemIndices;
    private final MasterServiceTaskQueue<SnapshotTask> masterServiceTaskQueue;
    private final ShardSnapshotUpdateCompletionHandler shardSnapshotUpdateCompletionHandler;
    public static final Setting<Integer> MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING = Setting.intSetting("snapshot.max_concurrent_operations", 1000, 1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile int maxConcurrentOperations;
    private final Set<RepositoryShardId> currentlyCloning = Collections.synchronizedSet(new HashSet());
    private static final String REMOVE_SNAPSHOT_METADATA_TASK_SOURCE = "remove snapshot metadata";
    private final MasterServiceTaskQueue<UpdateNodeIdsForRemovalTask> updateNodeIdsToRemoveQueue;

    public SnapshotsService(Settings settings, ClusterService clusterService, RerouteService rerouteService, IndexNameExpressionResolver indexNameExpressionResolver, RepositoriesService repositoriesService, TransportService transportService, ActionFilters actionFilters, SystemIndices systemIndices) {
        this.clusterService = clusterService;
        this.rerouteService = rerouteService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.repositoriesService = repositoriesService;
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, this.threadPool, actionFilters, indexNameExpressionResolver);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addLowPriorityApplier(this);
            this.maxConcurrentOperations = MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING, i -> {
                this.maxConcurrentOperations = i;
            });
        }
        this.systemIndices = systemIndices;
        this.masterServiceTaskQueue = clusterService.createTaskQueue("snapshots-service", Priority.NORMAL, new SnapshotTaskExecutor());
        this.updateNodeIdsToRemoveQueue = clusterService.createTaskQueue("snapshots-service-node-ids", Priority.NORMAL, UpdateNodeIdsForRemovalTask::executeBatch);
        this.shardSnapshotUpdateCompletionHandler = this::handleShardSnapshotUpdateCompletion;
    }

    public void executeSnapshot(CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshot(request, listener.delegateFailureAndWrap((l, snapshot) -> this.addListener((Snapshot)snapshot, (ActionListener<SnapshotInfo>)l)));
    }

    public void createSnapshot(CreateSnapshotRequest request, ActionListener<Snapshot> listener) {
        String repositoryName = request.repository();
        String snapshotName = IndexNameExpressionResolver.resolveDateMathExpression(request.snapshot());
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, request.uuid());
        Repository repository = this.repositoriesService.repository(request.repository());
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository", new Object[0]));
            return;
        }
        this.submitCreateSnapshotRequest(request, listener, repository, new Snapshot(repositoryName, snapshotId), repository.getMetadata());
    }

    private void submitCreateSnapshotRequest(CreateSnapshotRequest request, ActionListener<Snapshot> listener, Repository repository, Snapshot snapshot, RepositoryMetadata initialRepositoryMetadata) {
        repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, listener.delegateFailure((l, repositoryData) -> this.masterServiceTaskQueue.submitTask("create_snapshot [" + snapshot.getSnapshotId().getName() + "]", new CreateSnapshotTask(repository, (RepositoryData)repositoryData, (ActionListener<Snapshot>)l, snapshot, request, initialRepositoryMetadata), request.masterNodeTimeout())));
    }

    private static void ensureSnapshotNameNotRunning(SnapshotsInProgress runningSnapshots, String repositoryName, String snapshotName) {
        if (runningSnapshots.forRepo(repositoryName).stream().anyMatch(s -> s.snapshot().getSnapshotId().getName().equals(snapshotName))) {
            throw new SnapshotNameAlreadyInUseException(repositoryName, snapshotName, "snapshot with the same name is already in-progress");
        }
    }

    public void cloneSnapshot(CloneSnapshotRequest request, ActionListener<Void> listener) {
        final String repositoryName = request.repository();
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repositoryName, "cannot create snapshot in a readonly repository", new Object[0]));
            return;
        }
        String snapshotName = IndexNameExpressionResolver.resolveDateMathExpression(request.target());
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        this.initializingClones.add(snapshot);
        this.executeConsistentStateUpdate(repository, repositoryData -> new ClusterStateUpdateTask(request.masterNodeTimeout(), (RepositoryData)repositoryData, snapshotName, repository, request, snapshot, listener){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ CloneSnapshotRequest val$request;
            final /* synthetic */ Snapshot val$snapshot;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string2;
                this.val$repository = repository;
                this.val$request = cloneSnapshotRequest;
                this.val$snapshot = snapshot;
                this.val$listener = actionListener;
                super(timeout);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                SnapshotsService.ensureSnapshotNameAvailableInRepo(this.val$repositoryData, this.val$snapshotName, this.val$repository);
                SnapshotsService.ensureNoCleanupInProgress(currentState, repositoryName, this.val$snapshotName, "clone snapshot");
                SnapshotsInProgress snapshots = SnapshotsInProgress.get(currentState);
                SnapshotsService.ensureSnapshotNameNotRunning(snapshots, repositoryName, this.val$snapshotName);
                SnapshotsService.validate(repositoryName, this.val$snapshotName, currentState);
                SnapshotId sourceSnapshotId = this.val$repositoryData.getSnapshotIds().stream().filter(src -> src.getName().equals(this.val$request.source())).findAny().orElseThrow(() -> new SnapshotMissingException(repositoryName, this.val$request.source()));
                SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
                if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.snapshots().contains(sourceSnapshotId))) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, sourceSnapshotId.getName(), "cannot clone from snapshot that is being deleted");
                }
                SnapshotsService.this.ensureBelowConcurrencyLimit(repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                ArrayList<String> indicesForSnapshot = new ArrayList<String>();
                for (IndexId indexId : this.val$repositoryData.getIndices().values()) {
                    if (!this.val$repositoryData.getSnapshots(indexId).contains(sourceSnapshotId)) continue;
                    indicesForSnapshot.add(indexId.getName());
                }
                List<String> matchingIndices = SnapshotUtils.filterIndices(indicesForSnapshot, this.val$request.indices(), this.val$request.indicesOptions());
                if (matchingIndices.isEmpty()) {
                    throw new SnapshotException(new Snapshot(repositoryName, sourceSnapshotId), "No indices in the source snapshot [" + String.valueOf(sourceSnapshotId) + "] matched requested pattern [" + org.elasticsearch.common.Strings.arrayToCommaDelimitedString(this.val$request.indices()) + "]");
                }
                this.newEntry = SnapshotsInProgress.startClone(this.val$snapshot, sourceSnapshotId, this.val$repositoryData.resolveIndices(matchingIndices), SnapshotsService.this.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), SnapshotsService.minCompatibleVersion(currentState.nodes().getMaxDataNodeCompatibleIndexVersion(), this.val$repositoryData, null));
                return ClusterState.builder(currentState).putCustom("snapshots", snapshots.withAddedEntry(this.newEntry)).build();
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$snapshot);
                SnapshotsService.logSnapshotFailure("clone", this.val$snapshot, e);
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                logger.info("snapshot clone [{}] started", (Object)this.val$snapshot);
                SnapshotsService.this.addListener(this.val$snapshot, this.val$listener.delegateFailureAndWrap((l, r) -> l.onResponse(null)));
                SnapshotsService.this.startCloning(this.val$repository, this.newEntry);
            }
        }, "clone_snapshot [" + request.source() + "][" + snapshotName + "]", listener::onFailure);
    }

    private static void ensureNoCleanupInProgress(ClusterState currentState, String repositoryName, String snapshotName, String reason) {
        RepositoryCleanupInProgress repositoryCleanupInProgress = RepositoryCleanupInProgress.get(currentState);
        if (repositoryCleanupInProgress.hasCleanupInProgress()) {
            throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot " + reason + " while a repository cleanup is in-progress in " + String.valueOf(repositoryCleanupInProgress.entries().stream().map(RepositoryCleanupInProgress.Entry::repository).collect(Collectors.toSet())));
        }
    }

    private static void ensureSnapshotNameAvailableInRepo(RepositoryData repositoryData, String snapshotName, Repository repository) {
        if (repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
            throw new SnapshotNameAlreadyInUseException(repository.getMetadata().name(), snapshotName, "snapshot with the same name already exists");
        }
    }

    private void startCloning(Repository repository, final SnapshotsInProgress.Entry cloneEntry) {
        Collection<IndexId> indices = cloneEntry.indices().values();
        SnapshotId sourceSnapshot = cloneEntry.source();
        Snapshot targetSnapshot = cloneEntry.snapshot();
        ExecutorService executor = this.threadPool.executor("snapshot");
        Consumer<Exception> onFailure = e -> {
            this.endingSnapshots.add(targetSnapshot);
            this.initializingClones.remove(targetSnapshot);
            logger.info(() -> "Failed to start snapshot clone [" + String.valueOf(cloneEntry) + "]", (Throwable)e);
            this.removeFailedSnapshotFromClusterState(targetSnapshot, (Exception)e, null, ShardGenerations.EMPTY);
        };
        ListenableFuture<SnapshotInfo> snapshotInfoListener = new ListenableFuture<SnapshotInfo>();
        repository.getSnapshotInfo(sourceSnapshot, snapshotInfoListener);
        ListenableFuture allShardCountsListener = new ListenableFuture();
        GroupedActionListener shardCountListener = new GroupedActionListener(indices.size(), allShardCountsListener);
        snapshotInfoListener.addListener(ActionListener.wrap(snapshotInfo -> {
            for (IndexId indexId : indices) {
                if (!RestoreService.failed(snapshotInfo, indexId.getName())) continue;
                throw new SnapshotException(targetSnapshot, "Can't clone index [" + String.valueOf(indexId) + "] because its snapshot was not successful.");
            }
            repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, ActionListener.wrap(repositoryData -> {
                for (IndexId index : indices) {
                    executor.execute(ActionRunnable.supply(shardCountListener, () -> {
                        IndexMetadata metadata = repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, sourceSnapshot, index);
                        return Tuple.tuple((Object)index, (Object)metadata.getNumberOfShards());
                    }));
                }
            }, onFailure));
        }, onFailure));
        allShardCountsListener.addListener(ActionListener.wrap(counts -> this.executeConsistentStateUpdate(repository, repoData -> new ClusterStateUpdateTask((RepositoryData)repoData, (Collection)counts, targetSnapshot, repository){
            private SnapshotsInProgress.Entry updatedEntry;
            final /* synthetic */ RepositoryData val$repoData;
            final /* synthetic */ Collection val$counts;
            final /* synthetic */ Snapshot val$targetSnapshot;
            final /* synthetic */ Repository val$repository;
            {
                this.val$repoData = repositoryData;
                this.val$counts = collection;
                this.val$targetSnapshot = snapshot;
                this.val$repository = repository;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
                String repoName = cloneEntry.repository();
                List<SnapshotsInProgress.Entry> existingEntries = snapshotsInProgress.forRepo(repoName);
                ArrayList<SnapshotsInProgress.Entry> updatedEntries = new ArrayList<SnapshotsInProgress.Entry>(existingEntries.size());
                String localNodeId = currentState.nodes().getLocalNodeId();
                ShardGenerations shardGenerations = this.val$repoData.shardGenerations();
                for (SnapshotsInProgress.Entry existing : existingEntries) {
                    if (cloneEntry.snapshot().getSnapshotId().equals(existing.snapshot().getSnapshotId())) {
                        ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = ImmutableOpenMap.builder();
                        boolean readyToExecute = !SnapshotDeletionsInProgress.get(currentState).hasExecutingDeletion(repoName);
                        InFlightShardSnapshotStates inFlightShardStates = readyToExecute ? InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(repoName)) : null;
                        for (Tuple count : this.val$counts) {
                            for (int shardId = 0; shardId < (Integer)count.v2(); ++shardId) {
                                RepositoryShardId repoShardId = new RepositoryShardId((IndexId)count.v1(), shardId);
                                String indexName = repoShardId.indexName();
                                if (!readyToExecute || inFlightShardStates.isActive(indexName, shardId)) {
                                    clonesBuilder.put(repoShardId, SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED);
                                    continue;
                                }
                                clonesBuilder.put(repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(repoShardId.index(), shardId, shardGenerations)));
                            }
                        }
                        this.updatedEntry = cloneEntry.withClones(clonesBuilder.build());
                        continue;
                    }
                    updatedEntries.add(existing);
                }
                if (this.updatedEntry != null) {
                    updatedEntries.add(this.updatedEntry);
                    return SnapshotsService.updateWithSnapshots(currentState, snapshotsInProgress.withUpdatedEntriesForRepo(repoName, updatedEntries), null);
                }
                return currentState;
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                logger.info(() -> "Failed to start snapshot clone [" + String.valueOf(cloneEntry) + "]", (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                if (this.updatedEntry != null) {
                    Snapshot target = this.updatedEntry.snapshot();
                    SnapshotId sourceSnapshot = this.updatedEntry.source();
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> indexClone : this.updatedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                        SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore = indexClone.getValue();
                        if (shardStatusBefore.state() != SnapshotsInProgress.ShardState.INIT) continue;
                        RepositoryShardId repoShardId = indexClone.getKey();
                        SnapshotsService.this.runReadyClone(target, sourceSnapshot, shardStatusBefore, repoShardId, this.val$repository);
                    }
                } else {
                    logger.warn("Did not find expected entry [{}] in the cluster state", (Object)cloneEntry);
                }
            }

            public String toString() {
                return org.elasticsearch.common.Strings.format("start snapshot clone [%s] from [%s]", this.updatedEntry.snapshot(), this.updatedEntry.source());
            }
        }, "start snapshot clone", onFailure), onFailure));
    }

    private void runReadyClone(Snapshot target, SnapshotId sourceSnapshot, SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore, RepositoryShardId repoShardId, Repository repository) {
        SnapshotId targetSnapshot = target.getSnapshotId();
        String localNodeId = this.clusterService.localNode().getId();
        if (this.currentlyCloning.add(repoShardId)) {
            repository.cloneShardSnapshot(sourceSnapshot, targetSnapshot, repoShardId, shardStatusBefore.generation(), ActionListener.wrap(shardSnapshotResult -> this.innerUpdateSnapshotState(target, null, repoShardId, SnapshotsInProgress.ShardSnapshotStatus.success(localNodeId, shardSnapshotResult), ActionListener.runBefore(ActionListener.wrap(v -> logger.trace("Marked [{}] as successfully cloned from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), e -> {
                logger.warn("Cluster state update after successful shard clone [{}] failed", (Object)repoShardId);
                this.failAllListenersOnMasterFailOver((Exception)e);
            }), () -> this.currentlyCloning.remove(repoShardId))), e -> this.innerUpdateSnapshotState(target, null, repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.ShardState.FAILED, shardStatusBefore.generation(), "failed to clone shard snapshot"), ActionListener.runBefore(ActionListener.wrap(v -> logger.trace("Marked [{}] as failed clone from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), ex -> {
                logger.warn("Cluster state update after failed shard clone [{}] failed", (Object)repoShardId);
                this.failAllListenersOnMasterFailOver((Exception)ex);
            }), () -> this.currentlyCloning.remove(repoShardId)))));
        }
    }

    private void ensureBelowConcurrencyLimit(String repository, String name, SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress) {
        int maxOps;
        int inProgressOperations = snapshotsInProgress.count() + deletionsInProgress.getEntries().size();
        if (inProgressOperations >= (maxOps = this.maxConcurrentOperations)) {
            throw new ConcurrentSnapshotExecutionException(repository, name, "Cannot start another operation, already running [" + inProgressOperations + "] operations and the current limit for concurrent snapshot operations is set to [" + maxOps + "]");
        }
    }

    public static void ensureRepositoryExists(String repoName, ClusterState state) {
        if (RepositoriesMetadata.get(state).repository(repoName) == null) {
            throw new RepositoryMissingException(repoName);
        }
    }

    private static void validate(String repositoryName, String snapshotName, ClusterState state) {
        if (RepositoriesMetadata.get(state).repository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
        SnapshotsService.validate(repositoryName, snapshotName);
    }

    private static void validate(String repositoryName, String snapshotName) {
        if (!org.elasticsearch.common.Strings.hasLength(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "cannot be empty");
        }
        if (snapshotName.contains(" ")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain whitespace");
        }
        if (snapshotName.contains(",")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain ','");
        }
        if (snapshotName.contains("#")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must be lowercase");
        }
        if (!org.elasticsearch.common.Strings.validFileName(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain the following characters " + org.elasticsearch.common.Strings.INVALID_FILENAME_CHARS);
        }
    }

    private static ShardGenerations buildGenerations(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        ShardGenerations.Builder builder = ShardGenerations.builder();
        if (snapshot.isClone()) {
            snapshot.shardSnapshotStatusByRepoShardId().forEach((key, value) -> builder.put(key.index(), key.shardId(), (SnapshotsInProgress.ShardSnapshotStatus)value));
        } else {
            snapshot.shardSnapshotStatusByRepoShardId().forEach((key, value) -> {
                Index index = snapshot.indexByName(key.indexName());
                if (metadata.index(index) == null) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(index) + "] was deleted during a snapshot but snapshot was not partial.";
                    return;
                }
                builder.put(key.index(), key.shardId(), (SnapshotsInProgress.ShardSnapshotStatus)value);
            });
        }
        return builder.build();
    }

    private static Metadata metadataForSnapshot(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        Metadata.Builder builder;
        if (!snapshot.includeGlobalState()) {
            builder = Metadata.builder();
            for (IndexId index : snapshot.indices().values()) {
                IndexMetadata indexMetadata = metadata.index(index.getName());
                if (indexMetadata == null) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(index) + "] was deleted during a snapshot but snapshot was not partial.";
                    continue;
                }
                builder.put(indexMetadata, false);
            }
        } else {
            builder = Metadata.builder(metadata);
        }
        HashMap<String, DataStream> dataStreams = new HashMap<String, DataStream>();
        Set<String> indicesInSnapshot = snapshot.indices().keySet();
        for (String dataStreamName : snapshot.dataStreams()) {
            DataStream dataStream = metadata.dataStreams().get(dataStreamName);
            if (dataStream == null) {
                assert (snapshot.partial()) : "Data stream [" + dataStreamName + "] was deleted during a snapshot but snapshot was not partial.";
                continue;
            }
            DataStream reconciled = dataStream.snapshot(indicesInSnapshot, builder);
            if (reconciled == null) continue;
            dataStreams.put(dataStreamName, reconciled);
        }
        return builder.dataStreams(dataStreams, SnapshotsService.filterDataStreamAliases(dataStreams, metadata.dataStreamAliases())).build();
    }

    public static List<SnapshotsInProgress.Entry> currentSnapshots(@Nullable SnapshotsInProgress snapshotsInProgress, String repository, List<String> snapshots) {
        if (snapshotsInProgress == null || snapshotsInProgress.isEmpty()) {
            return Collections.emptyList();
        }
        if ("_all".equals(repository)) {
            return snapshotsInProgress.asStream().toList();
        }
        if (snapshots.isEmpty()) {
            return snapshotsInProgress.forRepo(repository);
        }
        ArrayList<SnapshotsInProgress.Entry> builder = new ArrayList<SnapshotsInProgress.Entry>();
        block0: for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(repository)) {
            for (String snapshot : snapshots) {
                if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                builder.add(entry);
                continue block0;
            }
        }
        return Collections.unmodifiableList(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        block14: {
            try {
                if (event.localNodeMaster()) {
                    SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(event.state());
                    boolean newMaster = !event.previousState().nodes().isLocalNodeElectedMaster();
                    this.processExternalChanges(newMaster || SnapshotsService.removedNodesCleanupNeeded(snapshotsInProgress, event.nodesDelta().removedNodes()), snapshotsInProgress.nodeIdsForRemovalChanged(SnapshotsInProgress.get(event.previousState())) || event.routingTableChanged() && SnapshotsService.waitingShardsStartedOrUnassigned(snapshotsInProgress, event));
                    if (newMaster || !event.state().metadata().nodeShutdowns().equals(event.previousState().metadata().nodeShutdowns()) || SnapshotsService.supportsNodeRemovalTracking(event.state()) != SnapshotsService.supportsNodeRemovalTracking(event.previousState())) {
                        this.updateNodeIdsToRemoveQueue.submitTask("SnapshotsService#updateNodeIdsToRemove", new UpdateNodeIdsForRemovalTask(), null);
                    }
                    break block14;
                }
                ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
                Set<String> set = this.currentlyFinalizing;
                synchronized (set) {
                    for (Snapshot snapshot : this.snapshotCompletionListeners.keySet()) {
                        if (!this.endingSnapshots.add(snapshot)) continue;
                        this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"), readyToResolveListeners::add);
                        assert (!this.endingSnapshots.contains(snapshot)) : snapshot;
                    }
                    if (!this.snapshotDeletionListeners.isEmpty()) {
                        NotMasterException cause = new NotMasterException("no longer master");
                        Iterator<List<ActionListener<Void>>> it = this.snapshotDeletionListeners.values().iterator();
                        while (it.hasNext()) {
                            List<ActionListener<Void>> listeners = it.next();
                            readyToResolveListeners.add(() -> SnapshotsService.failListenersIgnoringException(listeners, cause));
                            it.remove();
                        }
                    }
                }
                readyToResolveListeners.forEach(Runnable::run);
            }
            catch (Exception e) {
                assert (false) : new AssertionError((Object)e);
                logger.warn("Failed to update snapshot state ", (Throwable)e);
            }
        }
        assert (this.assertConsistentWithClusterState(event.state()));
        assert (SnapshotsService.assertNoDanglingSnapshots(event.state()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertConsistentWithClusterState(ClusterState state) {
        SnapshotDeletionsInProgress snapshotDeletionsInProgress;
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(state);
        if (!snapshotsInProgress.isEmpty()) {
            Set<Snapshot> set = this.endingSnapshots;
            synchronized (set) {
                Set runningSnapshots = Stream.concat(snapshotsInProgress.asStream().map(SnapshotsInProgress.Entry::snapshot), this.endingSnapshots.stream()).collect(Collectors.toSet());
                Set<Snapshot> snapshotListenerKeys = this.snapshotCompletionListeners.keySet();
                assert (runningSnapshots.containsAll(snapshotListenerKeys)) : "Saw completion listeners for unknown snapshots in " + String.valueOf(snapshotListenerKeys) + " but running snapshots are " + String.valueOf(runningSnapshots);
            }
        }
        if ((snapshotDeletionsInProgress = SnapshotDeletionsInProgress.get(state)).hasDeletionsInProgress()) {
            Set<String> set = this.repositoryOperations.runningDeletions;
            synchronized (set) {
                Set runningDeletes = Stream.concat(snapshotDeletionsInProgress.getEntries().stream().map(SnapshotDeletionsInProgress.Entry::uuid), this.repositoryOperations.runningDeletions.stream()).collect(Collectors.toSet());
                Set<String> deleteListenerKeys = this.snapshotDeletionListeners.keySet();
                assert (runningDeletes.containsAll(deleteListenerKeys)) : "Saw deletions listeners for unknown uuids in " + String.valueOf(deleteListenerKeys) + " but running deletes are " + String.valueOf(runningDeletes);
            }
        }
        return true;
    }

    private static boolean assertNoDanglingSnapshots(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(state);
        SnapshotDeletionsInProgress snapshotDeletionsInProgress = SnapshotDeletionsInProgress.get(state);
        Set reposWithRunningDelete = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
        for (List<SnapshotsInProgress.Entry> repoEntry : snapshotsInProgress.entriesByRepo()) {
            SnapshotsInProgress.Entry entry2 = repoEntry.get(0);
            for (SnapshotsInProgress.ShardSnapshotStatus value : entry2.shardSnapshotStatusByRepoShardId().values()) {
                if (value.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                    assert (reposWithRunningDelete.contains(entry2.repository())) : "Found shard snapshot waiting to be assigned in [" + String.valueOf(entry2) + "] but it is not blocked by any running delete";
                    continue;
                }
                if (value.isActive()) assert (!reposWithRunningDelete.contains(entry2.repository())) : "Found shard snapshot actively executing in [" + String.valueOf(entry2) + "] when it should be blocked by a running delete [" + org.elasticsearch.common.Strings.toString(snapshotDeletionsInProgress) + "]";
            }
        }
        return true;
    }

    private void processExternalChanges(final boolean changedNodes, boolean changedShards) {
        if (!changedNodes && !changedShards) {
            return;
        }
        final String source = "update snapshot after shards changed [" + changedShards + "] or node configuration changed [" + changedNodes + "]";
        this.submitUnbatchedTask(source, new ClusterStateUpdateTask(){
            private final Collection<SnapshotsInProgress.Entry> finishedSnapshots = new ArrayList<SnapshotsInProgress.Entry>();
            private final Collection<SnapshotDeletionsInProgress.Entry> deletionsToExecute = new ArrayList<SnapshotDeletionsInProgress.Entry>();

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable routingTable = currentState.routingTable();
                SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
                SnapshotDeletionsInProgress deletesInProgress = SnapshotDeletionsInProgress.get(currentState);
                DiscoveryNodes nodes = currentState.nodes();
                EnumSet<SnapshotsInProgress.State> statesToUpdate = changedNodes ? EnumSet.of(SnapshotsInProgress.State.STARTED, SnapshotsInProgress.State.ABORTED) : EnumSet.of(SnapshotsInProgress.State.STARTED);
                SnapshotsInProgress updatedSnapshots = snapshotsInProgress;
                for (List<SnapshotsInProgress.Entry> snapshotsInRepo : snapshotsInProgress.entriesByRepo()) {
                    boolean changed = false;
                    ArrayList<SnapshotsInProgress.Entry> updatedEntriesForRepo = new ArrayList<SnapshotsInProgress.Entry>();
                    HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures = new HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus>();
                    String repositoryName = snapshotsInRepo.get(0).repository();
                    for (SnapshotsInProgress.Entry snapshotEntry : snapshotsInRepo) {
                        if (statesToUpdate.contains((Object)snapshotEntry.state())) {
                            if (snapshotEntry.isClone()) {
                                if (snapshotEntry.shardSnapshotStatusByRepoShardId().isEmpty()) {
                                    if (SnapshotsService.this.initializingClones.contains(snapshotEntry.snapshot())) {
                                        updatedEntriesForRepo.add(snapshotEntry);
                                        continue;
                                    }
                                    logger.debug("removing not yet started clone operation [{}]", (Object)snapshotEntry);
                                    changed = true;
                                    continue;
                                }
                                if (deletesInProgress.hasExecutingDeletion(repositoryName)) {
                                    updatedEntriesForRepo.add(snapshotEntry);
                                    continue;
                                }
                                ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clones = null;
                                InFlightShardSnapshotStates inFlightShardSnapshotStates = null;
                                for (Map.Entry failureEntry : knownFailures.entrySet()) {
                                    RepositoryShardId repositoryShardId = (RepositoryShardId)failureEntry.getKey();
                                    SnapshotsInProgress.ShardSnapshotStatus existingStatus = snapshotEntry.shardSnapshotStatusByRepoShardId().get(repositoryShardId);
                                    if (!SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED.equals(existingStatus)) continue;
                                    if (inFlightShardSnapshotStates == null) {
                                        inFlightShardSnapshotStates = InFlightShardSnapshotStates.forEntries(updatedEntriesForRepo);
                                    }
                                    if (inFlightShardSnapshotStates.isActive(repositoryShardId.indexName(), repositoryShardId.shardId())) continue;
                                    if (clones == null) {
                                        clones = ImmutableOpenMap.builder(snapshotEntry.shardSnapshotStatusByRepoShardId());
                                    }
                                    clones.put(repositoryShardId, new SnapshotsInProgress.ShardSnapshotStatus(nodes.getLocalNodeId(), ((SnapshotsInProgress.ShardSnapshotStatus)failureEntry.getValue()).generation()));
                                }
                                if (clones != null) {
                                    changed = true;
                                    updatedEntriesForRepo.add(snapshotEntry.withClones(clones.build()));
                                    continue;
                                }
                                updatedEntriesForRepo.add(snapshotEntry);
                                continue;
                            }
                            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsService.processWaitingShardsAndRemovedNodes(snapshotEntry, routingTable, nodes, snapshotsInProgress::isNodeIdForRemoval, knownFailures);
                            if (shards != null) {
                                SnapshotsInProgress.Entry updatedSnapshot = snapshotEntry.withShardStates(shards);
                                changed = true;
                                if (updatedSnapshot.state().completed()) {
                                    this.finishedSnapshots.add(updatedSnapshot);
                                }
                                updatedEntriesForRepo.add(updatedSnapshot);
                                continue;
                            }
                            updatedEntriesForRepo.add(snapshotEntry);
                            continue;
                        }
                        if (snapshotEntry.repositoryStateId() == -2L) {
                            changed = true;
                            logger.debug("[{}] was found in dangling INIT or ABORTED state", (Object)snapshotEntry);
                            continue;
                        }
                        if (snapshotEntry.state().completed() || SnapshotsInProgress.completed(snapshotEntry.shardSnapshotStatusByRepoShardId().values())) {
                            this.finishedSnapshots.add(snapshotEntry);
                        }
                        updatedEntriesForRepo.add(snapshotEntry);
                    }
                    if (!changed) continue;
                    updatedSnapshots = updatedSnapshots.withUpdatedEntriesForRepo(repositoryName, updatedEntriesForRepo);
                }
                ClusterState res = (ClusterState)SnapshotsService.readyDeletions(updatedSnapshots != snapshotsInProgress ? ClusterState.builder(currentState).putCustom("snapshots", updatedSnapshots).build() : currentState).v1();
                for (SnapshotDeletionsInProgress.Entry delete : SnapshotDeletionsInProgress.get(res).getEntries()) {
                    if (delete.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionsToExecute.add(delete);
                }
                return res;
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format((String)"failed to update snapshot state after shards started or nodes removed from [%s] ", (Object[])new Object[]{source}), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                SnapshotDeletionsInProgress snapshotDeletionsInProgress = SnapshotDeletionsInProgress.get(newState);
                if (!this.finishedSnapshots.isEmpty()) {
                    Set reposWithRunningDeletes = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
                    for (SnapshotsInProgress.Entry entry2 : this.finishedSnapshots) {
                        if (reposWithRunningDeletes.contains(entry2.repository())) continue;
                        SnapshotsService.this.endSnapshot(entry2, newState.metadata(), null);
                    }
                }
                SnapshotsService.this.startExecutableClones(SnapshotsInProgress.get(newState), null);
                for (SnapshotDeletionsInProgress.Entry entry3 : this.deletionsToExecute) {
                    if (!SnapshotsService.this.tryEnterRepoLoop(entry3.repository())) continue;
                    SnapshotsService.this.deleteSnapshotsFromRepository(entry3, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                }
            }
        });
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> processWaitingShardsAndRemovedNodes(SnapshotsInProgress.Entry snapshotEntry, RoutingTable routingTable, DiscoveryNodes nodes, Predicate<String> nodeIdRemovalPredicate, Map<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures) {
        assert (!snapshotEntry.isClone()) : "clones take a different path";
        boolean snapshotChanged = false;
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardSnapshotEntry : snapshotEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
            SnapshotsInProgress.ShardSnapshotStatus shardStatus = shardSnapshotEntry.getValue();
            ShardId shardId = snapshotEntry.shardId(shardSnapshotEntry.getKey());
            if (shardStatus.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                SnapshotsInProgress.ShardSnapshotStatus knownFailure = knownFailures.get(shardSnapshotEntry.getKey());
                if (knownFailure == null) {
                    IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                    if (indexShardRoutingTable == null) {
                        assert (snapshotEntry.partial());
                        snapshotChanged = true;
                        logger.debug("failing snapshot of shard [{}] because index got deleted", (Object)shardId);
                        shards.put(shardId, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                        knownFailures.put(shardSnapshotEntry.getKey(), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                        continue;
                    }
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                shards.put(shardId, knownFailure);
                continue;
            }
            if (shardStatus.state() == SnapshotsInProgress.ShardState.WAITING || shardStatus.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
                IndexShardRoutingTable shardRouting;
                IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                if (indexShardRoutingTable != null && (shardRouting = indexShardRoutingTable.shard(shardId.id())) != null) {
                    String primaryNodeId = shardRouting.primaryShard().currentNodeId();
                    if (nodeIdRemovalPredicate.test(primaryNodeId)) {
                        if (shardStatus.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
                            shards.put(shardId, shardStatus);
                            continue;
                        }
                        snapshotChanged = true;
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primaryNodeId, SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().started()) {
                        snapshotChanged = true;
                        logger.debug("Starting shard [{}] with shard generation [{}] that we were waiting to start on node [{}]. Previous shard state [{}]\n", (Object)shardId, (Object)shardStatus.generation(), (Object)shardStatus.nodeId(), (Object)shardStatus.state());
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primaryNodeId, shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().initializing() || shardRouting.primaryShard().relocating()) {
                        shards.put(shardId, shardStatus);
                        continue;
                    }
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on node [{}] because shard is unassigned", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, shardStatus.generation(), "shard is unassigned");
                shards.put(shardId, failedState);
                knownFailures.put(shardSnapshotEntry.getKey(), failedState);
                continue;
            }
            if (!shardStatus.state().completed() && shardStatus.nodeId() != null) {
                if (nodes.nodeExists(shardStatus.nodeId())) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on departed node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, shardStatus.generation(), "node left the cluster during snapshot");
                shards.put(shardId, failedState);
                knownFailures.put(shardSnapshotEntry.getKey(), failedState);
                continue;
            }
            shards.put(shardId, shardStatus);
        }
        if (snapshotChanged) {
            return shards.build();
        }
        return null;
    }

    private static boolean waitingShardsStartedOrUnassigned(SnapshotsInProgress snapshotsInProgress, ClusterChangedEvent event) {
        for (List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo()) {
            for (SnapshotsInProgress.Entry entry : entries) {
                if (entry.state() != SnapshotsInProgress.State.STARTED || entry.isClone()) continue;
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardStatus : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    RepositoryShardId shardId;
                    SnapshotsInProgress.ShardState state = shardStatus.getValue().state();
                    if (state != SnapshotsInProgress.ShardState.WAITING && state != SnapshotsInProgress.ShardState.QUEUED && state != SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL || !event.indexRoutingTableChanged((shardId = shardStatus.getKey()).indexName())) continue;
                    IndexRoutingTable indexShardRoutingTable = event.state().getRoutingTable().index(entry.indexByName(shardId.indexName()));
                    if (indexShardRoutingTable == null) {
                        return true;
                    }
                    ShardRouting shardRouting = indexShardRoutingTable.shard(shardId.shardId()).primaryShard();
                    if ((!shardRouting.started() || snapshotsInProgress.isNodeIdForRemoval(shardRouting.currentNodeId())) && !shardRouting.unassigned()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean removedNodesCleanupNeeded(SnapshotsInProgress snapshotsInProgress, List<DiscoveryNode> removedNodes) {
        if (removedNodes.isEmpty()) {
            return false;
        }
        Set removedNodeIds = removedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        return snapshotsInProgress.asStream().anyMatch(snapshot -> {
            if (snapshot.state().completed() || snapshot.isClone()) {
                return false;
            }
            for (SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus : snapshot.shardSnapshotStatusByRepoShardId().values()) {
                if (shardSnapshotStatus.state().completed() || !removedNodeIds.contains(shardSnapshotStatus.nodeId())) continue;
                return true;
            }
            return false;
        });
    }

    private void endSnapshot(SnapshotsInProgress.Entry entry, final Metadata metadata, @Nullable RepositoryData repositoryData) {
        final Snapshot snapshot = entry.snapshot();
        final boolean newFinalization = this.endingSnapshots.add(snapshot);
        if (entry.isClone() && entry.state() == SnapshotsInProgress.State.FAILED) {
            logger.debug("Removing failed snapshot clone [{}] from cluster state", (Object)entry);
            if (newFinalization) {
                this.removeFailedSnapshotFromClusterState(snapshot, new SnapshotException(snapshot, entry.failure()), null, ShardGenerations.EMPTY);
            }
            return;
        }
        final String repoName = snapshot.getRepository();
        if (this.tryEnterRepoLoop(repoName)) {
            if (repositoryData == null) {
                this.repositoriesService.repository(repoName).getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, new ActionListener<RepositoryData>(){

                    @Override
                    public void onResponse(RepositoryData repositoryData) {
                        if (newFinalization) {
                            SnapshotsService.this.finalizeSnapshotEntry(snapshot, metadata, repositoryData);
                        } else {
                            SnapshotsService.this.runNextQueuedOperation(repositoryData, repoName, false);
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        SnapshotsService.this.submitUnbatchedTask("fail repo tasks for [" + repoName + "]", new FailPendingRepoTasksTask(repoName, e));
                    }
                });
            } else if (newFinalization) {
                this.finalizeSnapshotEntry(snapshot, metadata, repositoryData);
            } else {
                this.runNextQueuedOperation(repositoryData, repoName, false);
            }
        } else if (newFinalization) {
            this.repositoryOperations.addFinalization(snapshot, metadata);
        }
    }

    private boolean tryEnterRepoLoop(String repository) {
        return this.currentlyFinalizing.add(repository);
    }

    private void leaveRepoLoop(String repository) {
        boolean removed = this.currentlyFinalizing.remove(repository);
        assert (removed);
    }

    private void finalizeSnapshotEntry(final Snapshot snapshot, Metadata metadata, RepositoryData repositoryData) {
        assert (this.currentlyFinalizing.contains(snapshot.getRepository()));
        assert (this.repositoryOperations.assertNotQueued(snapshot));
        try {
            SnapshotsInProgress.Entry entry = SnapshotsInProgress.get(this.clusterService.state()).snapshot(snapshot);
            String failure = entry.failure();
            logger.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", (Object)snapshot, (Object)entry.state(), (Object)failure);
            ShardGenerations shardGenerations = SnapshotsService.buildGenerations(entry, metadata);
            List<String> finalIndices = shardGenerations.indices().stream().map(IndexId::getName).toList();
            HashSet<String> indexNames = new HashSet<String>(finalIndices);
            ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardStatus : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                RepositoryShardId shardId = shardStatus.getKey();
                if (!indexNames.contains(shardId.indexName())) {
                    assert (entry.partial()) : "only ignoring shard failures for concurrently deleted indices for partial snapshots";
                    continue;
                }
                SnapshotsInProgress.ShardSnapshotStatus status = shardStatus.getValue();
                SnapshotsInProgress.ShardState state = status.state();
                if (state.failed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), entry.shardId(shardId), status.reason()));
                    continue;
                }
                if (!state.completed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), entry.shardId(shardId), "skipped"));
                    continue;
                }
                assert (state == SnapshotsInProgress.ShardState.SUCCESS);
            }
            String repository = snapshot.getRepository();
            ListenableFuture<Metadata> metadataListener = new ListenableFuture<Metadata>();
            Repository repo = this.repositoriesService.repository(snapshot.getRepository());
            if (entry.isClone()) {
                this.threadPool.executor("snapshot").execute(ActionRunnable.supply(metadataListener, () -> {
                    Metadata existing = repo.getSnapshotGlobalMetadata(entry.source());
                    Metadata.Builder metaBuilder = Metadata.builder(existing);
                    HashSet<Index> existingIndices = new HashSet<Index>();
                    for (IndexId indexId : entry.indices().values()) {
                        IndexMetadata indexMetadata = repo.getSnapshotIndexMetaData(repositoryData, entry.source(), indexId);
                        existingIndices.add(indexMetadata.getIndex());
                        metaBuilder.put(indexMetadata, false);
                    }
                    HashMap<String, DataStream> dataStreamsToCopy = new HashMap<String, DataStream>();
                    for (Map.Entry<String, DataStream> entry2 : existing.dataStreams().entrySet()) {
                        if (!existingIndices.containsAll(entry2.getValue().getIndices())) continue;
                        dataStreamsToCopy.put(entry2.getKey(), entry2.getValue());
                    }
                    Map<String, DataStreamAlias> map = SnapshotsService.filterDataStreamAliases(dataStreamsToCopy, existing.dataStreamAliases());
                    metaBuilder.dataStreams(dataStreamsToCopy, map);
                    return metaBuilder.build();
                }));
            } else {
                metadataListener.onResponse(metadata);
            }
            metadataListener.addListener(ActionListener.wrap(meta -> {
                Metadata metaForSnapshot = SnapshotsService.metadataForSnapshot(entry, meta);
                Map<String, SnapshotInfo.IndexSnapshotDetails> indexSnapshotDetails = Maps.newMapWithExpectedSize(finalIndices.size());
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    indexSnapshotDetails.compute(shardEntry.getKey().indexName(), (indexName, current) -> {
                        if (current == SnapshotInfo.IndexSnapshotDetails.SKIPPED) {
                            return current;
                        }
                        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue();
                        if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            return SnapshotInfo.IndexSnapshotDetails.SKIPPED;
                        }
                        ShardSnapshotResult result = shardSnapshotStatus.shardSnapshotResult();
                        if (result == null) {
                            return SnapshotInfo.IndexSnapshotDetails.SKIPPED;
                        }
                        if (current == null) {
                            return new SnapshotInfo.IndexSnapshotDetails(1, result.getSize(), result.getSegmentCount());
                        }
                        return new SnapshotInfo.IndexSnapshotDetails(current.getShardCount() + 1, ByteSizeValue.ofBytes(current.getSize().getBytes() + result.getSize().getBytes()), Math.max(current.getMaxSegmentsPerShard(), result.getSegmentCount()));
                    });
                }
                indexSnapshotDetails.entrySet().removeIf(e -> ((SnapshotInfo.IndexSnapshotDetails)e.getValue()).getShardCount() == 0);
                SnapshotInfo snapshotInfo = new SnapshotInfo(snapshot, finalIndices, entry.dataStreams().stream().filter(metaForSnapshot.dataStreams()::containsKey).toList(), entry.partial() ? SnapshotsService.onlySuccessfulFeatureStates(entry, finalIndices) : entry.featureStates(), failure, this.threadPool.absoluteTimeInMillis(), entry.partial() ? shardGenerations.totalShards() : entry.shardSnapshotStatusByRepoShardId().size(), shardFailures, entry.includeGlobalState(), entry.userMetadata(), entry.startTime(), indexSnapshotDetails);
                ListenableFuture snapshotListeners = new ListenableFuture();
                repo.finalizeSnapshot(new FinalizeSnapshotContext(shardGenerations, repositoryData.getGenId(), metaForSnapshot, snapshotInfo, entry.version(), ActionListener.wrap(updatedRepositoryData -> {
                    snapshotListeners.onResponse(this.endAndGetListenersToResolve(snapshot));
                    this.runNextQueuedOperation((RepositoryData)updatedRepositoryData, repository, true);
                }, e -> this.handleFinalizationFailure((Exception)e, snapshot, repositoryData, shardGenerations)), snInfo -> snapshotListeners.addListener(new ActionListener<List<ActionListener<SnapshotInfo>>>(){

                    @Override
                    public void onResponse(List<ActionListener<SnapshotInfo>> actionListeners) {
                        SnapshotsService.completeListenersIgnoringException(actionListeners, snInfo);
                        logger.info("snapshot [{}] completed with state [{}]", (Object)snapshot, (Object)snInfo.state());
                    }

                    @Override
                    public void onFailure(Exception e) {
                        assert (false) : e;
                    }
                })));
            }, e -> this.handleFinalizationFailure((Exception)e, snapshot, repositoryData, shardGenerations)));
        }
        catch (Exception e2) {
            logger.error(org.elasticsearch.common.Strings.format("unexpected failure finalizing %s", snapshot), (Throwable)e2);
            assert (false) : new AssertionError("unexpected failure finalizing " + String.valueOf(snapshot), e2);
            this.handleFinalizationFailure(e2, snapshot, repositoryData, ShardGenerations.EMPTY);
        }
    }

    private static List<SnapshotFeatureInfo> onlySuccessfulFeatureStates(SnapshotsInProgress.Entry entry, List<String> finalIndices) {
        assert (entry.partial()) : "should not try to filter feature states from a non-partial entry";
        HashSet indicesWithUnsuccessfulShards = new HashSet();
        entry.shardSnapshotStatusByRepoShardId().forEach((key, value) -> {
            SnapshotsInProgress.ShardState shardState = value.state();
            if (shardState.failed() || !shardState.completed()) {
                indicesWithUnsuccessfulShards.add(key.indexName());
            }
        });
        return entry.featureStates().stream().filter(stateInfo -> finalIndices.containsAll(stateInfo.getIndices())).filter(stateInfo -> !stateInfo.getIndices().stream().anyMatch(indicesWithUnsuccessfulShards::contains)).toList();
    }

    private List<ActionListener<SnapshotInfo>> endAndGetListenersToResolve(Snapshot snapshot) {
        List<ActionListener<SnapshotInfo>> listenersToComplete = this.snapshotCompletionListeners.remove(snapshot);
        this.endingSnapshots.remove(snapshot);
        return listenersToComplete;
    }

    private void handleFinalizationFailure(Exception e, Snapshot snapshot, RepositoryData repositoryData, ShardGenerations shardGenerations) {
        if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
            logger.debug(() -> "[" + String.valueOf(snapshot) + "] failed to update cluster state during snapshot finalization", (Throwable)e);
            this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to update cluster state during snapshot finalization", e), Runnable::run);
            this.failAllListenersOnMasterFailOver(e);
        } else {
            logger.warn(() -> "[" + String.valueOf(snapshot) + "] failed to finalize snapshot", (Throwable)e);
            this.removeFailedSnapshotFromClusterState(snapshot, e, repositoryData, shardGenerations);
        }
    }

    private void runNextQueuedOperation(RepositoryData repositoryData, String repository, boolean attemptDelete) {
        assert (this.currentlyFinalizing.contains(repository));
        Tuple<Snapshot, Metadata> nextFinalization = this.repositoryOperations.pollFinalization(repository);
        if (nextFinalization == null) {
            if (attemptDelete) {
                this.runReadyDeletions(repositoryData, repository);
            } else {
                this.leaveRepoLoop(repository);
            }
        } else {
            logger.trace("Moving on to finalizing next snapshot [{}]", nextFinalization);
            this.finalizeSnapshotEntry((Snapshot)nextFinalization.v1(), (Metadata)nextFinalization.v2(), repositoryData);
        }
    }

    private void runReadyDeletions(final RepositoryData repositoryData, final String repository) {
        this.submitUnbatchedTask("Run ready deletions", new ClusterStateUpdateTask(){
            private SnapshotDeletionsInProgress.Entry deletionToRun;

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (SnapshotsService.readyDeletions(currentState).v1() == currentState) : "Deletes should have been set to ready by finished snapshot deletes and finalizations";
                for (SnapshotDeletionsInProgress.Entry entry : SnapshotDeletionsInProgress.get(currentState).getEntries()) {
                    if (!entry.repository().equals(repository) || entry.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionToRun = entry;
                    break;
                }
                return currentState;
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn("Failed to run ready delete operations", (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                if (this.deletionToRun == null) {
                    SnapshotsService.this.runNextQueuedOperation(repositoryData, repository, false);
                } else {
                    SnapshotsService.this.deleteSnapshotsFromRepository(this.deletionToRun, repositoryData, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                }
            }
        });
    }

    private static Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> readyDeletions(ClusterState currentState) {
        SnapshotDeletionsInProgress deletions = SnapshotDeletionsInProgress.get(currentState);
        if (!deletions.hasDeletionsInProgress()) {
            return Tuple.tuple((Object)currentState, List.of());
        }
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)currentState.custom("snapshots");
        assert (snapshotsInProgress != null);
        HashSet<String> repositoriesSeen = new HashSet<String>();
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> readyDeletions = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        ArrayList<SnapshotDeletionsInProgress.Entry> newDeletes = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            String repo = entry.repository();
            if (repositoriesSeen.add(entry.repository()) && entry.state() == SnapshotDeletionsInProgress.State.WAITING && snapshotsInProgress.forRepo(repo).stream().noneMatch(SnapshotsService::isWritingToRepository)) {
                changed = true;
                SnapshotDeletionsInProgress.Entry newEntry = entry.started();
                readyDeletions.add(newEntry);
                newDeletes.add(newEntry);
                continue;
            }
            newDeletes.add(entry);
        }
        return Tuple.tuple((Object)(changed ? ClusterState.builder(currentState).putCustom("snapshot_deletions", SnapshotDeletionsInProgress.of(newDeletes)).build() : currentState), readyDeletions);
    }

    public static ClusterState stateWithoutSnapshot(ClusterState state, Snapshot snapshot, ShardGenerations shardGenerations) {
        SnapshotsInProgress inProgressSnapshots = SnapshotsInProgress.get(state);
        ClusterState result = state;
        int indexOfEntry = -1;
        List<SnapshotsInProgress.Entry> entryList = inProgressSnapshots.forRepo(snapshot.getRepository());
        for (int i = 0; i < entryList.size(); ++i) {
            SnapshotsInProgress.Entry entry = entryList.get(i);
            if (!entry.snapshot().equals(snapshot)) continue;
            indexOfEntry = i;
            break;
        }
        if (indexOfEntry >= 0) {
            int i;
            ArrayList<SnapshotsInProgress.Entry> updatedEntries = new ArrayList<SnapshotsInProgress.Entry>(entryList.size() - 1);
            SnapshotsInProgress.Entry removedEntry = entryList.get(indexOfEntry);
            for (i = 0; i < indexOfEntry; ++i) {
                RepositoryShardId repositoryShardId;
                SnapshotsInProgress.ShardSnapshotStatus shardState;
                ImmutableOpenMap.Builder<Writeable, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments;
                SnapshotsInProgress.Entry previousEntry = entryList.get(i);
                if (removedEntry.isClone()) {
                    if (previousEntry.isClone()) {
                        updatedShardAssignments = null;
                        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                            shardState = finishedShardEntry.getValue();
                            if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS) continue;
                            updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, finishedShardEntry.getKey(), previousEntry.shardSnapshotStatusByRepoShardId());
                        }
                        SnapshotsService.addCloneEntry(updatedEntries, previousEntry, updatedShardAssignments);
                        continue;
                    }
                    updatedShardAssignments = null;
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                        shardState = finishedShardEntry.getValue();
                        repositoryShardId = finishedShardEntry.getKey();
                        if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardSnapshotStatusByRepoShardId().containsKey(repositoryShardId)) continue;
                        updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, previousEntry.shardId(repositoryShardId), previousEntry.shards());
                    }
                    SnapshotsService.addSnapshotEntry(updatedEntries, previousEntry, updatedShardAssignments);
                    continue;
                }
                if (previousEntry.isClone()) {
                    updatedShardAssignments = null;
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                        shardState = finishedShardEntry.getValue();
                        repositoryShardId = finishedShardEntry.getKey();
                        if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardSnapshotStatusByRepoShardId().containsKey(repositoryShardId) || !shardGenerations.hasShardGen(finishedShardEntry.getKey())) continue;
                        updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, repositoryShardId, previousEntry.shardSnapshotStatusByRepoShardId());
                    }
                    SnapshotsService.addCloneEntry(updatedEntries, previousEntry, updatedShardAssignments);
                    continue;
                }
                updatedShardAssignments = null;
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> finishedShardEntry : removedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    shardState = finishedShardEntry.getValue();
                    if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardSnapshotStatusByRepoShardId().containsKey(finishedShardEntry.getKey()) || !shardGenerations.hasShardGen(finishedShardEntry.getKey())) continue;
                    updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, previousEntry.shardId(finishedShardEntry.getKey()), previousEntry.shards());
                }
                SnapshotsService.addSnapshotEntry(updatedEntries, previousEntry, updatedShardAssignments);
            }
            for (i = indexOfEntry + 1; i < entryList.size(); ++i) {
                updatedEntries.add(entryList.get(i));
            }
            result = ClusterState.builder(state).putCustom("snapshots", inProgressSnapshots.withUpdatedEntriesForRepo(snapshot.getRepository(), updatedEntries)).build();
        }
        return (ClusterState)SnapshotsService.readyDeletions(result).v1();
    }

    private static void addSnapshotEntry(List<SnapshotsInProgress.Entry> entries, SnapshotsInProgress.Entry entryToUpdate, @Nullable ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments) {
        if (updatedShardAssignments == null) {
            entries.add(entryToUpdate);
        } else {
            ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedStatus = ImmutableOpenMap.builder(entryToUpdate.shards());
            updatedStatus.putAllFromMap(updatedShardAssignments.build());
            entries.add(entryToUpdate.withShardStates(updatedStatus.build()));
        }
    }

    private static void addCloneEntry(List<SnapshotsInProgress.Entry> entries, SnapshotsInProgress.Entry entryToUpdate, @Nullable ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments) {
        if (updatedShardAssignments == null) {
            entries.add(entryToUpdate);
        } else {
            ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedStatus = ImmutableOpenMap.builder(entryToUpdate.shardSnapshotStatusByRepoShardId());
            updatedStatus.putAllFromMap(updatedShardAssignments.build());
            entries.add(entryToUpdate.withClones(updatedStatus.build()));
        }
    }

    @Nullable
    private static <T> ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> maybeAddUpdatedAssignment(@Nullable ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments, SnapshotsInProgress.ShardSnapshotStatus finishedShardState, T shardId, Map<T, SnapshotsInProgress.ShardSnapshotStatus> statesToUpdate) {
        ShardGeneration newGeneration = finishedShardState.generation();
        SnapshotsInProgress.ShardSnapshotStatus stateToUpdate = statesToUpdate.get(shardId);
        if (stateToUpdate != null && stateToUpdate.state() == SnapshotsInProgress.ShardState.SUCCESS && !Objects.equals(newGeneration, stateToUpdate.generation())) {
            if (updatedShardAssignments == null) {
                updatedShardAssignments = ImmutableOpenMap.builder();
            }
            updatedShardAssignments.put(shardId, stateToUpdate.withUpdatedGeneration(newGeneration));
        }
        return updatedShardAssignments;
    }

    private void removeFailedSnapshotFromClusterState(final Snapshot snapshot, final Exception failure, final @Nullable RepositoryData repositoryData, final ShardGenerations shardGenerations) {
        assert (failure != null) : "Failure must be supplied";
        this.submitUnbatchedTask(REMOVE_SNAPSHOT_METADATA_TASK_SOURCE, new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = SnapshotsService.stateWithoutSnapshot(currentState, snapshot, shardGenerations);
                assert (updatedState == currentState || SnapshotsService.this.endingSnapshots.contains(snapshot)) : "did not track [" + String.valueOf(snapshot) + "] in ending snapshots while removing it from the cluster state";
                return SnapshotsService.updateWithSnapshots(updatedState, null, SnapshotsService.deletionsWithoutSnapshots(SnapshotDeletionsInProgress.get(updatedState), Collections.singletonList(snapshot.getSnapshotId()), snapshot.getRepository()));
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof NotMasterException) {
                    failure.addSuppressed(new SnapshotException(snapshot, "no longer master"));
                }
                logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.WARN, () -> "[" + String.valueOf(snapshot) + "] failed to remove snapshot metadata", (Throwable)e);
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to remove snapshot from cluster state", e), Runnable::run);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure, Runnable::run);
                if (repositoryData != null) {
                    SnapshotsService.this.runNextQueuedOperation(repositoryData, snapshot.getRepository(), true);
                }
            }
        });
    }

    @Nullable
    private static SnapshotDeletionsInProgress deletionsWithoutSnapshots(SnapshotDeletionsInProgress deletions, Collection<SnapshotId> snapshotIds, String repository) {
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(deletions.getEntries().size());
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            if (entry.repository().equals(repository)) {
                ArrayList<SnapshotId> updatedSnapshotIds = new ArrayList<SnapshotId>(entry.snapshots());
                if (updatedSnapshotIds.removeAll(snapshotIds)) {
                    changed = true;
                    updatedEntries.add(entry.withSnapshots(updatedSnapshotIds));
                    continue;
                }
                updatedEntries.add(entry);
                continue;
            }
            updatedEntries.add(entry);
        }
        return changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
    }

    private void failSnapshotCompletionListeners(Snapshot snapshot, Exception e, Consumer<Runnable> failingListenersConsumer) {
        List<ActionListener<SnapshotInfo>> listeners = this.endAndGetListenersToResolve(snapshot);
        failingListenersConsumer.accept(() -> SnapshotsService.failListenersIgnoringException(listeners, e));
        assert (this.repositoryOperations.assertNotQueued(snapshot));
    }

    public void deleteSnapshots(DeleteSnapshotRequest request, ActionListener<Void> listener) {
        String repositoryName = request.repository();
        Object[] snapshotNames = request.snapshots();
        Repository repository = this.repositoriesService.repository(repositoryName);
        this.executeConsistentStateUpdate(repository, arg_0 -> this.lambda$deleteSnapshots$40(request, repositoryName, (String[])snapshotNames, listener, repository, arg_0), "delete snapshot [" + String.valueOf(repository) + "]" + Arrays.toString(snapshotNames), listener::onFailure);
    }

    private static boolean isWritingToRepository(SnapshotsInProgress.Entry entry) {
        if (entry.state().completed()) {
            return true;
        }
        for (SnapshotsInProgress.ShardSnapshotStatus value : entry.shardSnapshotStatusByRepoShardId().values()) {
            if (!value.isActive()) continue;
            return true;
        }
        return false;
    }

    private void addDeleteListener(String deleteUUID, ActionListener<Void> listener) {
        this.snapshotDeletionListeners.computeIfAbsent(deleteUUID, k -> new CopyOnWriteArrayList()).add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext()));
    }

    public static IndexVersion minCompatibleVersion(IndexVersion minNodeVersion, RepositoryData repositoryData, @Nullable Collection<SnapshotId> excluded) {
        IndexVersion minCompatVersion = minNodeVersion;
        Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
        for (SnapshotId snapshotId : snapshotIds.stream().filter(excluded == null ? Predicates.always() : Predicate.not(excluded::contains)).toList()) {
            IndexVersion known = repositoryData.getVersion(snapshotId);
            if (known == null) {
                assert (repositoryData.shardGenerations().totalShards() == 0) : "Saw shard generations [" + String.valueOf(repositoryData.shardGenerations()) + "] but did not have versions tracked for snapshot [" + String.valueOf(snapshotId) + "]";
                return OLD_SNAPSHOT_FORMAT;
            }
            minCompatVersion = IndexVersion.min(minCompatVersion, known);
        }
        return minCompatVersion;
    }

    public static boolean useShardGenerations(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean useIndexGenerations(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(INDEX_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean includesUUIDs(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(UUIDS_IN_REPO_DATA_VERSION);
    }

    public static boolean includeFileInfoWriterUUID(IndexVersion repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(FILE_INFO_WRITER_UUIDS_IN_SHARD_DATA_VERSION);
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final IndexVersion minNodeVersion) {
        final long expectedRepoGen = deleteEntry.repositoryStateId();
        this.repositoriesService.getRepositoryData(deleteEntry.repository(), new ActionListener<RepositoryData>(){

            @Override
            public void onResponse(RepositoryData repositoryData) {
                assert (repositoryData.getGenId() == expectedRepoGen) : "Repository generation should not change as long as a ready delete is found in the cluster state but found [" + expectedRepoGen + "] in cluster state and [" + repositoryData.getGenId() + "] in the repository";
                SnapshotsService.this.deleteSnapshotsFromRepository(deleteEntry, repositoryData, minNodeVersion);
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.submitUnbatchedTask("fail repo tasks for [" + deleteEntry.repository() + "]", new FailPendingRepoTasksTask(deleteEntry.repository(), e));
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    private void executeConsistentStateUpdate(final Repository repository, final Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, final String source, final Consumer<Exception> onFailure) {
        final RepositoryMetadata repositoryMetadataStart = repository.getMetadata();
        repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, ActionListener.wrap(repositoryData -> {
            final ClusterStateUpdateTask updateTask = (ClusterStateUpdateTask)createUpdateTask.apply((RepositoryData)repositoryData);
            this.submitUnbatchedTask(source, new ClusterStateUpdateTask(updateTask.priority(), updateTask.timeout()){
                private boolean executedTask;
                {
                    super(priority, timeout);
                    this.executedTask = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    if (repositoryMetadataStart.equals(RepositoriesMetadata.get(currentState).repository(repository.getMetadata().name()))) {
                        this.executedTask = true;
                        return updateTask.execute(currentState);
                    }
                    return currentState;
                }

                @Override
                public void onFailure(Exception e) {
                    if (this.executedTask) {
                        updateTask.onFailure(e);
                    } else {
                        onFailure.accept(e);
                    }
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    if (this.executedTask) {
                        updateTask.clusterStateProcessed(oldState, newState);
                    } else {
                        SnapshotsService.this.executeConsistentStateUpdate(repository, createUpdateTask, source, onFailure);
                    }
                }
            });
        }, onFailure));
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final RepositoryData repositoryData, IndexVersion minNodeVersion) {
        if (this.repositoryOperations.startDeletion(deleteEntry.uuid())) {
            assert (this.currentlyFinalizing.contains(deleteEntry.repository()));
            List<SnapshotId> snapshotIds = deleteEntry.snapshots();
            assert (deleteEntry.state() == SnapshotDeletionsInProgress.State.STARTED) : "incorrect state for entry [" + String.valueOf(deleteEntry) + "]";
            if (snapshotIds.isEmpty()) {
                this.removeSnapshotDeletionFromClusterState(deleteEntry, repositoryData, listeners -> SnapshotsService.completeListenersIgnoringException(listeners, null));
                return;
            }
            final SubscribableListener doneFuture = new SubscribableListener();
            this.repositoriesService.repository(deleteEntry.repository()).deleteSnapshots(snapshotIds, repositoryData.getGenId(), minNodeVersion, new ActionListener<RepositoryData>(){

                @Override
                public void onResponse(RepositoryData updatedRepoData) {
                    SnapshotsService.this.removeSnapshotDeletionFromClusterState(deleteEntry, updatedRepoData, listeners -> doneFuture.addListener(new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void unused) {
                            SnapshotsService.completeListenersIgnoringException(listeners, null);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            assert (false) : e;
                        }
                    }));
                }

                @Override
                public void onFailure(final Exception e) {
                    logger.warn(() -> {
                        StringBuilder sb = new StringBuilder("failed to complete snapshot deletion for [");
                        org.elasticsearch.common.Strings.collectionToDelimitedStringWithLimit(deleteEntry.snapshots().stream().map(SnapshotId::getName).toList(), ",", 1024, sb);
                        sb.append("] from repository [").append(deleteEntry.repository()).append("]");
                        return sb;
                    }, (Throwable)e);
                    SnapshotsService.this.submitUnbatchedTask("remove snapshot deletion metadata after failed delete", new RemoveSnapshotDeletionAndContinueTask(deleteEntry, repositoryData){

                        @Override
                        protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                            SnapshotsService.failListenersIgnoringException(deleteListeners, e);
                        }
                    });
                }
            }, () -> {
                logger.info("snapshots {} deleted", (Object)snapshotIds);
                doneFuture.onResponse(null);
            });
        }
    }

    private void removeSnapshotDeletionFromClusterState(SnapshotDeletionsInProgress.Entry deleteEntry, final RepositoryData repositoryData, final Consumer<List<ActionListener<Void>>> listenersHandler) {
        this.submitUnbatchedTask("remove snapshot deletion metadata", new RemoveSnapshotDeletionAndContinueTask(deleteEntry, repositoryData){

            @Override
            protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
                SnapshotDeletionsInProgress updatedDeletions = SnapshotsService.deletionsWithoutSnapshots(deletions, this.deleteEntry.snapshots(), this.deleteEntry.repository());
                return updatedDeletions == null ? deletions : updatedDeletions;
            }

            @Override
            protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                assert (repositoryData.getSnapshotIds().stream().noneMatch(this.deleteEntry.snapshots()::contains)) : "Repository data contained snapshot ids " + String.valueOf(repositoryData.getSnapshotIds()) + " that should should been deleted by [" + String.valueOf(this.deleteEntry) + "]";
                listenersHandler.accept(deleteListeners);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllListenersOnMasterFailOver(Exception e) {
        logger.debug("Failing all snapshot operation listeners because this node is not master any longer", (Throwable)e);
        ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
        Set<String> set = this.currentlyFinalizing;
        synchronized (set) {
            if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
                this.repositoryOperations.clear();
                for (Snapshot snapshot : this.snapshotCompletionListeners.keySet()) {
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"), readyToResolveListeners::add);
                }
                RepositoryException wrapped = new RepositoryException("_all", "Failed to update cluster state during repository operation", e, new Object[0]);
                Iterator<List<ActionListener<Void>>> it = this.snapshotDeletionListeners.values().iterator();
                while (it.hasNext()) {
                    List<ActionListener<Void>> listeners = it.next();
                    readyToResolveListeners.add(() -> SnapshotsService.failListenersIgnoringException(listeners, wrapped));
                    it.remove();
                }
                assert (this.snapshotDeletionListeners.isEmpty()) : "No new listeners should have been added but saw " + String.valueOf(this.snapshotDeletionListeners);
            } else {
                assert (false) : new AssertionError("Modifying snapshot state should only ever fail because we failed to publish new state", e);
                logger.error("Unexpected failure during cluster state update", (Throwable)e);
            }
            this.currentlyFinalizing.clear();
        }
        readyToResolveListeners.forEach(Runnable::run);
    }

    public static ClusterState updateWithSnapshots(ClusterState state, @Nullable SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress snapshotDeletionsInProgress) {
        if (snapshotsInProgress == null && snapshotDeletionsInProgress == null) {
            return state;
        }
        ClusterState.Builder builder = ClusterState.builder(state);
        if (snapshotsInProgress != null) {
            builder.putCustom("snapshots", snapshotsInProgress);
        }
        if (snapshotDeletionsInProgress != null) {
            builder.putCustom("snapshot_deletions", snapshotDeletionsInProgress);
        }
        return builder.build();
    }

    private static <T> void failListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, Exception failure) {
        if (listeners != null) {
            try {
                ActionListener.onFailure(listeners, failure);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static <T> void completeListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, T result) {
        if (listeners != null) {
            try {
                ActionListener.onResponse(listeners, result);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards(SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress, ClusterState currentState, Collection<IndexId> indices, boolean useShardGenerations, RepositoryData repositoryData, String repoName) {
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        InFlightShardSnapshotStates inFlightShardStates = InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(repoName));
        boolean readyToExecute = !deletionsInProgress.hasExecutingDeletion(repoName);
        for (IndexId index : indices) {
            String indexName = index.getName();
            boolean isNewIndex = !repositoryData.getIndices().containsKey(indexName);
            IndexMetadata indexMetadata = currentState.metadata().index(indexName);
            if (indexMetadata == null) {
                builder.put(new ShardId(indexName, "_na_", 0), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                continue;
            }
            IndexRoutingTable indexRoutingTable = currentState.routingTable().index(indexName);
            assert (indexRoutingTable != null);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                ShardGeneration shardRepoGeneration;
                ShardId shardId = indexRoutingTable.shard(i).shardId();
                if (useShardGenerations) {
                    ShardGeneration inFlightGeneration = inFlightShardStates.generationForShard(index, shardId.id(), shardGenerations);
                    if (inFlightGeneration == null && isNewIndex) {
                        assert (shardGenerations.getShardGen(index, shardId.getId()) == null) : "Found shard generation for new index [" + String.valueOf(index) + "]";
                        shardRepoGeneration = ShardGenerations.NEW_SHARD_GEN;
                    } else {
                        shardRepoGeneration = inFlightGeneration;
                    }
                } else {
                    shardRepoGeneration = null;
                }
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = !readyToExecute || inFlightShardStates.isActive(shardId.getIndexName(), shardId.id()) ? SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED : SnapshotsService.initShardSnapshotStatus(shardRepoGeneration, indexRoutingTable.shard(i).primaryShard(), snapshotsInProgress::isNodeIdForRemoval);
                builder.put(shardId, shardSnapshotStatus);
            }
        }
        return builder.build();
    }

    private static SnapshotsInProgress.ShardSnapshotStatus initShardSnapshotStatus(ShardGeneration shardRepoGeneration, ShardRouting primary, Predicate<String> nodeIdRemovalPredicate) {
        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = primary == null || !primary.assignedToNode() ? new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, shardRepoGeneration, "primary shard is not allocated") : (primary.relocating() || primary.initializing() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardRepoGeneration) : (nodeIdRemovalPredicate.test(primary.currentNodeId()) ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, shardRepoGeneration) : (!primary.started() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, shardRepoGeneration, "primary shard hasn't been started yet") : new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardRepoGeneration))));
        return shardSnapshotStatus;
    }

    public static Set<String> snapshottingDataStreams(ClusterState currentState, Set<String> dataStreamsToCheck) {
        Map<String, DataStream> dataStreams = currentState.metadata().dataStreams();
        return SnapshotsInProgress.get(currentState).asStream().filter(e -> !e.partial()).flatMap(e -> e.dataStreams().stream()).filter(ds -> dataStreams.containsKey(ds) && dataStreamsToCheck.contains(ds)).collect(Collectors.toSet());
    }

    public static Set<Index> snapshottingIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (List<SnapshotsInProgress.Entry> snapshotsInRepo : SnapshotsInProgress.get(currentState).entriesByRepo()) {
            for (SnapshotsInProgress.Entry entry : snapshotsInRepo) {
                if (entry.partial() || entry.isClone()) continue;
                for (String indexName : entry.indices().keySet()) {
                    IndexMetadata indexMetadata = currentState.metadata().index(indexName);
                    if (indexMetadata == null || !indicesToCheck.contains(indexMetadata.getIndex())) continue;
                    indices.add(indexMetadata.getIndex());
                }
            }
        }
        return indices;
    }

    static Map<String, DataStreamAlias> filterDataStreamAliases(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
        return dataStreamAliases.values().stream().filter(alias -> alias.getDataStreams().stream().anyMatch(dataStreams::containsKey)).map(alias -> alias.intersect(dataStreams::containsKey)).collect(Collectors.toMap(DataStreamAlias::getName, Function.identity()));
    }

    private void addListener(Snapshot snapshot, ActionListener<SnapshotInfo> listener) {
        this.snapshotCompletionListeners.computeIfAbsent(snapshot, k -> new CopyOnWriteArrayList()).add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext()));
    }

    @Override
    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME) != null);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    public boolean assertAllListenersResolved() {
        DiscoveryNode localNode = this.clusterService.localNode();
        assert (this.endingSnapshots.isEmpty()) : "Found leaked ending snapshots " + String.valueOf(this.endingSnapshots) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotCompletionListeners.isEmpty()) : "Found leaked snapshot completion listeners " + String.valueOf(this.snapshotCompletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.currentlyFinalizing.isEmpty()) : "Found leaked finalizations " + String.valueOf(this.currentlyFinalizing) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotDeletionListeners.isEmpty()) : "Found leaked snapshot delete listeners " + String.valueOf(this.snapshotDeletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.repositoryOperations.isEmpty()) : "Found leaked snapshots to finalize " + String.valueOf(this.repositoryOperations) + " on [" + String.valueOf(localNode) + "]";
        return true;
    }

    private static boolean isQueued(@Nullable SnapshotsInProgress.ShardSnapshotStatus status) {
        return status != null && status.state() == SnapshotsInProgress.ShardState.QUEUED;
    }

    private void handleShardSnapshotUpdateCompletion(ShardSnapshotUpdateResult shardSnapshotUpdateResult, List<SnapshotsInProgress.Entry> newlyCompletedEntries, Set<String> updatedRepositories) {
        SnapshotsInProgress snapshotsInProgress = shardSnapshotUpdateResult.snapshotsInProgress();
        for (SnapshotsInProgress.Entry newlyCompletedEntry : newlyCompletedEntries) {
            if (this.endingSnapshots.contains(newlyCompletedEntry.snapshot())) continue;
            this.endSnapshot(newlyCompletedEntry, shardSnapshotUpdateResult.metadata, null);
        }
        for (String updatedRepository : updatedRepositories) {
            this.startExecutableClones(snapshotsInProgress, updatedRepository);
        }
        if (!updatedRepositories.isEmpty()) {
            this.rerouteService.reroute("after shards snapshot update", Priority.NORMAL, ActionListener.noop());
        }
    }

    private void innerUpdateSnapshotState(Snapshot snapshot, ShardId shardId, RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState, ActionListener<Void> listener) {
        ShardSnapshotUpdate update = new ShardSnapshotUpdate(snapshot, shardId, repoShardId, updatedState, listener.delegateFailure((delegate, result) -> delegate.onResponse(null)));
        logger.trace("received updated snapshot restore state [{}]", (Object)update);
        this.masterServiceTaskQueue.submitTask("update snapshot state", update, null);
    }

    private void startExecutableClones(SnapshotsInProgress snapshotsInProgress, @Nullable String repoName) {
        if (repoName == null) {
            for (List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo()) {
                this.startExecutableClones(entries);
            }
        } else {
            this.startExecutableClones(snapshotsInProgress.forRepo(repoName));
        }
    }

    private void startExecutableClones(List<SnapshotsInProgress.Entry> entries) {
        for (SnapshotsInProgress.Entry entry : entries) {
            if (!entry.isClone() || entry.state() != SnapshotsInProgress.State.STARTED) continue;
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clone : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                if (clone.getValue().state() != SnapshotsInProgress.ShardState.INIT) continue;
                this.runReadyClone(entry.snapshot(), entry.source(), clone.getValue(), clone.getKey(), this.repositoriesService.repository(entry.repository()));
            }
        }
    }

    private static void logSnapshotFailure(String operation, Snapshot snapshot, Exception e) {
        Level logLevel = SnapshotsService.snapshotFailureLogLevel(e);
        if (logLevel == Level.INFO && !logger.isDebugEnabled()) {
            logger.info(Strings.format((String)"[%s][%s] failed to %s snapshot: %s", (Object[])new Object[]{snapshot.getRepository(), snapshot.getSnapshotId().getName(), operation, e.getMessage()}));
        } else {
            logger.log(logLevel, () -> Strings.format((String)"[%s][%s] failed to %s snapshot", (Object[])new Object[]{snapshot.getRepository(), snapshot.getSnapshotId().getName(), operation}), (Throwable)e);
        }
    }

    private static Level snapshotFailureLogLevel(Exception e) {
        if (MasterService.isPublishFailureException(e)) {
            return Level.INFO;
        }
        if (e instanceof InvalidSnapshotNameException) {
            return Level.INFO;
        }
        if (e instanceof IndexNotFoundException) {
            return Level.INFO;
        }
        if (e instanceof SnapshotException ? e.getMessage().contains(ReferenceDocs.UNASSIGNED_SHARDS.toString()) : e instanceof IllegalArgumentException) {
            return Level.INFO;
        }
        return Level.WARN;
    }

    private static boolean supportsNodeRemovalTracking(ClusterState clusterState) {
        return clusterState.getMinTransportVersion().onOrAfter(TransportVersions.V_8_13_0);
    }

    private /* synthetic */ ClusterStateUpdateTask lambda$deleteSnapshots$40(final DeleteSnapshotRequest request, final String repositoryName, final String[] snapshotNames, final ActionListener listener, final Repository repository, final RepositoryData repositoryData) {
        return new ClusterStateUpdateTask(request.masterNodeTimeout()){
            private SnapshotDeletionsInProgress.Entry newDelete;
            private boolean reusedExistingDelete;
            private final Collection<Snapshot> completedNoCleanup;
            private final Collection<SnapshotsInProgress.Entry> completedWithCleanup;
            {
                super(timeout);
                this.newDelete = null;
                this.reusedExistingDelete = false;
                this.completedNoCleanup = new ArrayList<Snapshot>();
                this.completedWithCleanup = new ArrayList<SnapshotsInProgress.Entry>();
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                HashSet<SnapshotId> snapshotIds = new HashSet<SnapshotId>();
                SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
                for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.forRepo(repositoryName)) {
                    SnapshotId snapshotId2 = entry2.snapshot().getSnapshotId();
                    if (!Regex.simpleMatch(snapshotNames, snapshotId2.getName())) continue;
                    snapshotIds.add(snapshotId2);
                }
                Map snapshotsIdsInRepository = repositoryData.getSnapshotIds().stream().collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
                for (String snapshotOrPattern : snapshotNames) {
                    if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                        for (Map.Entry entry3 : snapshotsIdsInRepository.entrySet()) {
                            if (!Regex.simpleMatch(snapshotOrPattern, entry3.getKey())) continue;
                            snapshotIds.add((SnapshotId)entry3.getValue());
                        }
                        continue;
                    }
                    SnapshotId foundId = (SnapshotId)snapshotsIdsInRepository.get(snapshotOrPattern);
                    if (foundId == null) {
                        if (!snapshotIds.stream().noneMatch(snapshotId -> snapshotId.getName().equals(snapshotOrPattern))) continue;
                        SnapshotMissingException snapshotMissingException = new SnapshotMissingException(repositoryName, snapshotOrPattern);
                        logger.debug(snapshotMissingException.getMessage());
                        throw snapshotMissingException;
                    }
                    snapshotIds.add(foundId);
                }
                if (snapshotIds.isEmpty()) {
                    return currentState;
                }
                Set set = snapshotsInProgress.asStream().filter(SnapshotsInProgress.Entry::isClone).map(SnapshotsInProgress.Entry::source).collect(Collectors.toSet());
                for (SnapshotId snapshotId3 : snapshotIds) {
                    if (!set.contains(snapshotId3)) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repositoryName, snapshotId3), "cannot delete snapshot while it is being cloned");
                }
                SnapshotsService.ensureNoCleanupInProgress(currentState, repositoryName, ((SnapshotId)snapshotIds.stream().findFirst().get()).getName(), "delete snapshot");
                SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
                RestoreInProgress restoreInProgress = RestoreInProgress.get(currentState);
                for (RestoreInProgress.Entry entry4 : restoreInProgress) {
                    if (!repositoryName.equals(entry4.snapshot().getRepository()) || !snapshotIds.contains(entry4.snapshot().getSnapshotId())) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repositoryName, (SnapshotId)snapshotIds.stream().findFirst().get()), "cannot delete snapshot during a restore in progress in [" + String.valueOf(restoreInProgress) + "]");
                }
                HashSet<SnapshotId> snapshotIdsRequiringCleanup = new HashSet<SnapshotId>(snapshotIds);
                SnapshotsInProgress updatedSnapshots = snapshotsInProgress.withUpdatedEntriesForRepo(repositoryName, snapshotsInProgress.forRepo(repositoryName).stream().map(existing -> {
                    if (existing.state() == SnapshotsInProgress.State.STARTED && snapshotIdsRequiringCleanup.contains(existing.snapshot().getSnapshotId())) {
                        SnapshotsInProgress.Entry abortedEntry = existing.abort();
                        if (abortedEntry == null) {
                            Snapshot existingNotYetStartedSnapshot = existing.snapshot();
                            if (SnapshotsService.this.endingSnapshots.add(existingNotYetStartedSnapshot)) {
                                this.completedNoCleanup.add(existingNotYetStartedSnapshot);
                            }
                            snapshotIdsRequiringCleanup.remove(existingNotYetStartedSnapshot.getSnapshotId());
                        } else if (abortedEntry.state().completed()) {
                            this.completedWithCleanup.add(abortedEntry);
                        }
                        return abortedEntry;
                    }
                    return existing;
                }).filter(Objects::nonNull).toList());
                if (snapshotIdsRequiringCleanup.isEmpty()) {
                    return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, null);
                }
                SnapshotDeletionsInProgress.Entry replacedEntry = deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repositoryName)).filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.WAITING).findFirst().orElse(null);
                if (replacedEntry == null) {
                    Optional<SnapshotDeletionsInProgress.Entry> foundDuplicate = deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repositoryName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED && entry.snapshots().containsAll(snapshotIds)).findFirst();
                    if (foundDuplicate.isPresent()) {
                        this.newDelete = foundDuplicate.get();
                        this.reusedExistingDelete = true;
                        return currentState;
                    }
                    this.newDelete = new SnapshotDeletionsInProgress.Entry(repositoryName, List.copyOf(snapshotIdsRequiringCleanup), SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), updatedSnapshots.forRepo(repositoryName).stream().noneMatch(SnapshotsService::isWritingToRepository) && !deletionsInProgress.hasExecutingDeletion(repositoryName) ? SnapshotDeletionsInProgress.State.STARTED : SnapshotDeletionsInProgress.State.WAITING);
                } else {
                    this.newDelete = replacedEntry.withAddedSnapshots(snapshotIdsRequiringCleanup);
                }
                return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, (replacedEntry == null ? deletionsInProgress : deletionsInProgress.withRemovedEntry(replacedEntry.uuid())).withAddedEntry(this.newDelete));
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.endingSnapshots.removeAll(this.completedNoCleanup);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                logger.info(() -> Strings.format((String)"deleting snapshots [%s] from repository [%s]", (Object[])new Object[]{org.elasticsearch.common.Strings.arrayToCommaDelimitedString(snapshotNames), repositoryName}));
                if (!this.completedNoCleanup.isEmpty()) {
                    logger.info("snapshots {} aborted", this.completedNoCleanup);
                }
                for (Snapshot snapshot : this.completedNoCleanup) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Snapshot was aborted by deletion"), Runnable::run);
                }
                if (this.newDelete == null || !request.waitForCompletion()) {
                    listener.onResponse(null);
                } else {
                    SnapshotsService.this.addDeleteListener(this.newDelete.uuid(), listener);
                }
                if (this.newDelete != null) {
                    if (this.reusedExistingDelete) {
                        return;
                    }
                    if (this.newDelete.state() == SnapshotDeletionsInProgress.State.STARTED) {
                        if (SnapshotsService.this.tryEnterRepoLoop(repositoryName)) {
                            SnapshotsService.this.deleteSnapshotsFromRepository(this.newDelete, repositoryData, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                        } else {
                            logger.trace("Delete [{}] could not execute directly and was queued", (Object)this.newDelete);
                        }
                    } else {
                        for (SnapshotsInProgress.Entry completedSnapshot : this.completedWithCleanup) {
                            SnapshotsService.this.endSnapshot(completedSnapshot, newState.metadata(), repositoryData);
                        }
                    }
                }
            }

            public String toString() {
                return org.elasticsearch.common.Strings.format("delete snapshot task [%s]%s", repository, Arrays.toString(snapshotNames));
            }
        };
    }

    private static final class OngoingRepositoryOperations {
        private final Map<String, Deque<Snapshot>> snapshotsToFinalize = new HashMap<String, Deque<Snapshot>>();
        private final Set<String> runningDeletions = Collections.synchronizedSet(new HashSet());
        @Nullable
        private Metadata latestKnownMetaData;

        private OngoingRepositoryOperations() {
        }

        @Nullable
        synchronized Tuple<Snapshot, Metadata> pollFinalization(String repository) {
            this.assertConsistent();
            Deque<Snapshot> queued = this.snapshotsToFinalize.get(repository);
            if (queued == null) {
                return null;
            }
            Snapshot nextEntry = queued.pollFirst();
            assert (nextEntry != null);
            Tuple res = Tuple.tuple((Object)nextEntry, (Object)this.latestKnownMetaData);
            if (queued.isEmpty()) {
                this.snapshotsToFinalize.remove(repository);
            }
            if (this.snapshotsToFinalize.isEmpty()) {
                this.latestKnownMetaData = null;
            }
            assert (this.assertConsistent());
            return res;
        }

        boolean startDeletion(String deleteUUID) {
            return this.runningDeletions.add(deleteUUID);
        }

        void finishDeletion(String deleteUUID) {
            this.runningDeletions.remove(deleteUUID);
        }

        synchronized void addFinalization(Snapshot snapshot, Metadata metadata) {
            this.snapshotsToFinalize.computeIfAbsent(snapshot.getRepository(), k -> new LinkedList()).add(snapshot);
            this.latestKnownMetaData = metadata;
            this.assertConsistent();
        }

        synchronized void clear() {
            this.snapshotsToFinalize.clear();
            this.runningDeletions.clear();
            this.latestKnownMetaData = null;
        }

        synchronized boolean isEmpty() {
            return this.snapshotsToFinalize.isEmpty();
        }

        synchronized boolean assertNotQueued(Snapshot snapshot) {
            if (((Deque)this.snapshotsToFinalize.getOrDefault(snapshot.getRepository(), new LinkedList())).stream().anyMatch(entry -> entry.equals(snapshot))) {
                AssertionError assertionError = new AssertionError((Object)("[" + String.valueOf(snapshot) + "] should not be in " + String.valueOf(this.snapshotsToFinalize)));
                logger.error("assertNotQueued failure", (Throwable)((Object)assertionError));
                throw assertionError;
            }
            return true;
        }

        synchronized boolean assertConsistent() {
            assert (this.latestKnownMetaData == null && this.snapshotsToFinalize.isEmpty() || this.latestKnownMetaData != null && !this.snapshotsToFinalize.isEmpty()) : "Should not hold on to metadata if there are no more queued snapshots";
            assert (this.snapshotsToFinalize.values().stream().noneMatch(Collection::isEmpty)) : "Found empty queue in " + String.valueOf(this.snapshotsToFinalize);
            return true;
        }
    }

    private class UpdateSnapshotStatusAction
    extends TransportMasterNodeAction<UpdateIndexShardSnapshotStatusRequest, ActionResponse.Empty> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(SnapshotsService.UPDATE_SNAPSHOT_STATUS_ACTION_NAME, false, transportService, clusterService, threadPool, actionFilters, UpdateIndexShardSnapshotStatusRequest::new, in -> ActionResponse.Empty.INSTANCE, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        }

        @Override
        protected void masterOperation(Task task, UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<ActionResponse.Empty> listener) {
            SnapshotsService.this.innerUpdateSnapshotState(request.snapshot(), request.shardId(), null, request.status(), listener.map(v -> ActionResponse.Empty.INSTANCE));
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    private class SnapshotTaskExecutor
    implements ClusterStateTaskExecutor<SnapshotTask> {
        private SnapshotTaskExecutor() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<SnapshotTask> batchExecutionContext) throws Exception {
            ClusterState state = batchExecutionContext.initialState();
            SnapshotShardsUpdateContext shardsUpdateContext = new SnapshotShardsUpdateContext(batchExecutionContext, SnapshotsService.this.shardSnapshotUpdateCompletionHandler);
            SnapshotsInProgress initialSnapshots = SnapshotsInProgress.get(state);
            SnapshotsInProgress snapshotsInProgress = shardsUpdateContext.computeUpdatedState();
            RegisteredPolicySnapshots.Builder registeredPolicySnapshots = state.metadata().custom("registered_snapshots", RegisteredPolicySnapshots.EMPTY).builder();
            for (ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext : batchExecutionContext.taskContexts()) {
                SnapshotTask snapshotTask = taskContext.getTask();
                if (!(snapshotTask instanceof CreateSnapshotTask)) continue;
                CreateSnapshotTask task = (CreateSnapshotTask)snapshotTask;
                try {
                    registeredPolicySnapshots.maybeAdd(task.createSnapshotRequest.userMetadata(), task.snapshot.getSnapshotId());
                    RepositoryMetadata repoMeta = RepositoriesMetadata.get(state).repository(task.snapshot.getRepository());
                    if (Objects.equals(task.initialRepositoryMetadata, repoMeta)) {
                        snapshotsInProgress = this.createSnapshot(task, taskContext, state, snapshotsInProgress);
                        continue;
                    }
                    taskContext.success(() -> SnapshotsService.this.submitCreateSnapshotRequest(task.createSnapshotRequest, task.listener, task.repository, task.snapshot, repoMeta));
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            shardsUpdateContext.completeWithUpdatedState(snapshotsInProgress);
            if (snapshotsInProgress == initialSnapshots) {
                return state;
            }
            return ClusterState.builder(state).putCustom("snapshots", snapshotsInProgress).metadata(Metadata.builder(state.metadata()).putCustom("registered_snapshots", registeredPolicySnapshots.build())).build();
        }

        private SnapshotsInProgress createSnapshot(CreateSnapshotTask createSnapshotTask, ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext, ClusterState currentState, SnapshotsInProgress snapshotsInProgress) {
            Set<Object> featureStatesSet;
            RepositoryData repositoryData = createSnapshotTask.repositoryData;
            Snapshot snapshot = createSnapshotTask.snapshot;
            String repositoryName = snapshot.getRepository();
            String snapshotName = snapshot.getSnapshotId().getName();
            SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
            Repository repository = createSnapshotTask.repository;
            SnapshotsService.ensureSnapshotNameAvailableInRepo(repositoryData, snapshotName, repository);
            SnapshotsService.ensureSnapshotNameNotRunning(snapshotsInProgress, repositoryName, snapshotName);
            SnapshotsService.validate(repositoryName, snapshotName, currentState);
            SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
            SnapshotsService.ensureNoCleanupInProgress(currentState, repositoryName, snapshotName, "create snapshot");
            SnapshotsService.this.ensureBelowConcurrencyLimit(repositoryName, snapshotName, snapshotsInProgress, deletionsInProgress);
            CreateSnapshotRequest request = createSnapshotTask.createSnapshotRequest;
            Map<Boolean, List<String>> requestedIndices = Arrays.stream(SnapshotsService.this.indexNameExpressionResolver.concreteIndexNames(currentState, request)).collect(Collectors.partitioningBy(SnapshotsService.this.systemIndices::isSystemIndex));
            List<String> requestedSystemIndices = requestedIndices.get(true);
            if (!requestedSystemIndices.isEmpty()) {
                HashSet<String> explicitlyRequestedSystemIndices = new HashSet<String>(requestedSystemIndices);
                explicitlyRequestedSystemIndices.retainAll(Arrays.asList(request.indices()));
                if (!explicitlyRequestedSystemIndices.isEmpty()) {
                    throw new IllegalArgumentException(Strings.format((String)"the [indices] parameter includes system indices %s; to include or exclude system indices from a snapshot, use the [include_global_state] or [feature_states] parameters", (Object[])new Object[]{explicitlyRequestedSystemIndices}));
                }
            }
            List<String> indices = requestedIndices.get(false);
            List<String> requestedStates = Arrays.asList(request.featureStates());
            if (request.includeGlobalState() || !requestedStates.isEmpty()) {
                if (request.includeGlobalState() && requestedStates.isEmpty()) {
                    featureStatesSet = SnapshotsService.this.systemIndices.getFeatureNames();
                } else if (requestedStates.size() == 1 && SnapshotsService.NO_FEATURE_STATES_VALUE.equalsIgnoreCase(requestedStates.get(0))) {
                    featureStatesSet = Collections.emptySet();
                } else {
                    if (requestedStates.contains(SnapshotsService.NO_FEATURE_STATES_VALUE)) {
                        throw new IllegalArgumentException("the feature_states value [none] indicates that no feature states should be snapshotted, but other feature states were requested: " + String.valueOf(requestedStates));
                    }
                    featureStatesSet = new HashSet<String>(requestedStates);
                    featureStatesSet.retainAll(SnapshotsService.this.systemIndices.getFeatureNames());
                }
            } else {
                featureStatesSet = Collections.emptySet();
            }
            HashSet<SnapshotFeatureInfo> featureStates = new HashSet<SnapshotFeatureInfo>();
            HashSet systemDataStreamNames = new HashSet();
            HashSet<String> indexNames = new HashSet<String>(indices);
            for (Object featureName : featureStatesSet) {
                SystemIndices.Feature feature = SnapshotsService.this.systemIndices.getFeature((String)featureName);
                Set featureSystemIndices = feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(currentState.metadata()).stream()).collect(Collectors.toSet());
                Set featureAssociatedIndices = feature.getAssociatedIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(currentState.metadata()).stream()).collect(Collectors.toSet());
                HashSet featureSystemDataStreams = new HashSet();
                HashSet<String> hashSet = new HashSet<String>();
                for (SystemDataStreamDescriptor sdd : feature.getDataStreamDescriptors()) {
                    List<String> backingIndexNames = sdd.getBackingIndexNames(currentState.metadata());
                    if (backingIndexNames.size() <= 0) continue;
                    hashSet.addAll(backingIndexNames);
                    featureSystemDataStreams.add(sdd.getDataStreamName());
                }
                if (featureSystemIndices.size() > 0 || featureAssociatedIndices.size() > 0 || hashSet.size() > 0) {
                    featureStates.add(new SnapshotFeatureInfo((String)featureName, List.copyOf(Stream.concat(featureSystemIndices.stream(), hashSet.stream()).collect(Collectors.toSet()))));
                    indexNames.addAll(featureSystemIndices);
                    indexNames.addAll(featureAssociatedIndices);
                    indexNames.addAll(hashSet);
                    systemDataStreamNames.addAll(featureSystemDataStreams);
                }
                indices = List.copyOf(indexNames);
            }
            logger.trace("[{}][{}] creating snapshot for indices [{}]", (Object)repositoryName, (Object)snapshotName, indices);
            HashMap<String, IndexId> allIndices = new HashMap<String, IndexId>();
            for (SnapshotsInProgress.Entry runningSnapshot : snapshotsInProgress.forRepo(repositoryName)) {
                allIndices.putAll(runningSnapshot.indices());
            }
            Map<String, IndexId> indexIds = repositoryData.resolveNewIndices(indices, allIndices);
            IndexVersion version = SnapshotsService.minCompatibleVersion(currentState.nodes().getMaxDataNodeCompatibleIndexVersion(), repositoryData, null);
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsService.shards(snapshotsInProgress, deletionsInProgress, currentState, indexIds.values(), SnapshotsService.useShardGenerations(version), repositoryData, repositoryName);
            if (!request.partial()) {
                TreeSet<String> missing = new TreeSet<String>();
                for (Map.Entry entry : shards.entrySet()) {
                    if (((SnapshotsInProgress.ShardSnapshotStatus)entry.getValue()).state() != SnapshotsInProgress.ShardState.MISSING) continue;
                    missing.add(((ShardId)entry.getKey()).getIndex().getName());
                }
                if (!missing.isEmpty()) {
                    throw new SnapshotException(snapshot, org.elasticsearch.common.Strings.format("the following indices have unassigned primary shards and cannot be included in a snapshot unless [partial] is set to [true]: %s; for help with troubleshooting unassigned shards see %s\n", new Object[]{missing, ReferenceDocs.UNASSIGNED_SHARDS}));
                }
            }
            SnapshotsInProgress.Entry newEntry = SnapshotsInProgress.startedEntry(snapshot, request.includeGlobalState(), request.partial(), indexIds, CollectionUtils.concatLists(SnapshotsService.this.indexNameExpressionResolver.dataStreamNames(currentState, request.indicesOptions(), request.indices()), systemDataStreamNames), SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), shards, request.userMetadata(), version, List.copyOf(featureStates));
            SnapshotsInProgress res = snapshotsInProgress.withAddedEntry(newEntry);
            taskContext.success(() -> {
                logger.info("snapshot [{}] started", (Object)snapshot);
                createSnapshotTask.listener.onResponse(snapshot);
                if (newEntry.state().completed()) {
                    SnapshotsService.this.endSnapshot(newEntry, currentState.metadata(), createSnapshotTask.repositoryData);
                }
            });
            return res;
        }
    }

    static interface ShardSnapshotUpdateCompletionHandler {
        public void handleCompletion(ShardSnapshotUpdateResult var1, List<SnapshotsInProgress.Entry> var2, Set<String> var3);
    }

    private record UpdateNodeIdsForRemovalTask() implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            assert (MasterService.isPublishFailureException(e)) : e;
        }

        static ClusterState executeBatch(ClusterStateTaskExecutor.BatchExecutionContext<UpdateNodeIdsForRemovalTask> batchExecutionContext) {
            SnapshotsInProgress snapshotsInProgress;
            SnapshotsInProgress newSnapshotsInProgress;
            for (ClusterStateTaskExecutor.TaskContext<UpdateNodeIdsForRemovalTask> taskContext : batchExecutionContext.taskContexts()) {
                taskContext.success(() -> {});
            }
            ClusterState clusterState = batchExecutionContext.initialState();
            if (SnapshotsService.supportsNodeRemovalTracking(clusterState) && (newSnapshotsInProgress = (snapshotsInProgress = SnapshotsInProgress.get(clusterState)).withUpdatedNodeIdsForRemoval(clusterState)) != snapshotsInProgress) {
                return ClusterState.builder(clusterState).putCustom("snapshots", newSnapshotsInProgress).build();
            }
            return clusterState;
        }
    }

    record ShardSnapshotUpdateResult(Metadata metadata, SnapshotsInProgress snapshotsInProgress) {
    }

    static final class ShardSnapshotUpdate
    implements SnapshotTask {
        private final Snapshot snapshot;
        private final ShardId shardId;
        private final RepositoryShardId repoShardId;
        private final SnapshotsInProgress.ShardSnapshotStatus updatedState;
        private final ActionListener<ShardSnapshotUpdateResult> listener;

        ShardSnapshotUpdate(Snapshot snapshot, ShardId shardId, RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState, ActionListener<ShardSnapshotUpdateResult> listener) {
            assert (shardId != null ^ repoShardId != null);
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.repoShardId = repoShardId;
            this.updatedState = updatedState;
            this.listener = listener;
        }

        public boolean isClone() {
            return this.repoShardId != null;
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardSnapshotUpdate)) {
                return false;
            }
            ShardSnapshotUpdate that = (ShardSnapshotUpdate)other;
            return this.snapshot.equals(that.snapshot) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.repoShardId, that.repoShardId) && this.updatedState == that.updatedState;
        }

        public int hashCode() {
            return Objects.hash(this.snapshot, this.shardId, this.updatedState, this.repoShardId);
        }

        public String toString() {
            return "ShardSnapshotUpdate{snapshot=" + String.valueOf(this.snapshot) + ", shardId=" + String.valueOf(this.shardId) + ", repoShardId=" + String.valueOf(this.repoShardId) + ", updatedState=" + String.valueOf(this.updatedState) + "}";
        }
    }

    private record CreateSnapshotTask(Repository repository, RepositoryData repositoryData, ActionListener<Snapshot> listener, Snapshot snapshot, CreateSnapshotRequest createSnapshotRequest, RepositoryMetadata initialRepositoryMetadata) implements SnapshotTask
    {
        @Override
        public void onFailure(Exception e) {
            SnapshotsService.logSnapshotFailure("create", this.snapshot, e);
            this.listener.onFailure(e);
        }

        @Override
        public String toString() {
            return "CreateSnapshotTask{repository=" + this.repository.getMetadata().name() + ", snapshot=" + String.valueOf(this.snapshot) + "}";
        }
    }

    static interface SnapshotTask
    extends ClusterStateTaskListener {
    }

    private final class FailPendingRepoTasksTask
    extends ClusterStateUpdateTask {
        private final List<Snapshot> snapshotsToFail = new ArrayList<Snapshot>();
        private final List<String> deletionsToFail = new ArrayList<String>();
        private final Exception failure;
        private final String repository;

        FailPendingRepoTasksTask(String repository, Exception failure) {
            this.repository = repository;
            this.failure = failure;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
            boolean changed = false;
            List<SnapshotDeletionsInProgress.Entry> remainingEntries = deletionsInProgress.getEntries();
            ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(remainingEntries.size());
            for (SnapshotDeletionsInProgress.Entry entry : remainingEntries) {
                if (entry.repository().equals(this.repository)) {
                    changed = true;
                    this.deletionsToFail.add(entry.uuid());
                    continue;
                }
                updatedEntries.add(entry);
            }
            SnapshotDeletionsInProgress updatedDeletions = changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
            SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
            boolean changedSnapshots = false;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(this.repository)) {
                this.snapshotsToFail.add(entry.snapshot());
                changedSnapshots = true;
            }
            SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? snapshotsInProgress.withUpdatedEntriesForRepo(this.repository, List.of()) : null;
            return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshotsInProgress, updatedDeletions);
        }

        @Override
        public void onFailure(Exception e) {
            logger.info(() -> "Failed to remove all snapshot tasks for repo [" + this.repository + "] from cluster state", (Throwable)e);
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            logger.warn(() -> Strings.format((String)"Removed all snapshot tasks for repository [%s] from cluster state, now failing listeners", (Object[])new Object[]{this.repository}), (Throwable)this.failure);
            ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
            Set<String> set = SnapshotsService.this.currentlyFinalizing;
            synchronized (set) {
                Tuple<Snapshot, Metadata> finalization;
                while ((finalization = SnapshotsService.this.repositoryOperations.pollFinalization(this.repository)) != null) {
                    assert (this.snapshotsToFail.contains(finalization.v1())) : "[" + String.valueOf(finalization.v1()) + "] not found in snapshots to fail " + String.valueOf(this.snapshotsToFail);
                }
                SnapshotsService.this.leaveRepoLoop(this.repository);
                for (Snapshot snapshot : this.snapshotsToFail) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, this.failure, readyToResolveListeners::add);
                }
                for (String delete : this.deletionsToFail) {
                    List<ActionListener<Void>> listeners = SnapshotsService.this.snapshotDeletionListeners.remove(delete);
                    readyToResolveListeners.add(() -> SnapshotsService.failListenersIgnoringException(listeners, this.failure));
                    SnapshotsService.this.repositoryOperations.finishDeletion(delete);
                }
            }
            readyToResolveListeners.forEach(Runnable::run);
        }
    }

    static final class SnapshotShardsUpdateContext {
        private int changedCount = 0;
        private int startedCount = 0;
        private final ClusterStateTaskExecutor.BatchExecutionContext<SnapshotTask> batchExecutionContext;
        private final ClusterState initialState;
        private final Predicate<String> nodeIdRemovalPredicate;
        private final Map<String, List<ShardSnapshotUpdate>> updatesByRepo;
        private final Set<ShardSnapshotUpdate> executedUpdates = new HashSet<ShardSnapshotUpdate>();
        private final ShardSnapshotUpdateCompletionHandler completionHandler;
        private final List<SnapshotsInProgress.Entry> newlyCompletedEntries = new ArrayList<SnapshotsInProgress.Entry>();

        SnapshotShardsUpdateContext(ClusterStateTaskExecutor.BatchExecutionContext<SnapshotTask> batchExecutionContext, ShardSnapshotUpdateCompletionHandler completionHandler) {
            this.batchExecutionContext = batchExecutionContext;
            this.initialState = batchExecutionContext.initialState();
            this.nodeIdRemovalPredicate = SnapshotsInProgress.get(this.initialState)::isNodeIdForRemoval;
            this.completionHandler = completionHandler;
            this.updatesByRepo = new HashMap<String, List<ShardSnapshotUpdate>>();
            for (ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext : batchExecutionContext.taskContexts()) {
                SnapshotTask snapshotTask = taskContext.getTask();
                if (!(snapshotTask instanceof ShardSnapshotUpdate)) continue;
                ShardSnapshotUpdate task = (ShardSnapshotUpdate)snapshotTask;
                this.updatesByRepo.computeIfAbsent(task.snapshot.getRepository(), r -> new ArrayList()).add(task);
            }
        }

        SnapshotsInProgress computeUpdatedState() {
            SnapshotsInProgress existing;
            SnapshotsInProgress updated = existing = SnapshotsInProgress.get(this.initialState);
            for (Map.Entry<String, List<ShardSnapshotUpdate>> updates : this.updatesByRepo.entrySet()) {
                String repoName = updates.getKey();
                List<SnapshotsInProgress.Entry> oldEntries = existing.forRepo(repoName);
                if (oldEntries.isEmpty()) continue;
                ArrayList<SnapshotsInProgress.Entry> newEntries = new ArrayList<SnapshotsInProgress.Entry>(oldEntries.size());
                for (SnapshotsInProgress.Entry entry : oldEntries) {
                    SnapshotsInProgress.Entry newEntry = this.applyToEntry(entry, updates.getValue());
                    newEntries.add(newEntry);
                    if (newEntry == entry || !newEntry.state().completed()) continue;
                    this.newlyCompletedEntries.add(newEntry);
                }
                updated = updated.withUpdatedEntriesForRepo(repoName, newEntries);
            }
            if (this.changedCount > 0) {
                logger.trace("changed cluster state triggered by [{}] snapshot state updates and resulted in starting [{}] shard snapshots", (Object)this.changedCount, (Object)this.startedCount);
                return SnapshotsService.supportsNodeRemovalTracking(this.initialState) ? updated.withUpdatedNodeIdsForRemoval(this.initialState) : updated;
            }
            return existing;
        }

        void completeWithUpdatedState(SnapshotsInProgress snapshotsInProgress) {
            if (!this.updatesByRepo.isEmpty()) {
                ShardSnapshotUpdateResult result = new ShardSnapshotUpdateResult(this.initialState.metadata(), snapshotsInProgress);
                try (RefCountingRunnable onCompletionRefs = new RefCountingRunnable(() -> this.completionHandler.handleCompletion(result, this.newlyCompletedEntries, this.updatesByRepo.keySet()));){
                    for (ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext : this.batchExecutionContext.taskContexts()) {
                        SnapshotTask snapshotTask = taskContext.getTask();
                        if (!(snapshotTask instanceof ShardSnapshotUpdate)) continue;
                        ShardSnapshotUpdate task = (ShardSnapshotUpdate)snapshotTask;
                        Releasable ref = onCompletionRefs.acquire();
                        taskContext.success(() -> {
                            try (Releasable releasable = ref;){
                                task.listener.onResponse(result);
                            }
                        });
                    }
                }
            }
        }

        private SnapshotsInProgress.Entry applyToEntry(SnapshotsInProgress.Entry entry, List<ShardSnapshotUpdate> updates) {
            if (entry.state().completed() || updates.isEmpty()) {
                return entry;
            }
            return new EntryContext(entry, updates).computeUpdatedEntry();
        }

        private final class EntryContext {
            private final SnapshotsInProgress.Entry entry;
            private final Iterator<ShardSnapshotUpdate> iterator;
            private ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder = null;
            private ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = null;

            EntryContext(SnapshotsInProgress.Entry entry, List<ShardSnapshotUpdate> updates) {
                this.entry = entry;
                this.iterator = updates.iterator();
            }

            SnapshotsInProgress.Entry computeUpdatedEntry() {
                assert (this.shardsBuilder == null && this.clonesBuilder == null) : "update context was already used";
                while (this.iterator.hasNext()) {
                    ShardSnapshotUpdate update = this.iterator.next();
                    if (this.entry.snapshot().getSnapshotId().equals(update.snapshot.getSnapshotId())) {
                        if (update.isClone()) {
                            this.executeShardSnapshotUpdate(this.entry.shardSnapshotStatusByRepoShardId(), this::clonesBuilder, update, update.repoShardId);
                            continue;
                        }
                        this.executeShardSnapshotUpdate(this.entry.shards(), this::shardsBuilder, update, update.shardId);
                        continue;
                    }
                    if (!SnapshotShardsUpdateContext.this.executedUpdates.contains(update)) continue;
                    if (update.isClone()) {
                        this.tryStartNextTaskAfterCloneUpdated(update.repoShardId, update.updatedState);
                        continue;
                    }
                    this.tryStartNextTaskAfterSnapshotUpdated(update.shardId, update.updatedState);
                }
                if (this.shardsBuilder != null) {
                    assert (this.clonesBuilder == null) : "Should not have updated clones when updating shard snapshots but saw " + String.valueOf(this.clonesBuilder) + " as well as " + String.valueOf(this.shardsBuilder);
                    return this.entry.withShardStates(this.shardsBuilder.build());
                }
                if (this.clonesBuilder != null) {
                    return this.entry.withClones(this.clonesBuilder.build());
                }
                return this.entry;
            }

            private <T> void startShardOperation(ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newStates, String nodeId, ShardGeneration generation, T shardId) {
                this.startShardOperation(newStates, shardId, new SnapshotsInProgress.ShardSnapshotStatus(nodeId, generation));
            }

            private <T> void startShardOperation(ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newStates, T shardId, SnapshotsInProgress.ShardSnapshotStatus newState) {
                logger.trace("[{}] Starting [{}] on [{}] with generation [{}]", (Object)this.entry.snapshot(), shardId, (Object)newState.nodeId(), (Object)newState.generation());
                newStates.put(shardId, newState);
                this.iterator.remove();
                ++SnapshotShardsUpdateContext.this.startedCount;
            }

            private <T> void executeShardSnapshotUpdate(Map<T, SnapshotsInProgress.ShardSnapshotStatus> existingStates, Supplier<ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus>> newStates, ShardSnapshotUpdate updateSnapshotState, T updatedShard) {
                assert (updateSnapshotState.snapshot.equals(this.entry.snapshot()));
                SnapshotsInProgress.ShardSnapshotStatus existing = existingStates.get(updatedShard);
                if (existing == null) {
                    logger.warn("Received shard snapshot status update [{}] but this shard is not tracked in [{}]", updatedShard, (Object)this.entry);
                    assert (false) : "This should never happen, should only receive updates for expected shards";
                    return;
                }
                if (existing.state().completed()) {
                    this.iterator.remove();
                    return;
                }
                SnapshotsInProgress.ShardSnapshotStatus updatedState = existing.state() == SnapshotsInProgress.ShardState.ABORTED && updateSnapshotState.updatedState.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL ? new SnapshotsInProgress.ShardSnapshotStatus(updateSnapshotState.updatedState.nodeId(), SnapshotsInProgress.ShardState.FAILED, updateSnapshotState.updatedState.generation(), "snapshot aborted") : updateSnapshotState.updatedState;
                if (updatedState.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
                    this.iterator.remove();
                } else assert (!updatedState.isActive()) : updatedState;
                logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updateSnapshotState.snapshot, updatedShard, (Object)updatedState.state());
                ++SnapshotShardsUpdateContext.this.changedCount;
                newStates.get().put(updatedShard, updatedState);
                SnapshotShardsUpdateContext.this.executedUpdates.add(updateSnapshotState);
            }

            private void tryStartNextTaskAfterCloneUpdated(RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
                if (!this.entry.isClone()) {
                    this.tryStartSnapshotAfterCloneFinish(repoShardId, updatedState.generation());
                } else if (SnapshotsService.isQueued(this.entry.shardSnapshotStatusByRepoShardId().get(repoShardId))) {
                    String localNodeId = SnapshotShardsUpdateContext.this.initialState.nodes().getLocalNodeId();
                    assert (updatedState.nodeId().equals(localNodeId)) : "Clone updated with node id [" + updatedState.nodeId() + "] but local node id is [" + localNodeId + "]";
                    this.startShardOperation(this.clonesBuilder(), localNodeId, updatedState.generation(), repoShardId);
                }
            }

            private void tryStartNextTaskAfterSnapshotUpdated(ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
                IndexId indexId = this.entry.indices().get(shardId.getIndexName());
                if (indexId != null) {
                    RepositoryShardId repoShardId = new RepositoryShardId(indexId, shardId.id());
                    if (SnapshotsService.isQueued(this.entry.shardSnapshotStatusByRepoShardId().get(repoShardId))) {
                        if (this.entry.isClone()) {
                            this.startShardOperation(this.clonesBuilder(), SnapshotShardsUpdateContext.this.initialState.nodes().getLocalNodeId(), updatedState.generation(), repoShardId);
                        } else {
                            this.startShardSnapshot(repoShardId, updatedState.generation());
                        }
                    }
                }
            }

            private void tryStartSnapshotAfterCloneFinish(RepositoryShardId repoShardId, ShardGeneration generation) {
                assert (this.entry.source() == null);
                if (SnapshotsService.isQueued(this.entry.shardSnapshotStatusByRepoShardId().get(repoShardId))) {
                    this.startShardSnapshot(repoShardId, generation);
                }
            }

            private void startShardSnapshot(RepositoryShardId repoShardId, ShardGeneration generation) {
                ShardId routingShardId;
                Index index = this.entry.indexByName(repoShardId.indexName());
                assert (index != null) : "index [" + String.valueOf(repoShardId.index()) + "] must exist in snapshot entry [" + String.valueOf(this.entry) + "] because it's a normal snapshot but did not";
                IndexRoutingTable indexRouting = SnapshotShardsUpdateContext.this.initialState.routingTable().index(index);
                ShardRouting shardRouting = indexRouting == null ? null : indexRouting.shard(repoShardId.shardId()).primaryShard();
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = SnapshotsService.initShardSnapshotStatus(generation, shardRouting, SnapshotShardsUpdateContext.this.nodeIdRemovalPredicate);
                ShardId shardId = routingShardId = shardRouting != null ? shardRouting.shardId() : new ShardId(index, repoShardId.shardId());
                if (shardSnapshotStatus.isActive()) {
                    this.startShardOperation(this.shardsBuilder(), routingShardId, shardSnapshotStatus);
                } else {
                    this.shardsBuilder().put(routingShardId, shardSnapshotStatus);
                }
            }

            private ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder() {
                assert (this.shardsBuilder == null);
                if (this.clonesBuilder == null) {
                    this.clonesBuilder = ImmutableOpenMap.builder(this.entry.shardSnapshotStatusByRepoShardId());
                }
                return this.clonesBuilder;
            }

            private ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder() {
                assert (this.clonesBuilder == null);
                if (this.shardsBuilder == null) {
                    this.shardsBuilder = ImmutableOpenMap.builder(this.entry.shards());
                }
                return this.shardsBuilder;
            }
        }
    }

    private abstract class RemoveSnapshotDeletionAndContinueTask
    extends ClusterStateUpdateTask {
        protected final List<SnapshotsInProgress.Entry> newFinalizations = new ArrayList<SnapshotsInProgress.Entry>();
        private List<SnapshotDeletionsInProgress.Entry> readyDeletions = Collections.emptyList();
        protected final SnapshotDeletionsInProgress.Entry deleteEntry;
        private final RepositoryData repositoryData;

        RemoveSnapshotDeletionAndContinueTask(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData) {
            this.deleteEntry = deleteEntry;
            this.repositoryData = repositoryData;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletions = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
            assert (deletions != null) : "We only run this if there were deletions in the cluster state before";
            SnapshotDeletionsInProgress updatedDeletions = deletions.withRemovedEntry(this.deleteEntry.uuid());
            if (updatedDeletions == deletions) {
                return currentState;
            }
            SnapshotDeletionsInProgress newDeletions = this.filterDeletions(updatedDeletions);
            Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> res = SnapshotsService.readyDeletions(SnapshotsService.updateWithSnapshots(currentState, this.updatedSnapshotsInProgress(currentState, newDeletions), newDeletions));
            this.readyDeletions = (List)res.v2();
            return (ClusterState)res.v1();
        }

        @Override
        public void onFailure(Exception e) {
            logger.warn(() -> Strings.format((String)"%s failed to remove snapshot deletion metadata", (Object[])new Object[]{this.deleteEntry}), (Throwable)e);
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
            return deletions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
            Iterator<SnapshotsInProgress.Entry> iterator = SnapshotsService.this.currentlyFinalizing;
            synchronized (iterator) {
                List<ActionListener<Void>> deleteListeners = SnapshotsService.this.snapshotDeletionListeners.remove(this.deleteEntry.uuid());
                readyToResolveListeners.add(() -> this.handleListeners(deleteListeners));
            }
            readyToResolveListeners.forEach(Runnable::run);
            if (this.newFinalizations.isEmpty()) {
                if (this.readyDeletions.isEmpty()) {
                    SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                } else {
                    for (SnapshotDeletionsInProgress.Entry readyDeletion : this.readyDeletions) {
                        SnapshotsService.this.deleteSnapshotsFromRepository(readyDeletion, this.repositoryData, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                    }
                }
            } else {
                SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                assert (this.readyDeletions.stream().noneMatch(entry -> entry.repository().equals(this.deleteEntry.repository()))) : "New finalizations " + String.valueOf(this.newFinalizations) + " added even though deletes " + String.valueOf(this.readyDeletions) + " are ready";
                for (SnapshotsInProgress.Entry entry2 : this.newFinalizations) {
                    SnapshotsService.this.endSnapshot(entry2, newState.metadata(), this.repositoryData);
                }
            }
            SnapshotsService.this.startExecutableClones(SnapshotsInProgress.get(newState), null);
        }

        protected abstract void handleListeners(@Nullable List<ActionListener<Void>> var1);

        @Nullable
        private SnapshotsInProgress updatedSnapshotsInProgress(ClusterState currentState, SnapshotDeletionsInProgress updatedDeletions) {
            SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            HashSet<RepositoryShardId> reassignedShardIds = new HashSet<RepositoryShardId>();
            boolean changed = false;
            String localNodeId = currentState.nodes().getLocalNodeId();
            String repoName = this.deleteEntry.repository();
            InFlightShardSnapshotStates inFlightShardStates = null;
            HashSet<IndexId> newIndexIdsToRefresh = new HashSet<IndexId>();
            for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.forRepo(repoName)) {
                if (!entry2.state().completed()) {
                    ArrayList<RepositoryShardId> canBeUpdated;
                    if (entry2.isClone()) {
                        Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> value2;
                        canBeUpdated = new ArrayList<RepositoryShardId>();
                        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> value2 : entry2.shardSnapshotStatusByRepoShardId().entrySet()) {
                            if (!value2.getValue().equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(value2.getKey())) continue;
                            canBeUpdated.add((RepositoryShardId)value2.getKey());
                        }
                        if (canBeUpdated.isEmpty() || updatedDeletions.hasExecutingDeletion(repoName)) {
                            snapshotEntries.add(entry2);
                            continue;
                        }
                        if (inFlightShardStates == null) {
                            inFlightShardStates = InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(repoName));
                        }
                        ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = ImmutableOpenMap.builder(entry2.shardSnapshotStatusByRepoShardId());
                        value2 = canBeUpdated.iterator();
                        while (value2.hasNext()) {
                            RepositoryShardId shardId = (RepositoryShardId)value2.next();
                            if (inFlightShardStates.isActive(shardId.indexName(), shardId.shardId())) continue;
                            RemoveSnapshotDeletionAndContinueTask.markShardReassigned(shardId, reassignedShardIds);
                            updatedAssignmentsBuilder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(shardId.index(), shardId.shardId(), this.repositoryData.shardGenerations())));
                        }
                        snapshotEntries.add(entry2.withClones(updatedAssignmentsBuilder.build()));
                        changed = true;
                        continue;
                    }
                    canBeUpdated = new ArrayList();
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> value2 : entry2.shardSnapshotStatusByRepoShardId().entrySet()) {
                        RepositoryShardId repositoryShardId = value2.getKey();
                        if (!value2.getValue().equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(repositoryShardId)) continue;
                        canBeUpdated.add(repositoryShardId);
                        if (this.repositoryData.hasIndex(repositoryShardId.indexName())) continue;
                        newIndexIdsToRefresh.add(repositoryShardId.index());
                    }
                    if (canBeUpdated.isEmpty()) {
                        snapshotEntries.add(entry2);
                        continue;
                    }
                    ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardAssignments = SnapshotsService.shards(snapshotsInProgress, updatedDeletions, currentState, entry2.indices().values(), entry2.version().onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION), this.repositoryData, repoName);
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = ImmutableOpenMap.builder(entry2.shards());
                    for (RepositoryShardId shardId : canBeUpdated) {
                        ShardId sid = entry2.shardId(shardId);
                        SnapshotsInProgress.ShardSnapshotStatus updated = shardAssignments.get(sid);
                        if (updated == null) {
                            assert (!currentState.routingTable().hasIndex(sid.getIndex())) : "Missing assignment for [" + String.valueOf(sid) + "]";
                            updatedAssignmentsBuilder.put(sid, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                            continue;
                        }
                        if (updated.isActive()) {
                            RemoveSnapshotDeletionAndContinueTask.markShardReassigned(shardId, reassignedShardIds);
                        }
                        updatedAssignmentsBuilder.put(sid, updated);
                    }
                    SnapshotsInProgress.Entry updatedEntry = entry2.withShardStates(updatedAssignmentsBuilder.build());
                    snapshotEntries.add(updatedEntry);
                    changed = true;
                    if (!updatedEntry.state().completed()) continue;
                    this.newFinalizations.add(entry2);
                    continue;
                }
                this.newFinalizations.add(entry2);
                snapshotEntries.add(entry2);
            }
            if (changed && !newIndexIdsToRefresh.isEmpty()) {
                Map<IndexId, IndexId> updatedIndexIds = Maps.newMapWithExpectedSize(newIndexIdsToRefresh.size());
                for (IndexId indexIdToRefresh : newIndexIdsToRefresh) {
                    updatedIndexIds.put(indexIdToRefresh, new IndexId(indexIdToRefresh.getName(), UUIDs.randomBase64UUID()));
                }
                snapshotEntries.replaceAll(entry -> entry.withUpdatedIndexIds(updatedIndexIds));
            }
            return changed ? snapshotsInProgress.withUpdatedEntriesForRepo(repoName, snapshotEntries) : null;
        }

        private static void markShardReassigned(RepositoryShardId shardId, Set<RepositoryShardId> reassignments) {
            boolean added = reassignments.add(shardId);
            assert (added) : "should only ever reassign each shard once but assigned [" + String.valueOf(shardId) + "] multiple times";
        }

        public String toString() {
            return "RemoveSnapshotDeletionAndContinueTask[" + String.valueOf(this.deleteEntry) + "]";
        }
    }
}

