/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.parser;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.eql.parser.AbstractBuilder;
import org.elasticsearch.xpack.eql.parser.AstBuilder;
import org.elasticsearch.xpack.eql.parser.EqlBaseBaseListener;
import org.elasticsearch.xpack.eql.parser.EqlBaseLexer;
import org.elasticsearch.xpack.eql.parser.EqlBaseParser;
import org.elasticsearch.xpack.eql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.parser.ParsingException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.type.DateUtils;

public class EqlParser {
    private static final Logger log = LogManager.getLogger(EqlParser.class);
    private final boolean DEBUG = false;
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, (Exception)((Object)e), line, charPositionInLine);
        }
    };

    public LogicalPlan createStatement(String eql) {
        return this.createStatement(eql, new ParserParams(DateUtils.UTC));
    }

    public LogicalPlan createStatement(String eql, ParserParams params) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as statement: {}", (Object)eql);
        }
        return this.invokeParser(eql, params, EqlBaseParser::singleStatement, AbstractBuilder::plan);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, new ParserParams(DateUtils.UTC));
    }

    public Expression createExpression(String expression, ParserParams params) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as expression: {}", (Object)expression);
        }
        return this.invokeParser(expression, params, EqlBaseParser::singleExpression, ExpressionBuilder::expression);
    }

    private <T> T invokeParser(String eql, ParserParams params, Function<EqlBaseParser, ParserRuleContext> parseFunction, BiFunction<AstBuilder, ParserRuleContext, T> visitor) {
        try {
            EqlBaseLexer lexer = new EqlBaseLexer((CharStream)new ANTLRInputStream(eql));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            EqlBaseParser parser = new EqlBaseParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor(Arrays.asList(parser.getRuleNames())));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            ParserRuleContext tree = parseFunction.apply(parser);
            return visitor.apply(new AstBuilder(params), tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("EQL statement is too large, causing stack overflow when generating the parsing tree: [{}]", eql);
        }
    }

    private static void debug(EqlBaseParser parser) {
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        parser.addParseListener((ParseTreeListener)new Parser.TraceListener((Parser)parser));
        parser.addErrorListener((ANTLRErrorListener)new DiagnosticErrorListener(false){

            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }
        });
    }

    private class PostProcessor
    extends EqlBaseBaseListener {
        private final List<String> ruleNames;

        PostProcessor(List<String> ruleNames) {
            this.ruleNames = ruleNames;
        }

        @Override
        public void exitProcessCheck(EqlBaseParser.ProcessCheckContext context) {
            Token token = context.relationship;
            throw new ParsingException("Process relationships are not supported", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitQualifiedName(EqlBaseParser.QualifiedNameContext context) {
            if (context.INTEGER_VALUE().size() > 0) {
                Token firstIndex = context.INTEGER_VALUE(0).getSymbol();
                throw new ParsingException("Array indexes are not supported", null, firstIndex.getLine(), firstIndex.getCharPositionInLine());
            }
        }
    }
}

