/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsResultProcessor;
import org.elasticsearch.xpack.ml.dataframe.process.DataFrameRowsJoiner;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.dataframe.stats.DataCountsTracker;
import org.elasticsearch.xpack.ml.dataframe.stats.ProgressTracker;
import org.elasticsearch.xpack.ml.dataframe.stats.StatsPersister;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class AnalyticsProcessManager {
    private static final Logger LOGGER = LogManager.getLogger(AnalyticsProcessManager.class);
    private final Settings settings;
    private final Client client;
    private final ExecutorService executorServiceForJob;
    private final ExecutorService executorServiceForProcess;
    private final AnalyticsProcessFactory<AnalyticsResult> processFactory;
    private final ConcurrentMap<Long, ProcessContext> processContextByAllocation = new ConcurrentHashMap<Long, ProcessContext>();
    private final DataFrameAnalyticsAuditor auditor;
    private final TrainedModelProvider trainedModelProvider;
    private final ResultsPersisterService resultsPersisterService;
    private final int numAllocatedProcessors;

    public AnalyticsProcessManager(Settings settings, Client client, ThreadPool threadPool, AnalyticsProcessFactory<AnalyticsResult> analyticsProcessFactory, DataFrameAnalyticsAuditor auditor, TrainedModelProvider trainedModelProvider, ResultsPersisterService resultsPersisterService, int numAllocatedProcessors) {
        this(settings, client, threadPool.executor("ml_utility"), threadPool.executor("ml_job_comms"), analyticsProcessFactory, auditor, trainedModelProvider, resultsPersisterService, numAllocatedProcessors);
    }

    public AnalyticsProcessManager(Settings settings, Client client, ExecutorService executorServiceForJob, ExecutorService executorServiceForProcess, AnalyticsProcessFactory<AnalyticsResult> analyticsProcessFactory, DataFrameAnalyticsAuditor auditor, TrainedModelProvider trainedModelProvider, ResultsPersisterService resultsPersisterService, int numAllocatedProcessors) {
        this.settings = Objects.requireNonNull(settings);
        this.client = Objects.requireNonNull(client);
        this.executorServiceForJob = Objects.requireNonNull(executorServiceForJob);
        this.executorServiceForProcess = Objects.requireNonNull(executorServiceForProcess);
        this.processFactory = Objects.requireNonNull(analyticsProcessFactory);
        this.auditor = Objects.requireNonNull(auditor);
        this.trainedModelProvider = Objects.requireNonNull(trainedModelProvider);
        this.resultsPersisterService = Objects.requireNonNull(resultsPersisterService);
        this.numAllocatedProcessors = numAllocatedProcessors;
    }

    public void runJob(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, DataFrameDataExtractorFactory dataExtractorFactory, ActionListener<StepResponse> listener) {
        this.executorServiceForJob.execute(() -> {
            boolean isProcessStarted;
            ProcessContext processContext = new ProcessContext(config);
            ConcurrentMap<Long, ProcessContext> concurrentMap = this.processContextByAllocation;
            synchronized (concurrentMap) {
                if (task.isStopping()) {
                    LOGGER.debug("[{}] task is stopping. Marking as complete before creating process context.", (Object)task.getParams().getId());
                    this.auditor.info(config.getId(), "Finished analysis");
                    listener.onResponse((Object)new StepResponse(true));
                    return;
                }
                if (this.processContextByAllocation.putIfAbsent(task.getAllocationId(), processContext) != null) {
                    listener.onFailure((Exception)ExceptionsHelper.serverError((String)("[" + config.getId() + "] Could not create process as one already exists")));
                    return;
                }
            }
            boolean hasState = this.hasModelState(config);
            try {
                isProcessStarted = processContext.startProcess(dataExtractorFactory, task, hasState);
            }
            catch (Exception e) {
                processContext.stop();
                this.processContextByAllocation.remove(task.getAllocationId());
                listener.onFailure(processContext.getFailureReason() == null ? e : ExceptionsHelper.serverError((String)processContext.getFailureReason()));
                return;
            }
            if (isProcessStarted) {
                this.executorServiceForProcess.execute(() -> ((AnalyticsResultProcessor)processContext.resultProcessor.get()).process((AnalyticsProcess)processContext.process.get()));
                this.executorServiceForProcess.execute(() -> this.processData(task, processContext, hasState, listener));
            } else {
                this.processContextByAllocation.remove(task.getAllocationId());
                this.auditor.info(config.getId(), "Finished analysis");
                listener.onResponse((Object)new StepResponse(true));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasModelState(DataFrameAnalyticsConfig config) {
        if (!config.getAnalysis().persistsState()) {
            return false;
        }
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            boolean bl;
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setSize(1).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{config.getAnalysis().getStateDocIdPrefix(config.getId()) + "1"})).get();
            try {
                bl = searchResponse.getHits().getHits().length == 1;
            }
            catch (Throwable throwable) {
                searchResponse.decRef();
                throw throwable;
            }
            searchResponse.decRef();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData(DataFrameAnalyticsTask task, ProcessContext processContext, boolean hasState, ActionListener<StepResponse> listener) {
        LOGGER.info("[{}] Started loading data", (Object)processContext.config.getId());
        this.auditor.info(processContext.config.getId(), Messages.getMessage((String)"Started loading data"));
        DataFrameAnalyticsConfig config = processContext.config;
        DataFrameDataExtractor dataExtractor = (DataFrameDataExtractor)processContext.dataExtractor.get();
        AnalyticsProcess process = (AnalyticsProcess)processContext.process.get();
        AnalyticsResultProcessor resultProcessor = (AnalyticsResultProcessor)processContext.resultProcessor.get();
        try {
            AnalyticsProcessManager.writeHeaderRecord(dataExtractor, process, task);
            AnalyticsProcessManager.writeDataRows(dataExtractor, process, task);
            process.writeEndOfDataMessage();
            LOGGER.debug(() -> "[" + processContext.config.getId() + "] Flushing input stream");
            process.flushStream();
            LOGGER.debug(() -> "[" + processContext.config.getId() + "] Flushing input stream completed");
            this.restoreState(config, process, hasState);
            LOGGER.info("[{}] Started analyzing", (Object)processContext.config.getId());
            this.auditor.info(processContext.config.getId(), Messages.getMessage((String)"Started analyzing"));
            LOGGER.info("[{}] Waiting for result processor to complete", (Object)config.getId());
            resultProcessor.awaitForCompletion();
            processContext.setFailureReason(resultProcessor.getFailure());
            LOGGER.info("[{}] Result processor has completed", (Object)config.getId());
        }
        catch (Exception e) {
            if (task.isStopping()) {
                String errorMsg = Strings.format((String)"[%s] Error while processing data [%s]; task is stopping", (Object[])new Object[]{config.getId(), e.getMessage()});
                LOGGER.debug(errorMsg, (Throwable)e);
            } else {
                String errorMsg = Strings.format((String)"[%s] Error while processing data [%s]", (Object[])new Object[]{config.getId(), e.getMessage()});
                LOGGER.error(errorMsg, (Throwable)e);
                processContext.setFailureReason(errorMsg);
            }
        }
        finally {
            this.closeProcess(task);
            this.processContextByAllocation.remove(task.getAllocationId());
            LOGGER.debug("Removed process context for task [{}]; [{}] processes still running", (Object)config.getId(), (Object)this.processContextByAllocation.size());
            if (processContext.getFailureReason() == null) {
                this.auditor.info(config.getId(), "Finished analysis");
                listener.onResponse((Object)new StepResponse(false));
            } else {
                LOGGER.error("[{}] Marking task failed; {}", (Object)config.getId(), (Object)processContext.getFailureReason());
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)processContext.getFailureReason()));
            }
        }
    }

    private static void writeDataRows(DataFrameDataExtractor dataExtractor, AnalyticsProcess<AnalyticsResult> process, DataFrameAnalyticsTask task) throws IOException {
        ProgressTracker progressTracker = task.getStatsHolder().getProgressTracker();
        DataCountsTracker dataCountsTracker = task.getStatsHolder().getDataCountsTracker();
        String[] record = new String[dataExtractor.getFieldNames().size() + 2];
        record[record.length - 1] = "";
        long totalRows = process.getConfig().rows();
        long rowsProcessed = 0L;
        while (dataExtractor.hasNext()) {
            Optional<SearchHit[]> rows = dataExtractor.next();
            if (!rows.isPresent()) continue;
            for (SearchHit searchHit : rows.get()) {
                if (dataExtractor.isCancelled()) break;
                ++rowsProcessed;
                DataFrameDataExtractor.Row row = dataExtractor.createRow(searchHit);
                if (row.shouldSkip()) {
                    dataCountsTracker.incrementSkippedDocsCount();
                    continue;
                }
                String[] rowValues = row.getValues();
                System.arraycopy(rowValues, 0, record, 0, rowValues.length);
                record[record.length - 2] = String.valueOf(row.getChecksum());
                if (!row.isTraining()) continue;
                dataCountsTracker.incrementTrainingDocsCount();
                process.writeRecord(record);
            }
            progressTracker.updateLoadingDataProgress(rowsProcessed >= totalRows ? 100 : (int)((double)rowsProcessed * 100.0 / (double)totalRows));
        }
    }

    private static void writeHeaderRecord(DataFrameDataExtractor dataExtractor, AnalyticsProcess<AnalyticsResult> process, DataFrameAnalyticsTask task) throws IOException {
        List<String> fieldNames = dataExtractor.getFieldNames();
        LOGGER.debug(() -> Strings.format((String)"[%s] header row fields %s", (Object[])new Object[]{task.getParams().getId(), fieldNames}));
        String[] headerRecord = new String[fieldNames.size() + 2];
        for (int i = 0; i < fieldNames.size(); ++i) {
            headerRecord[i] = fieldNames.get(i);
        }
        headerRecord[headerRecord.length - 2] = ".";
        headerRecord[headerRecord.length - 1] = ".";
        process.writeRecord(headerRecord);
    }

    private void restoreState(DataFrameAnalyticsConfig config, AnalyticsProcess<AnalyticsResult> process, boolean hasState) {
        if (!config.getAnalysis().persistsState()) {
            LOGGER.debug("[{}] Analysis does not support state", (Object)config.getId());
            return;
        }
        if (!hasState) {
            LOGGER.debug("[{}] No model state available to restore", (Object)config.getId());
            return;
        }
        LOGGER.debug("[{}] Restoring from previous model state", (Object)config.getId());
        this.auditor.info(config.getId(), "Restoring from previous model state");
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            process.restoreState(this.client, config.getAnalysis().getStateDocIdPrefix(config.getId()));
        }
        catch (Exception e) {
            LOGGER.error(() -> "[" + process.getConfig().jobId() + "] Failed to restore state", (Throwable)e);
            throw ExceptionsHelper.serverError((String)("Failed to restore state: " + e.getMessage()));
        }
    }

    private AnalyticsProcess<AnalyticsResult> createProcess(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, AnalyticsProcessConfig analyticsProcessConfig, boolean hasState) {
        AnalyticsProcess<AnalyticsResult> process = this.processFactory.createAnalyticsProcess(config, analyticsProcessConfig, hasState, this.executorServiceForProcess, this.onProcessCrash(task));
        if (!process.isProcessAlive()) {
            throw ExceptionsHelper.serverError((String)"Failed to start data frame analytics process");
        }
        return process;
    }

    private Consumer<String> onProcessCrash(DataFrameAnalyticsTask task) {
        return reason -> {
            ProcessContext processContext = (ProcessContext)this.processContextByAllocation.get(task.getAllocationId());
            if (processContext != null) {
                processContext.setFailureReason((String)reason);
                processContext.stop();
            }
        };
    }

    private void closeProcess(DataFrameAnalyticsTask task) {
        String configId = task.getParams().getId();
        LOGGER.info("[{}] Closing process", (Object)configId);
        ProcessContext processContext = (ProcessContext)this.processContextByAllocation.get(task.getAllocationId());
        try {
            ((AnalyticsProcess)processContext.process.get()).close();
            LOGGER.info("[{}] Closed process", (Object)configId);
        }
        catch (Exception e) {
            if (task.isStopping()) {
                LOGGER.debug(() -> Strings.format((String)"[%s] Process closing was interrupted by kill request due to the task being stopped", (Object[])new Object[]{configId}), (Throwable)e);
                LOGGER.info("[{}] Closed process", (Object)configId);
            }
            LOGGER.error("[" + configId + "] Error closing data frame analyzer process", (Throwable)e);
            String errorMsg = Strings.format((String)"[%s] Error closing data frame analyzer process [%s]", (Object[])new Object[]{configId, e.getMessage()});
            processContext.setFailureReason(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DataFrameAnalyticsTask task) {
        ProcessContext processContext;
        ConcurrentMap<Long, ProcessContext> concurrentMap = this.processContextByAllocation;
        synchronized (concurrentMap) {
            processContext = (ProcessContext)this.processContextByAllocation.get(task.getAllocationId());
        }
        if (processContext != null) {
            LOGGER.debug("[{}] Stopping process", (Object)task.getParams().getId());
            processContext.stop();
        } else {
            LOGGER.debug("[{}] No process context to stop", (Object)task.getParams().getId());
        }
    }

    int getProcessContextCount() {
        return this.processContextByAllocation.size();
    }

    class ProcessContext {
        private final DataFrameAnalyticsConfig config;
        private final SetOnce<AnalyticsProcess<AnalyticsResult>> process = new SetOnce();
        private final SetOnce<DataFrameDataExtractor> dataExtractor = new SetOnce();
        private final SetOnce<AnalyticsResultProcessor> resultProcessor = new SetOnce();
        private final SetOnce<String> failureReason = new SetOnce();

        ProcessContext(DataFrameAnalyticsConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        String getFailureReason() {
            return (String)this.failureReason.get();
        }

        void setFailureReason(String failureReason) {
            if (failureReason == null) {
                return;
            }
            this.failureReason.trySet((Object)failureReason);
        }

        synchronized void stop() {
            LOGGER.debug("[{}] Stopping process", (Object)this.config.getId());
            if (this.dataExtractor.get() != null) {
                ((DataFrameDataExtractor)this.dataExtractor.get()).cancel();
            }
            if (this.resultProcessor.get() != null) {
                ((AnalyticsResultProcessor)this.resultProcessor.get()).cancel();
            }
            if (this.process.get() != null) {
                try {
                    ((AnalyticsProcess)this.process.get()).kill(true);
                }
                catch (IOException e) {
                    LOGGER.error(() -> "[" + this.config.getId() + "] Failed to kill process", (Throwable)e);
                }
            }
        }

        synchronized boolean startProcess(DataFrameDataExtractorFactory dataExtractorFactory, DataFrameAnalyticsTask task, boolean hasState) {
            if (task.isStopping()) {
                return false;
            }
            this.dataExtractor.set((Object)dataExtractorFactory.newExtractor(false));
            AnalyticsProcessConfig analyticsProcessConfig = this.createProcessConfig((DataFrameDataExtractor)this.dataExtractor.get(), dataExtractorFactory.getExtractedFields());
            LOGGER.debug("[{}] creating analytics process with config [{}]", (Object)this.config.getId(), (Object)org.elasticsearch.common.Strings.toString((ToXContent)analyticsProcessConfig));
            if (analyticsProcessConfig.rows() == 0L) {
                LOGGER.info("[{}] no data found to analyze. Will not start analytics native process.", (Object)this.config.getId());
                return false;
            }
            this.process.set(AnalyticsProcessManager.this.createProcess(task, this.config, analyticsProcessConfig, hasState));
            this.resultProcessor.set((Object)this.createResultProcessor(task, dataExtractorFactory));
            return true;
        }

        private AnalyticsProcessConfig createProcessConfig(DataFrameDataExtractor extractor, ExtractedFields extractedFields) {
            DataFrameDataExtractor.DataSummary dataSummary = extractor.collectDataSummary();
            Set<String> categoricalFields = extractor.getCategoricalFields(this.config.getAnalysis());
            int threads = Math.min(this.config.getMaxNumThreads(), AnalyticsProcessManager.this.numAllocatedProcessors);
            return new AnalyticsProcessConfig(this.config.getId(), dataSummary.rows, dataSummary.cols, this.config.getModelMemoryLimit(), threads, this.config.getDest().getResultsField(), categoricalFields, this.config.getAnalysis(), extractedFields);
        }

        private AnalyticsResultProcessor createResultProcessor(DataFrameAnalyticsTask task, DataFrameDataExtractorFactory dataExtractorFactory) {
            DataFrameRowsJoiner dataFrameRowsJoiner = new DataFrameRowsJoiner(this.config.getId(), AnalyticsProcessManager.this.settings, task.getParentTaskId(), dataExtractorFactory.newExtractor(true), AnalyticsProcessManager.this.resultsPersisterService);
            StatsPersister statsPersister = new StatsPersister(this.config.getId(), AnalyticsProcessManager.this.resultsPersisterService, AnalyticsProcessManager.this.auditor);
            return new AnalyticsResultProcessor(this.config, dataFrameRowsJoiner, task.getStatsHolder(), AnalyticsProcessManager.this.trainedModelProvider, AnalyticsProcessManager.this.auditor, statsPersister, ((DataFrameDataExtractor)this.dataExtractor.get()).getExtractedFields());
        }
    }
}

