/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.CharsRef;

public class MultiCharSequence
implements CharSequence {
    private final int[] lengths;
    private final List<CharSequence> sequenceList;

    public static MultiCharSequence from(CharSequence ... sequences) {
        ArrayList<CharSequence> sequenceList = new ArrayList<CharSequence>(sequences.length);
        sequenceList.addAll(Arrays.asList(sequences));
        return new MultiCharSequence(sequenceList);
    }

    public MultiCharSequence(List<CharSequence> sequenceList) {
        this.sequenceList = sequenceList;
        this.lengths = new int[sequenceList.size()];
        int i = 0;
        int length = 0;
        for (CharSequence sequence : sequenceList) {
            this.lengths[i++] = length += sequence.length();
        }
    }

    @Override
    public int length() {
        if (this.lengths.length == 0) {
            return 0;
        }
        return this.lengths[this.lengths.length - 1];
    }

    @Override
    public char charAt(int index) {
        if (this.lengths.length == 0) {
            throw new IndexOutOfBoundsException(index);
        }
        int sequenceIndex = Arrays.binarySearch(this.lengths, index + 1);
        if (sequenceIndex < 0) {
            sequenceIndex = -1 - sequenceIndex;
        }
        CharSequence sequence = this.sequenceList.get(sequenceIndex);
        if (sequenceIndex == 0) {
            return sequence.charAt(index);
        }
        return sequence.charAt(index - this.lengths[sequenceIndex - 1]);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int endIndex;
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (this.lengths.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end >= this.length()) {
            return this;
        }
        if (start == end) {
            return new CharsRef(CharsRef.EMPTY_CHARS, 0, 0);
        }
        int startIndex = Arrays.binarySearch(this.lengths, start);
        if (startIndex < 0) {
            startIndex = -1 - startIndex;
        }
        if ((endIndex = Arrays.binarySearch(this.lengths, end)) < 0) {
            endIndex = -1 - endIndex;
        }
        if (endIndex > this.lengths.length - 1) {
            endIndex = this.lengths.length - 1;
        }
        if (startIndex == endIndex) {
            if (startIndex == 0) {
                return this.sequenceList.get(startIndex).subSequence(start, end);
            }
            return this.sequenceList.get(startIndex).subSequence(start - this.lengths[startIndex - 1], end - this.lengths[startIndex - 1]);
        }
        ArrayList<CharSequence> sequences = new ArrayList<CharSequence>(endIndex - startIndex + 1);
        if (startIndex == 0) {
            sequences.add(this.sequenceList.get(startIndex).subSequence(start, this.sequenceList.get(startIndex).length()));
        } else {
            sequences.add(this.sequenceList.get(startIndex).subSequence(start - this.lengths[startIndex - 1], this.sequenceList.get(startIndex).length()));
        }
        if (endIndex - startIndex > 1) {
            sequences.addAll(this.sequenceList.subList(startIndex + 1, endIndex));
        }
        sequences.add(this.sequenceList.get(endIndex).subSequence(0, end - this.lengths[endIndex - 1]));
        return new MultiCharSequence(sequences);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (CharSequence sequence : this.sequenceList) {
            builder.append(sequence);
        }
        return builder.toString();
    }
}

