/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.unit.Processors;

public final class MlProcessors {
    private MlProcessors() {
    }

    public static Processors get(DiscoveryNode node, Integer allocatedProcessorScale) {
        String allocatedProcessorsString = (String)node.getAttributes().get("ml.allocated_processors_double");
        if (allocatedProcessorsString == null) {
            allocatedProcessorsString = (String)node.getAttributes().get("ml.allocated_processors");
        }
        if (allocatedProcessorsString == null) {
            return Processors.ZERO;
        }
        try {
            double processorsAsDouble = Double.parseDouble(allocatedProcessorsString);
            if (processorsAsDouble <= 0.0) {
                return Processors.ZERO;
            }
            if (allocatedProcessorScale != null) {
                processorsAsDouble /= (double)allocatedProcessorScale.intValue();
            }
            return Processors.of((Double)processorsAsDouble);
        }
        catch (NumberFormatException e) {
            assert (e == null) : "ml.allocated_processors_double should parse because we set it internally: invalid value was [" + allocatedProcessorsString + "]";
            return Processors.ZERO;
        }
    }

    public static Processors getMaxMlNodeProcessors(DiscoveryNodes nodes, Integer allocatedProcessorScale) {
        Processors answer = Processors.ZERO;
        for (DiscoveryNode node : nodes) {
            Processors nodeProcessors;
            if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE) || answer.compareTo(nodeProcessors = MlProcessors.get(node, allocatedProcessorScale)) >= 0) continue;
            answer = nodeProcessors;
        }
        return answer;
    }

    public static Processors getTotalMlNodeProcessors(Iterable<DiscoveryNode> nodes, Integer allocatedProcessorScale) {
        int total = 0;
        for (DiscoveryNode node : nodes) {
            if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) continue;
            Processors nodeProcessors = MlProcessors.get(node, allocatedProcessorScale);
            total += nodeProcessors.roundUp();
        }
        return total == 0 ? Processors.ZERO : Processors.of((Double)Double.valueOf(total));
    }
}

