/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.UriUtils;

public class ConnectionBuilder {
    public static String DEFAULT_CONNECTION_STRING = "http://localhost:9200/";
    public static URI DEFAULT_URI = URI.create(DEFAULT_CONNECTION_STRING);
    private CliTerminal cliTerminal;

    public ConnectionBuilder(CliTerminal cliTerminal) {
        this.cliTerminal = cliTerminal;
    }

    public ConnectionConfiguration buildConnection(String connectionStringArg, String keystoreLocation, boolean binaryCommunication) throws UserException {
        URI uri;
        String connectionString;
        Properties properties = new Properties();
        String user = null;
        String password = null;
        if (connectionStringArg != null) {
            int colonIndex;
            connectionString = connectionStringArg;
            uri = UriUtils.removeQuery(UriUtils.parseURI(connectionString, DEFAULT_URI), connectionString, DEFAULT_URI);
            user = uri.getUserInfo();
            if (user != null && (colonIndex = user.indexOf(58)) >= 0) {
                password = user.substring(colonIndex + 1);
                user = user.substring(0, colonIndex);
            }
        } else {
            uri = DEFAULT_URI;
            connectionString = DEFAULT_CONNECTION_STRING;
        }
        if (keystoreLocation != null) {
            if (!"https".equals(uri.getScheme())) {
                throw new UserException(64, "keystore file specified without https");
            }
            Path p = ConnectionBuilder.getKeystorePath(keystoreLocation);
            this.checkIfExists("keystore file", p);
            String keystorePassword = this.cliTerminal.readPassword("keystore password: ");
            properties.put("ssl.keystore.location", keystoreLocation);
            properties.put("ssl.keystore.pass", keystorePassword);
            properties.put("ssl.truststore.location", keystoreLocation);
            properties.put("ssl.truststore.pass", keystorePassword);
        }
        if ("https".equals(uri.getScheme())) {
            properties.put("ssl", "true");
        }
        if (user != null) {
            if (password == null) {
                password = this.cliTerminal.readPassword("password: ");
            }
            properties.setProperty("user", user);
            properties.setProperty("password", password);
        }
        properties.setProperty("binary.format", Boolean.toString(binaryCommunication));
        return this.newConnectionConfiguration(uri, connectionString, properties);
    }

    @SuppressForbidden(reason="cli application shouldn't depend on ES")
    private static Path getKeystorePath(String keystoreLocation) {
        return Paths.get(keystoreLocation, new String[0]);
    }

    protected ConnectionConfiguration newConnectionConfiguration(URI uri, String connectionString, Properties properties) {
        return new ConnectionConfiguration(uri, connectionString, properties);
    }

    protected void checkIfExists(String name, Path p) throws UserException {
        if (!Files.exists(p, new LinkOption[0])) {
            throw new UserException(64, name + " [" + String.valueOf(p) + "] doesn't exist");
        }
        if (!Files.isRegularFile(p, new LinkOption[0])) {
            throw new UserException(64, name + " [" + String.valueOf(p) + "] isn't a regular file");
        }
    }
}

