/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalService;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class MultilingualE5SmallInternalServiceSettings
extends ElasticsearchInternalServiceSettings {
    public static final String NAME = "multilingual_e5_small_service_settings";
    static final int DIMENSIONS = 384;
    static final SimilarityMeasure SIMILARITY = SimilarityMeasure.COSINE;

    public static MinimalServiceSettings minimalServiceSettings() {
        return MinimalServiceSettings.textEmbedding((int)384, (SimilarityMeasure)SIMILARITY, (DenseVectorFieldMapper.ElementType)DenseVectorFieldMapper.ElementType.FLOAT);
    }

    public static MultilingualE5SmallInternalServiceSettings defaultEndpointSettings(boolean useLinuxOptimizedModel) {
        return new MultilingualE5SmallInternalServiceSettings(null, 1, useLinuxOptimizedModel ? ".multilingual-e5-small_linux-x86_64" : ".multilingual-e5-small", new AdaptiveAllocationsSettings(Boolean.TRUE, Integer.valueOf(0), Integer.valueOf(32)));
    }

    public MultilingualE5SmallInternalServiceSettings(ElasticsearchInternalServiceSettings other) {
        super(other);
    }

    MultilingualE5SmallInternalServiceSettings(Integer numAllocations, int numThreads, String modelId, AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
        super(numAllocations, numThreads, modelId, adaptiveAllocationsSettings, null);
    }

    public MultilingualE5SmallInternalServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    public static ElasticsearchInternalServiceSettings.Builder fromRequestMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        ElasticsearchInternalServiceSettings.Builder baseSettings = ElasticsearchInternalServiceSettings.fromMap(map, validationException);
        String modelId = baseSettings.getModelId();
        if (modelId != null && !ElasticsearchInternalService.MULTILINGUAL_E5_SMALL_VALID_IDS.contains(modelId)) {
            validationException.addValidationError("unknown Multilingual-E5-Small model ID [" + modelId + "]. Valid IDs are " + Arrays.toString(ElasticsearchInternalService.MULTILINGUAL_E5_SMALL_VALID_IDS.toArray()));
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return baseSettings;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public SimilarityMeasure similarity() {
        return SIMILARITY;
    }

    public Integer dimensions() {
        return 384;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }
}

