/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.Map;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.FieldValueFetcher;
import org.elasticsearch.xpack.downsample.LabelFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

public final class AggregateMetricFieldValueFetcher
extends FieldValueFetcher {
    private final AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType;
    private final AbstractDownsampleFieldProducer fieldProducer;

    AggregateMetricFieldValueFetcher(MappedFieldType fieldType, AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType, IndexFieldData<?> fieldData) {
        super(fieldType.name(), fieldType, fieldData);
        this.aggMetricFieldType = aggMetricFieldType;
        this.fieldProducer = this.createFieldProducer();
    }

    @Override
    public AbstractDownsampleFieldProducer fieldProducer() {
        return this.fieldProducer;
    }

    private AbstractDownsampleFieldProducer createFieldProducer() {
        AggregateMetricDoubleFieldMapper.Metric metric = null;
        for (Map.Entry e : this.aggMetricFieldType.getMetricFields().entrySet()) {
            NumberFieldMapper.NumberFieldType metricSubField = (NumberFieldMapper.NumberFieldType)e.getValue();
            if (!metricSubField.name().equals(this.name())) continue;
            metric = (AggregateMetricDoubleFieldMapper.Metric)e.getKey();
            break;
        }
        assert (metric != null) : "Cannot resolve metric type for field " + this.name();
        if (this.aggMetricFieldType.getMetricType() != null) {
            return new MetricFieldProducer.AggregatedGaugeMetricFieldProducer(this.aggMetricFieldType.name(), metric);
        }
        return new LabelFieldProducer.AggregateMetricFieldProducer(this.aggMetricFieldType.name(), metric);
    }
}

