/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.QueryStringQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class QueryString
extends FullTextFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "QStr", QueryString::readFrom);

    @FunctionInfo(returnType={"boolean"}, preview=true, description="Performs a <<query-dsl-query-string-query,query string query>>. Returns true if the provided query string matches the row.", examples={@Example(file="qstr-function", tag="qstr-with-field")})
    public QueryString(Source source, @Param(name="query", type={"keyword", "text"}, description="Query string in Lucene query string format.") Expression queryString) {
        super(source, queryString, List.of(queryString), null);
    }

    public QueryString(Source source, Expression queryString, QueryBuilder queryBuilder) {
        super(source, queryString, List.of(queryString), queryBuilder);
    }

    private static QueryString readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_QUERY_BUILDER_IN_SEARCH_FUNCTIONS)) {
            queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        }
        return new QueryString(source, query, queryBuilder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_QUERY_BUILDER_IN_SEARCH_FUNCTIONS)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
        }
    }

    public String getWriteableName() {
        return QueryString.ENTRY.name;
    }

    public String functionName() {
        return "QSTR";
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new QueryString(this.source(), newChildren.get(0), this.queryBuilder());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, QueryString::new, (Object)this.query(), (Object)this.queryBuilder());
    }

    @Override
    protected Query translate(TranslatorHandler handler) {
        return new QueryStringQuery(this.source(), Objects.toString(this.queryAsObject()), Map.of(), Map.of());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new QueryString(this.source(), this.query(), queryBuilder);
    }
}

