/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import org.apache.lucene.util.automaton.Automata;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.WildcardQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AutomataMatch;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class WildcardLike
extends org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardLike
implements EvaluatorMapper,
TranslationAware.SingleValueTranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "WildcardLike", WildcardLike::new);

    @FunctionInfo(returnType={"boolean"}, description="Use `LIKE` to filter data based on string patterns using wildcards. `LIKE`\nusually acts on a field placed on the left-hand side of the operator, but it can\nalso act on a constant (literal) expression. The right-hand side of the operator\nrepresents the pattern.\n\nThe following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.", detailedDescription="Matching the exact characters `*` and `.` will require escaping.\nThe escape character is backslash `\\`. Since also backslash is a special character in string literals,\nit will require further escaping.\n\n[source.merge.styled,esql]\n----\ninclude::{esql-specs}/string.csv-spec[tag=likeEscapingSingleQuotes]\n----\n\nTo reduce the overhead of escaping, we suggest using triple quotes strings `\"\"\"`\n\n[source.merge.styled,esql]\n----\ninclude::{esql-specs}/string.csv-spec[tag=likeEscapingTripleQuotes]\n----\n", operator="LIKE", examples={@Example(file="docs", tag="like")})
    public WildcardLike(Source source, @Param(name="str", type={"keyword", "text"}, description="A literal expression.") Expression left, @Param(name="pattern", type={"keyword", "text"}, description="Pattern.") WildcardPattern pattern) {
        super(source, left, pattern, false);
    }

    private WildcardLike(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), new WildcardPattern(in.readString()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeString(((WildcardPattern)this.pattern()).pattern());
    }

    public String getWriteableName() {
        return WildcardLike.ENTRY.name;
    }

    protected NodeInfo<org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardLike> info() {
        return NodeInfo.create((Node)this, WildcardLike::new, (Object)this.field(), (Object)((WildcardPattern)this.pattern()));
    }

    protected WildcardLike replaceChild(Expression newLeft) {
        return new WildcardLike(this.source(), newLeft, (WildcardPattern)this.pattern());
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isString((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public Boolean fold(FoldContext ctx) {
        return (Boolean)EvaluatorMapper.super.fold(this.source(), ctx);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return AutomataMatch.toEvaluator(this.source(), toEvaluator.apply(this.field()), ((WildcardPattern)this.pattern()).pattern().length() == 0 ? Automata.makeEmptyString() : ((WildcardPattern)this.pattern()).createAutomaton());
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableAttribute(this.field());
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        Expression expression;
        Expression field = this.field();
        LucenePushdownPredicates.checkIsPushableAttribute(field);
        if (field instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)field;
            expression = fa.exactAttribute();
        } else {
            expression = field;
        }
        return this.translateField(handler.nameOf(expression));
    }

    private Query translateField(String targetFieldName) {
        return new WildcardQuery(this.source(), targetFieldName, ((WildcardPattern)this.pattern()).asLuceneWildcard(), this.caseInsensitive());
    }

    @Override
    public Expression singleValueField() {
        return this.field();
    }
}

