/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushFiltersToSource;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.planner.mapper.LocalMapper;
import org.elasticsearch.xpack.esql.planner.mapper.Mapper;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.stats.SearchContextStats;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class PlannerUtils {
    @Deprecated(forRemoval=true)
    public static final BlockFactory NON_BREAKING_BLOCK_FACTORY = BlockFactory.getInstance((CircuitBreaker)new NoopCircuitBreaker("noop-esql-breaker"), (BigArrays)BigArrays.NON_RECYCLING_INSTANCE);

    public static Tuple<PhysicalPlan, PhysicalPlan> breakPlanBetweenCoordinatorAndDataNode(PhysicalPlan plan, Configuration config) {
        Holder dataNodePlan = new Holder();
        PhysicalPlan coordinatorPlan = (PhysicalPlan)plan.transformUp(ExchangeExec.class, e -> {
            PhysicalPlan subplan = e.child();
            dataNodePlan.set((Object)new ExchangeSinkExec(e.source(), e.output(), e.inBetweenAggs(), subplan));
            return new ExchangeSourceExec(e.source(), e.output(), e.inBetweenAggs());
        });
        return new Tuple((Object)coordinatorPlan, (Object)((PhysicalPlan)((Object)dataNodePlan.get())));
    }

    public static PhysicalPlan reductionPlan(PhysicalPlan plan) {
        List fragments = plan.collectFirstChildren(p -> p instanceof FragmentExec);
        if (fragments.isEmpty()) {
            return null;
        }
        FragmentExec fragment = (FragmentExec)fragments.get(0);
        List pipelineBreakers = fragment.fragment().collectFirstChildren(Mapper::isPipelineBreaker);
        if (pipelineBreakers.isEmpty()) {
            return null;
        }
        LocalMapper mapper = new LocalMapper();
        LogicalPlan pipelineBreaker = (LogicalPlan)((Object)pipelineBreakers.get(0));
        PhysicalPlan reducePlan = mapper.map(pipelineBreaker);
        if (reducePlan instanceof AggregateExec) {
            AggregateExec agg = (AggregateExec)reducePlan;
            reducePlan = agg.withMode(AggregatorMode.INITIAL);
        }
        return EstimatesRowSize.estimateRowSize(fragment.estimatedRowSize(), reducePlan);
    }

    public static Set<String> planConcreteIndices(PhysicalPlan plan) {
        if (plan == null) {
            return Set.of();
        }
        LinkedHashSet<String> indices = new LinkedHashSet<String>();
        PlannerUtils.forEachRelation(plan, relation -> indices.addAll(relation.concreteIndices()));
        return indices;
    }

    public static String[] planOriginalIndices(PhysicalPlan plan) {
        if (plan == null) {
            return Strings.EMPTY_ARRAY;
        }
        LinkedHashSet indices = new LinkedHashSet();
        PlannerUtils.forEachRelation(plan, relation -> indices.addAll(Arrays.asList(Strings.commaDelimitedListToStringArray((String)relation.indexPattern()))));
        return (String[])indices.toArray(String[]::new);
    }

    private static void forEachRelation(PhysicalPlan plan, Consumer<EsRelation> action) {
        plan.forEachDown(FragmentExec.class, f -> f.fragment().forEachDown(EsRelation.class, r -> {
            if (r.indexMode() != IndexMode.LOOKUP) {
                action.accept((EsRelation)((Object)r));
            }
        }));
    }

    public static PhysicalPlan localPlan(List<SearchExecutionContext> searchContexts, Configuration configuration, FoldContext foldCtx, PhysicalPlan plan) {
        return PlannerUtils.localPlan(configuration, foldCtx, plan, SearchContextStats.from(searchContexts));
    }

    public static PhysicalPlan localPlan(Configuration configuration, FoldContext foldCtx, PhysicalPlan plan, SearchStats searchStats) {
        LocalLogicalPlanOptimizer logicalOptimizer = new LocalLogicalPlanOptimizer(new LocalLogicalOptimizerContext(configuration, foldCtx, searchStats));
        LocalPhysicalPlanOptimizer physicalOptimizer = new LocalPhysicalPlanOptimizer(new LocalPhysicalOptimizerContext(configuration, foldCtx, searchStats));
        return PlannerUtils.localPlan(plan, logicalOptimizer, physicalOptimizer);
    }

    public static PhysicalPlan localPlan(PhysicalPlan plan, LocalLogicalPlanOptimizer logicalOptimizer, LocalPhysicalPlanOptimizer physicalOptimizer) {
        LocalMapper localMapper = new LocalMapper();
        Holder isCoordPlan = new Holder((Object)Boolean.TRUE);
        PhysicalPlan localPhysicalPlan = (PhysicalPlan)plan.transformUp(FragmentExec.class, f -> {
            isCoordPlan.set((Object)Boolean.FALSE);
            LogicalPlan optimizedFragment = logicalOptimizer.localOptimize(f.fragment());
            PhysicalPlan physicalFragment = localMapper.map(optimizedFragment);
            QueryBuilder filter = f.esFilter();
            if (filter != null) {
                physicalFragment = (PhysicalPlan)physicalFragment.transformUp(EsSourceExec.class, query -> new EsSourceExec(Source.EMPTY, query.indexPattern(), query.indexMode(), query.indexNameWithModes(), query.output(), filter));
            }
            PhysicalPlan localOptimized = physicalOptimizer.localOptimize(physicalFragment);
            return EstimatesRowSize.estimateRowSize(f.estimatedRowSize(), localOptimized);
        });
        return (Boolean)isCoordPlan.get() != false ? plan : localPhysicalPlan;
    }

    public static QueryBuilder requestTimestampFilter(PhysicalPlan plan) {
        return PlannerUtils.detectFilter(plan, "@timestamp");
    }

    static QueryBuilder detectFilter(PhysicalPlan plan, String fieldName) {
        QueryBuilder[] requestFilter = new QueryBuilder[]{null, null};
        plan.forEachDown(FragmentExec.class, fe -> {
            requestFilter[0] = fe.esFilter();
            fe.fragment().forEachUp(Filter.class, f -> {
                ArrayList<Expression> matches = new ArrayList<Expression>();
                if (f.child() instanceof EsRelation) {
                    List<Expression> conjunctions = Predicates.splitAnd(f.condition());
                    for (Expression exp : conjunctions) {
                        AttributeSet refs = new AttributeSet((Collection)exp.references());
                        boolean matchesField = refs.removeIf(e -> fieldName.equals(e.name()));
                        if (!matchesField || !refs.isEmpty() || !PushFiltersToSource.canPushToSource(exp)) continue;
                        matches.add(exp);
                    }
                }
                if (matches.size() > 0) {
                    requestFilter[1] = TranslatorHandler.TRANSLATOR_HANDLER.asQuery(Predicates.combineAnd(matches)).asBuilder();
                }
            });
        });
        return Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(requestFilter));
    }

    public static ElementType toSortableElementType(DataType dataType) {
        if (DataType.isSpatial((DataType)dataType)) {
            return ElementType.UNKNOWN;
        }
        return PlannerUtils.toElementType(dataType);
    }

    public static ElementType toElementType(DataType dataType) {
        return PlannerUtils.toElementType(dataType, MappedFieldType.FieldExtractPreference.NONE);
    }

    public static ElementType toElementType(DataType dataType, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        return switch (dataType) {
            default -> throw new IncompatibleClassChangeError();
            case DataType.LONG, DataType.DATETIME, DataType.DATE_NANOS, DataType.UNSIGNED_LONG, DataType.COUNTER_LONG -> ElementType.LONG;
            case DataType.INTEGER, DataType.COUNTER_INTEGER -> ElementType.INT;
            case DataType.DOUBLE, DataType.COUNTER_DOUBLE -> ElementType.DOUBLE;
            case DataType.KEYWORD, DataType.TEXT, DataType.IP, DataType.SOURCE, DataType.VERSION, DataType.SEMANTIC_TEXT, DataType.UNSUPPORTED -> ElementType.BYTES_REF;
            case DataType.NULL -> ElementType.NULL;
            case DataType.BOOLEAN -> ElementType.BOOLEAN;
            case DataType.DOC_DATA_TYPE -> ElementType.DOC;
            case DataType.TSID_DATA_TYPE -> ElementType.BYTES_REF;
            case DataType.GEO_POINT, DataType.CARTESIAN_POINT -> {
                if (fieldExtractPreference == MappedFieldType.FieldExtractPreference.DOC_VALUES) {
                    yield ElementType.LONG;
                }
                yield ElementType.BYTES_REF;
            }
            case DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE -> {
                if (fieldExtractPreference == MappedFieldType.FieldExtractPreference.EXTRACT_SPATIAL_BOUNDS) {
                    yield ElementType.INT;
                }
                yield ElementType.BYTES_REF;
            }
            case DataType.PARTIAL_AGG, DataType.AGGREGATE_METRIC_DOUBLE -> ElementType.COMPOSITE;
            case DataType.SHORT, DataType.BYTE, DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.OBJECT, DataType.FLOAT, DataType.HALF_FLOAT, DataType.SCALED_FLOAT -> throw EsqlIllegalArgumentException.illegalDataType(dataType);
        };
    }
}

