/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobContainerUtils;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.ChunkedBlobOutputStream;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3RetryingInputStream;
import org.elasticsearch.repositories.s3.SocketAccess;
import org.elasticsearch.threadpool.ThreadPool;

class S3BlobContainer
extends AbstractBlobContainer {
    private static final Logger logger = LogManager.getLogger(S3BlobContainer.class);
    private final S3BlobStore blobStore;
    private final String keyPath;

    S3BlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
    }

    public boolean blobExists(OperationPurpose purpose, String blobName) {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        try {
            boolean bl = SocketAccess.doPrivileged(() -> this.doesObjectExist(purpose, clientReference, this.blobStore.bucket(), this.buildKey(blobName)));
            if (clientReference != null) {
                clientReference.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (clientReference != null) {
                    try {
                        clientReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
            }
        }
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName) throws IOException {
        return new S3RetryingInputStream(purpose, this.blobStore, this.buildKey(blobName));
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new S3RetryingInputStream(purpose, this.blobStore, this.buildKey(blobName), position, Math.addExact(position, length - 1L));
    }

    public long readBlobPreferredLength() {
        return new ByteSizeValue(32L, ByteSizeUnit.MB).getBytes();
    }

    public void writeBlob(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        assert (BlobContainer.assertPurposeConsistency((OperationPurpose)purpose, (String)blobName));
        assert (inputStream.markSupported()) : "No mark support on inputStream breaks the S3 SDK's ability to retry requests";
        SocketAccess.doPrivilegedIOException(() -> {
            if (blobSize <= this.getLargeBlobThresholdInBytes()) {
                this.executeSingleUpload(purpose, this.blobStore, this.buildKey(blobName), inputStream, blobSize);
            } else {
                this.executeMultipartUpload(purpose, this.blobStore, this.buildKey(blobName), inputStream, blobSize);
            }
            return null;
        });
    }

    public void writeMetadataBlob(final OperationPurpose purpose, final String blobName, final boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        assert (purpose != OperationPurpose.SNAPSHOT_DATA && BlobContainer.assertPurposeConsistency((OperationPurpose)purpose, (String)blobName)) : purpose;
        final String absoluteBlobKey = this.buildKey(blobName);
        try (final AmazonS3Reference clientReference = this.blobStore.clientReference();
             ChunkedBlobOutputStream<PartETag> out = new ChunkedBlobOutputStream<PartETag>(this.blobStore.bigArrays(), this.blobStore.bufferSizeInBytes()){
            private final SetOnce<String> uploadId;
            {
                super(arg0, arg1);
                this.uploadId = new SetOnce();
            }

            protected void flushBuffer() throws IOException {
                this.flushBuffer(false);
            }

            private void flushBuffer(boolean lastPart) throws IOException {
                if (this.buffer.size() == 0) {
                    return;
                }
                if (this.flushedBytes == 0L) {
                    assert (!lastPart) : "use single part upload if there's only a single part";
                    this.uploadId.set((Object)SocketAccess.doPrivileged(() -> clientReference.client().initiateMultipartUpload(S3BlobContainer.this.initiateMultiPartUpload(purpose, absoluteBlobKey)).getUploadId()));
                    if (Strings.isEmpty((CharSequence)((CharSequence)this.uploadId.get()))) {
                        throw new IOException("Failed to initialize multipart upload " + absoluteBlobKey);
                    }
                }
                assert (!lastPart || this.successful) : "must only write last part if successful";
                UploadPartRequest uploadRequest = S3BlobContainer.this.createPartUploadRequest(purpose, (InputStream)this.buffer.bytes().streamInput(), (String)this.uploadId.get(), this.parts.size() + 1, absoluteBlobKey, this.buffer.size(), lastPart);
                UploadPartResult uploadResponse = SocketAccess.doPrivileged(() -> clientReference.client().uploadPart(uploadRequest));
                this.finishPart(uploadResponse.getPartETag());
            }

            protected void onCompletion() throws IOException {
                if (this.flushedBytes == 0L) {
                    S3BlobContainer.this.writeBlob(purpose, blobName, this.buffer.bytes(), failIfAlreadyExists);
                } else {
                    this.flushBuffer(true);
                    CompleteMultipartUploadRequest complRequest = new CompleteMultipartUploadRequest(S3BlobContainer.this.blobStore.bucket(), absoluteBlobKey, (String)this.uploadId.get(), this.parts);
                    S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)complRequest, S3BlobContainer.this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, purpose);
                    SocketAccess.doPrivilegedVoid(() -> clientReference.client().completeMultipartUpload(complRequest));
                }
            }

            protected void onFailure() {
                if (Strings.hasText((String)((String)this.uploadId.get()))) {
                    S3BlobContainer.this.abortMultiPartUpload(purpose, (String)this.uploadId.get(), absoluteBlobKey);
                }
            }
        };){
            writer.accept((Object)out);
            out.markSuccess();
        }
    }

    private boolean doesObjectExist(OperationPurpose purpose, AmazonS3Reference clientReference, String bucketName, String objectName) {
        try {
            ValidationUtils.assertStringNotEmpty((String)bucketName, (String)"bucketName");
            ValidationUtils.assertStringNotEmpty((String)objectName, (String)"objectName");
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucketName, objectName);
            S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)getObjectMetadataRequest, this.blobStore, S3BlobStore.Operation.HEAD_OBJECT, purpose);
            clientReference.client().getObjectMetadata(getObjectMetadataRequest);
            return true;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private UploadPartRequest createPartUploadRequest(OperationPurpose purpose, InputStream stream, String uploadId, int number, String blobName, long size, boolean lastPart) {
        UploadPartRequest uploadRequest = new UploadPartRequest();
        uploadRequest.setBucketName(this.blobStore.bucket());
        uploadRequest.setKey(blobName);
        uploadRequest.setUploadId(uploadId);
        uploadRequest.setPartNumber(number);
        uploadRequest.setInputStream(stream);
        S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)uploadRequest, this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, purpose);
        uploadRequest.setPartSize(size);
        uploadRequest.setLastPart(lastPart);
        return uploadRequest;
    }

    private void abortMultiPartUpload(OperationPurpose purpose, String uploadId, String blobName) {
        AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(this.blobStore.bucket(), blobName, uploadId);
        S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)abortRequest, this.blobStore, S3BlobStore.Operation.ABORT_MULTIPART_OBJECT, purpose);
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            SocketAccess.doPrivilegedVoid(() -> clientReference.client().abortMultipartUpload(abortRequest));
        }
    }

    private InitiateMultipartUploadRequest initiateMultiPartUpload(OperationPurpose purpose, String blobName) {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.blobStore.bucket(), blobName);
        initRequest.setStorageClass(this.blobStore.getStorageClass());
        initRequest.setCannedACL(this.blobStore.getCannedACL());
        S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)initRequest, this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, purpose);
        if (this.blobStore.serverSideEncryption()) {
            ObjectMetadata md = new ObjectMetadata();
            md.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            initRequest.setObjectMetadata(md);
        }
        return initRequest;
    }

    long getLargeBlobThresholdInBytes() {
        return this.blobStore.bufferSizeInBytes();
    }

    public void writeBlobAtomic(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        assert (BlobContainer.assertPurposeConsistency((OperationPurpose)purpose, (String)blobName));
        this.writeBlob(purpose, blobName, bytes, failIfAlreadyExists);
    }

    public DeleteResult delete(OperationPurpose purpose) throws IOException {
        AtomicLong deletedBlobs = new AtomicLong();
        AtomicLong deletedBytes = new AtomicLong();
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            Iterator blobNameIterator;
            ObjectListing prevListing = null;
            while (true) {
                ObjectListing list;
                if (prevListing != null) {
                    ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest = new ListNextBatchOfObjectsRequest(prevListing);
                    S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)listNextBatchOfObjectsRequest, this.blobStore, S3BlobStore.Operation.LIST_OBJECTS, purpose);
                    list = SocketAccess.doPrivileged(() -> clientReference.client().listNextBatchOfObjects(listNextBatchOfObjectsRequest));
                } else {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
                    listObjectsRequest.setBucketName(this.blobStore.bucket());
                    listObjectsRequest.setPrefix(this.keyPath);
                    S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)listObjectsRequest, this.blobStore, S3BlobStore.Operation.LIST_OBJECTS, purpose);
                    list = SocketAccess.doPrivileged(() -> clientReference.client().listObjects(listObjectsRequest));
                }
                blobNameIterator = Iterators.map(list.getObjectSummaries().iterator(), summary -> {
                    deletedBlobs.incrementAndGet();
                    deletedBytes.addAndGet(summary.getSize());
                    return summary.getKey();
                });
                if (!list.isTruncated()) break;
                this.blobStore.deleteBlobs(purpose, blobNameIterator);
                prevListing = list;
            }
            this.blobStore.deleteBlobs(purpose, Iterators.concat((Iterator[])new Iterator[]{blobNameIterator, Iterators.single((Object)this.keyPath)}));
        }
        catch (AmazonClientException e) {
            throw new IOException("Exception when deleting blob container [" + this.keyPath + "]", e);
        }
        return new DeleteResult(deletedBlobs.get(), deletedBytes.get());
    }

    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) throws IOException {
        this.blobStore.deleteBlobs(purpose, Iterators.map(blobNames, this::buildKey));
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, @Nullable String blobNamePrefix) throws IOException {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        try {
            Map<String, BlobMetadata> map = this.executeListing(purpose, clientReference, this.listObjectsRequest(purpose, blobNamePrefix == null ? this.keyPath : this.buildKey(blobNamePrefix))).stream().flatMap(listing -> listing.getObjectSummaries().stream()).map(summary -> new BlobMetadata(summary.getKey().substring(this.keyPath.length()), summary.getSize())).collect(Collectors.toMap(BlobMetadata::name, Function.identity()));
            if (clientReference != null) {
                clientReference.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (clientReference != null) {
                    try {
                        clientReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AmazonClientException e) {
                throw new IOException("Exception when listing blobs by prefix [" + blobNamePrefix + "]", e);
            }
        }
    }

    public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
        return this.listBlobsByPrefix(purpose, null);
    }

    public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        try {
            Map<String, BlobContainer> map = this.executeListing(purpose, clientReference, this.listObjectsRequest(purpose, this.keyPath)).stream().flatMap(listing -> {
                assert (listing.getObjectSummaries().stream().noneMatch(s -> {
                    for (String commonPrefix : listing.getCommonPrefixes()) {
                        if (!s.getKey().substring(this.keyPath.length()).startsWith(commonPrefix)) continue;
                        return true;
                    }
                    return false;
                })) : "Response contained children for listed common prefixes.";
                return listing.getCommonPrefixes().stream();
            }).map(prefix -> prefix.substring(this.keyPath.length())).filter(name -> !name.isEmpty()).map(name -> name.substring(0, name.length() - 1)).collect(Collectors.toMap(Function.identity(), name -> this.blobStore.blobContainer(this.path().add(name))));
            if (clientReference != null) {
                clientReference.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (clientReference != null) {
                    try {
                        clientReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AmazonClientException e) {
                throw new IOException("Exception when listing children of [" + this.path().buildAsString() + "]", e);
            }
        }
    }

    private List<ObjectListing> executeListing(OperationPurpose purpose, AmazonS3Reference clientReference, ListObjectsRequest listObjectsRequest) {
        ArrayList<ObjectListing> results = new ArrayList<ObjectListing>();
        ObjectListing prevListing = null;
        while (true) {
            ObjectListing list;
            if (prevListing != null) {
                ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest = new ListNextBatchOfObjectsRequest(prevListing);
                S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)listNextBatchOfObjectsRequest, this.blobStore, S3BlobStore.Operation.LIST_OBJECTS, purpose);
                list = SocketAccess.doPrivileged(() -> clientReference.client().listNextBatchOfObjects(listNextBatchOfObjectsRequest));
            } else {
                list = SocketAccess.doPrivileged(() -> clientReference.client().listObjects(listObjectsRequest));
            }
            results.add(list);
            if (!list.isTruncated()) break;
            prevListing = list;
        }
        return results;
    }

    private ListObjectsRequest listObjectsRequest(OperationPurpose purpose, String pathPrefix) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.blobStore.bucket()).withPrefix(pathPrefix).withDelimiter("/");
        S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)listObjectsRequest, this.blobStore, S3BlobStore.Operation.LIST_OBJECTS, purpose);
        return listObjectsRequest;
    }

    String buildKey(String blobName) {
        return this.keyPath + blobName;
    }

    void executeSingleUpload(OperationPurpose purpose, S3BlobStore s3BlobStore, String blobName, InputStream input, long blobSize) throws IOException {
        if (blobSize > S3Repository.MAX_FILE_SIZE.getBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than " + String.valueOf(S3Repository.MAX_FILE_SIZE));
        }
        if (blobSize > s3BlobStore.bufferSizeInBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than buffer size");
        }
        ObjectMetadata md = new ObjectMetadata();
        md.setContentLength(blobSize);
        if (s3BlobStore.serverSideEncryption()) {
            md.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        PutObjectRequest putRequest = new PutObjectRequest(s3BlobStore.bucket(), blobName, input, md);
        putRequest.setStorageClass(s3BlobStore.getStorageClass());
        putRequest.setCannedAcl(s3BlobStore.getCannedACL());
        S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)putRequest, this.blobStore, S3BlobStore.Operation.PUT_OBJECT, purpose);
        try (AmazonS3Reference clientReference = s3BlobStore.clientReference();){
            SocketAccess.doPrivilegedVoid(() -> clientReference.client().putObject(putRequest));
        }
        catch (AmazonClientException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using a single upload", e);
        }
    }

    void executeMultipartUpload(OperationPurpose purpose, S3BlobStore s3BlobStore, String blobName, InputStream input, long blobSize) throws IOException {
        this.ensureMultiPartUploadSize(blobSize);
        long partSize = s3BlobStore.bufferSizeInBytes();
        Tuple<Long, Long> multiparts = S3BlobContainer.numberOfMultiparts(blobSize, partSize);
        if ((Long)multiparts.v1() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many multipart upload requests, maybe try a larger buffer size?");
        }
        int nbParts = ((Long)multiparts.v1()).intValue();
        long lastPartSize = (Long)multiparts.v2();
        assert (blobSize == (long)(nbParts - 1) * partSize + lastPartSize) : "blobSize does not match multipart sizes";
        SetOnce uploadId = new SetOnce();
        String bucketName = s3BlobStore.bucket();
        boolean success = false;
        try (AmazonS3Reference clientReference = s3BlobStore.clientReference();){
            uploadId.set((Object)SocketAccess.doPrivileged(() -> clientReference.client().initiateMultipartUpload(this.initiateMultiPartUpload(purpose, blobName)).getUploadId()));
            if (Strings.isEmpty((CharSequence)((CharSequence)uploadId.get()))) {
                throw new IOException("Failed to initialize multipart upload " + blobName);
            }
            ArrayList<PartETag> parts = new ArrayList<PartETag>();
            long bytesCount = 0L;
            for (int i = 1; i <= nbParts; ++i) {
                boolean lastPart = i == nbParts;
                UploadPartRequest uploadRequest = this.createPartUploadRequest(purpose, input, (String)uploadId.get(), i, blobName, lastPart ? lastPartSize : partSize, lastPart);
                bytesCount += uploadRequest.getPartSize();
                UploadPartResult uploadResponse = SocketAccess.doPrivileged(() -> clientReference.client().uploadPart(uploadRequest));
                parts.add(uploadResponse.getPartETag());
            }
            if (bytesCount != blobSize) {
                throw new IOException("Failed to execute multipart upload for [" + blobName + "], expected " + blobSize + "bytes sent but got " + bytesCount);
            }
            CompleteMultipartUploadRequest complRequest = new CompleteMultipartUploadRequest(bucketName, blobName, (String)uploadId.get(), parts);
            S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)complRequest, this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, purpose);
            SocketAccess.doPrivilegedVoid(() -> clientReference.client().completeMultipartUpload(complRequest));
            success = true;
        }
        catch (AmazonClientException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using multipart upload", e);
        }
        finally {
            if (!success && Strings.hasLength((String)((String)uploadId.get()))) {
                this.abortMultiPartUpload(purpose, (String)uploadId.get(), blobName);
            }
        }
    }

    void ensureMultiPartUploadSize(long blobSize) {
        if (blobSize > S3Repository.MAX_FILE_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be larger than " + String.valueOf(S3Repository.MAX_FILE_SIZE_USING_MULTIPART));
        }
        if (blobSize < S3Repository.MIN_PART_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be smaller than " + String.valueOf(S3Repository.MIN_PART_SIZE_USING_MULTIPART));
        }
    }

    static Tuple<Long, Long> numberOfMultiparts(long totalSize, long partSize) {
        if (partSize <= 0L) {
            throw new IllegalArgumentException("Part size must be greater than zero");
        }
        if (totalSize == 0L || totalSize <= partSize) {
            return Tuple.tuple((Object)1L, (Object)totalSize);
        }
        long parts = totalSize / partSize;
        long remaining = totalSize % partSize;
        if (remaining == 0L) {
            return Tuple.tuple((Object)parts, (Object)partSize);
        }
        return Tuple.tuple((Object)(parts + 1L), (Object)remaining);
    }

    public void compareAndExchangeRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        ActionListener.run((ActionListener)ActionListener.releaseAfter((ActionListener)listener.delegateResponse((delegate, e) -> {
            AmazonS3Exception amazonS3Exception;
            logger.trace(() -> Strings.format((String)"[%s]: compareAndExchangeRegister failed", (Object[])new Object[]{key}), (Throwable)e);
            if (e instanceof AmazonS3Exception && ((amazonS3Exception = (AmazonS3Exception)((Object)((Object)e))).getStatusCode() == 404 || amazonS3Exception.getStatusCode() == 0 && "NoSuchUpload".equals(amazonS3Exception.getErrorCode()))) {
                delegate.onResponse((Object)OptionalBytesReference.MISSING);
            } else {
                delegate.onFailure(e);
            }
        }), (Releasable)clientReference), l -> new CompareAndExchangeOperation(purpose, clientReference.client(), this.blobStore.bucket(), key, this.blobStore.getThreadPool()).run(expected, updated, (ActionListener<OptionalBytesReference>)l));
    }

    public void getRegister(OperationPurpose purpose, String key, ActionListener<OptionalBytesReference> listener) {
        ActionListener.completeWith(listener, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ActionListener<Void> getMultipartUploadCleanupListener(int maxUploads, RefCountingRunnable refs) {
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            String bucket = this.blobStore.bucket();
            ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(bucket).withPrefix(this.keyPath).withMaxUploads(maxUploads);
            request.putCustomQueryParameter("x-purpose", OperationPurpose.SNAPSHOT_DATA.getKey());
            MultipartUploadListing multipartUploadListing = SocketAccess.doPrivileged(() -> clientReference.client().listMultipartUploads(request));
            List multipartUploads = multipartUploadListing.getMultipartUploads();
            if (multipartUploads.isEmpty()) {
                logger.debug("found no multipart uploads to clean up");
                ActionListener actionListener = ActionListener.noop();
                return actionListener;
            }
            if (multipartUploadListing.isTruncated()) {
                logger.info("found at least [{}] possibly-dangling multipart uploads; will clean up the first [{}] after finalizing the current snapshot deletions, and will check for further possibly-dangling multipart uploads in future snapshot deletions", (Object)multipartUploads.size(), (Object)multipartUploads.size());
            } else {
                logger.info("found [{}] possibly-dangling multipart uploads; will clean them up after finalizing the current snapshot deletions", (Object)multipartUploads.size());
            }
            ActionListener<Void> actionListener = this.newMultipartUploadCleanupListener(refs, multipartUploads.stream().map(u -> new AbortMultipartUploadRequest(bucket, u.getKey(), u.getUploadId())).toList());
            return actionListener;
        }
        catch (Exception e) {
            logger.warn("failure while checking for possibly-dangling multipart uploads", (Throwable)e);
            return ActionListener.noop();
        }
    }

    private ActionListener<Void> newMultipartUploadCleanupListener(RefCountingRunnable refs, final List<AbortMultipartUploadRequest> abortMultipartUploadRequests) {
        return new ThreadedActionListener(this.blobStore.getSnapshotExecutor(), ActionListener.releaseAfter((ActionListener)new ActionListener<Void>(){

            public void onResponse(Void unused) {
                try (AmazonS3Reference clientReference = S3BlobContainer.this.blobStore.clientReference();){
                    for (AbortMultipartUploadRequest abortMultipartUploadRequest : abortMultipartUploadRequests) {
                        abortMultipartUploadRequest.putCustomQueryParameter("x-purpose", OperationPurpose.SNAPSHOT_DATA.getKey());
                        try {
                            SocketAccess.doPrivilegedVoid(() -> clientReference.client().abortMultipartUpload(abortMultipartUploadRequest));
                            logger.info("cleaned up dangling multipart upload [{}] of blob [{}][{}][{}]", (Object)abortMultipartUploadRequest.getUploadId(), (Object)S3BlobContainer.this.blobStore.getRepositoryMetadata().name(), (Object)abortMultipartUploadRequest.getBucketName(), (Object)abortMultipartUploadRequest.getKey());
                        }
                        catch (Exception e) {
                            logger.warn(Strings.format((String)"failed to clean up multipart upload [%s] of blob [%s][%s][%s]", (Object[])new Object[]{abortMultipartUploadRequest.getUploadId(), S3BlobContainer.this.blobStore.getRepositoryMetadata().name(), abortMultipartUploadRequest.getBucketName(), abortMultipartUploadRequest.getKey()}), (Throwable)e);
                        }
                    }
                }
            }

            public void onFailure(Exception e) {
                Exception cause;
                RepositoryException repositoryException;
                Throwable throwable;
                logger.log(MasterService.isPublishFailureException((Exception)e) || e instanceof RepositoryException && (throwable = (repositoryException = (RepositoryException)e).getCause()) instanceof Exception && MasterService.isPublishFailureException((Exception)(cause = (Exception)throwable)) ? Level.DEBUG : Level.WARN, "failed to start cleanup of dangling multipart uploads", (Throwable)e);
            }
        }, (Releasable)refs.acquire()));
    }

    private static /* synthetic */ Object lambda$getRegister$24(String key) {
        return Strings.format((String)"[%s]: getRegister failed", (Object[])new Object[]{key});
    }

    private static /* synthetic */ S3Object lambda$getRegister$23(AmazonS3Reference clientReference, GetObjectRequest getObjectRequest) {
        return clientReference.client().getObject(getObjectRequest);
    }

    private class CompareAndExchangeOperation {
        private final OperationPurpose purpose;
        private final AmazonS3 client;
        private final String bucket;
        private final String rawKey;
        private final String blobKey;
        private final ThreadPool threadPool;

        CompareAndExchangeOperation(OperationPurpose purpose, AmazonS3 client, String bucket, String key, ThreadPool threadPool) {
            this.purpose = purpose;
            this.client = client;
            this.bucket = bucket;
            this.rawKey = key;
            this.blobKey = S3BlobContainer.this.buildKey(key);
            this.threadPool = threadPool;
        }

        void run(BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) throws Exception {
            BlobContainerUtils.ensureValidRegisterContent((BytesReference)updated);
            if (this.hasPreexistingUploads()) {
                listener.onResponse((Object)OptionalBytesReference.MISSING);
                return;
            }
            String uploadId = this.initiateMultipartUpload();
            logger.trace("[{}] initiated upload [{}]", (Object)this.blobKey, (Object)uploadId);
            PartETag partETag = this.uploadPart(updated, uploadId);
            logger.trace("[{}] uploaded update to [{}]", (Object)this.blobKey, (Object)uploadId);
            List<MultipartUpload> currentUploads = this.listMultipartUploads();
            this.logUploads("uploads before current", currentUploads);
            int uploadIndex = this.getUploadIndex(uploadId, currentUploads);
            logger.trace("[{}] upload [{}] has index [{}]", (Object)this.blobKey, (Object)uploadId, (Object)uploadIndex);
            if (uploadIndex < 0) {
                listener.onResponse((Object)OptionalBytesReference.MISSING);
                return;
            }
            SubscribableListener.newForked(l -> this.ensureOtherUploadsComplete(uploadId, uploadIndex, currentUploads, (ActionListener<Void>)l)).andThen(l -> S3BlobContainer.this.getRegister(this.purpose, this.rawKey, (ActionListener<OptionalBytesReference>)l)).andThenApply(currentValue -> {
                if (currentValue.isPresent() && currentValue.bytesReference().equals(expected)) {
                    logger.trace("[{}] completing upload [{}]", (Object)this.blobKey, (Object)uploadId);
                    this.completeMultipartUpload(uploadId, partETag);
                } else {
                    logger.trace("[{}] aborting upload [{}]", (Object)this.blobKey, (Object)uploadId);
                    this.safeAbortMultipartUpload(uploadId);
                }
                return currentValue;
            }).addListener(listener.delegateResponse((l, e) -> {
                logger.trace(() -> Strings.format((String)"[%s] aborting upload [%s] on exception", (Object[])new Object[]{this.blobKey, uploadId}), (Throwable)e);
                this.safeAbortMultipartUpload(uploadId);
                l.onFailure(e);
            }));
        }

        private boolean hasPreexistingUploads() {
            List<MultipartUpload> uploads = this.listMultipartUploads();
            this.logUploads("preexisting uploads", uploads);
            if (uploads.isEmpty()) {
                logger.trace("[{}] no preexisting uploads", (Object)this.blobKey);
                return false;
            }
            Date expiryDate = Date.from(Instant.ofEpochMilli(S3BlobContainer.this.blobStore.getThreadPool().absoluteTimeInMillis() - S3BlobContainer.this.blobStore.getCompareAndExchangeTimeToLive().millis()));
            if (uploads.stream().anyMatch(upload -> upload.getInitiated().after(expiryDate))) {
                logger.trace("[{}] fresh preexisting uploads vs {}", (Object)this.blobKey, (Object)expiryDate);
                return true;
            }
            for (MultipartUpload upload2 : uploads) {
                logger.warn("cleaning up stale compare-and-swap upload [{}] initiated at [{}]", (Object)upload2.getUploadId(), (Object)upload2.getInitiated());
                this.safeAbortMultipartUpload(upload2.getUploadId());
            }
            logger.trace("[{}] stale preexisting uploads vs {}", (Object)this.blobKey, (Object)expiryDate);
            return false;
        }

        private void logUploads(String description, List<MultipartUpload> uploads) {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] {}: [{}]", (Object)this.blobKey, (Object)description, (Object)uploads.stream().map(multipartUpload -> multipartUpload.getUploadId() + ": " + String.valueOf(multipartUpload.getInitiated())).collect(Collectors.joining(",")));
            }
        }

        private List<MultipartUpload> listMultipartUploads() {
            ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(this.bucket);
            listRequest.setPrefix(this.blobKey);
            S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)listRequest, S3BlobContainer.this.blobStore, S3BlobStore.Operation.LIST_OBJECTS, this.purpose);
            try {
                return SocketAccess.doPrivileged(() -> this.client.listMultipartUploads(listRequest)).getMultipartUploads();
            }
            catch (AmazonS3Exception e) {
                if (e.getStatusCode() == 404) {
                    return List.of();
                }
                throw e;
            }
        }

        private String initiateMultipartUpload() {
            InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(this.bucket, this.blobKey);
            S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)initiateRequest, S3BlobContainer.this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, this.purpose);
            return SocketAccess.doPrivileged(() -> this.client.initiateMultipartUpload(initiateRequest)).getUploadId();
        }

        private PartETag uploadPart(BytesReference updated, String uploadId) throws IOException {
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(this.bucket);
            uploadPartRequest.setKey(this.blobKey);
            uploadPartRequest.setUploadId(uploadId);
            uploadPartRequest.setPartNumber(1);
            uploadPartRequest.setLastPart(true);
            uploadPartRequest.setInputStream((InputStream)updated.streamInput());
            uploadPartRequest.setPartSize((long)updated.length());
            S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)uploadPartRequest, S3BlobContainer.this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, this.purpose);
            return SocketAccess.doPrivileged(() -> this.client.uploadPart(uploadPartRequest)).getPartETag();
        }

        private int getUploadIndex(String targetUploadId, List<MultipartUpload> multipartUploads) {
            int uploadIndex = 0;
            boolean found = false;
            for (MultipartUpload multipartUpload : multipartUploads) {
                String observedUploadId = multipartUpload.getUploadId();
                if (observedUploadId.equals(targetUploadId)) {
                    long expectedAgeRangeMillis;
                    long currentTimeMillis = S3BlobContainer.this.blobStore.getThreadPool().absoluteTimeInMillis();
                    long ageMillis = currentTimeMillis - multipartUpload.getInitiated().toInstant().toEpochMilli();
                    if (ageMillis < -(expectedAgeRangeMillis = S3BlobContainer.this.blobStore.getCompareAndExchangeTimeToLive().millis()) || ageMillis > expectedAgeRangeMillis) {
                        logger.warn("compare-and-exchange of blob [{}:{}] was initiated at [{}={}] which deviates from local node epoch time [{}] by more than the warn threshold of [{}ms]", (Object)this.bucket, (Object)this.blobKey, (Object)multipartUpload.getInitiated(), (Object)multipartUpload.getInitiated().toInstant().toEpochMilli(), (Object)currentTimeMillis, (Object)expectedAgeRangeMillis);
                    }
                    found = true;
                    continue;
                }
                if (observedUploadId.compareTo(targetUploadId) >= 0) continue;
                ++uploadIndex;
            }
            return found ? uploadIndex : -1;
        }

        private void ensureOtherUploadsComplete(String uploadId, int uploadIndex, List<MultipartUpload> currentUploads, ActionListener<Void> listener) {
            if (uploadIndex > 0) {
                this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueMillis((long)((long)uploadIndex * S3BlobContainer.this.blobStore.getCompareAndExchangeAntiContentionDelay().millis() + (long)Randomness.get().nextInt(50))), S3BlobContainer.this.blobStore.getSnapshotExecutor(), (Runnable)ActionRunnable.wrap(listener, l -> this.cancelOtherUploads(uploadId, currentUploads, (ActionListener<Void>)l)));
            } else {
                this.cancelOtherUploads(uploadId, currentUploads, listener);
            }
        }

        private void cancelOtherUploads(String uploadId, List<MultipartUpload> currentUploads, ActionListener<Void> listener) {
            logger.trace("[{}] upload [{}] cancelling other uploads", (Object)this.blobKey, (Object)uploadId);
            Executor executor = S3BlobContainer.this.blobStore.getSnapshotExecutor();
            try (RefCountingListener listeners = new RefCountingListener(listener);){
                for (MultipartUpload currentUpload : currentUploads) {
                    String currentUploadId = currentUpload.getUploadId();
                    if (uploadId.equals(currentUploadId)) continue;
                    executor.execute((Runnable)ActionRunnable.run((ActionListener)listeners.acquire(), () -> this.abortMultipartUploadIfExists(currentUploadId)));
                }
            }
        }

        private void safeAbortMultipartUpload(String uploadId) {
            try {
                this.abortMultipartUploadIfExists(uploadId);
            }
            catch (Exception e) {
                logger.error("unexpected error cleaning up upload [" + uploadId + "] of [" + this.blobKey + "]", (Throwable)e);
            }
        }

        private void abortMultipartUploadIfExists(String uploadId) {
            block2: {
                try {
                    AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(this.bucket, this.blobKey, uploadId);
                    S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)request, S3BlobContainer.this.blobStore, S3BlobStore.Operation.ABORT_MULTIPART_OBJECT, this.purpose);
                    SocketAccess.doPrivilegedVoid(() -> this.client.abortMultipartUpload(request));
                }
                catch (AmazonS3Exception e) {
                    if (e.getStatusCode() == 404) break block2;
                    throw e;
                }
            }
        }

        private void completeMultipartUpload(String uploadId, PartETag partETag) {
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucket, this.blobKey, uploadId, List.of(partETag));
            S3BlobStore.configureRequestForMetrics((AmazonWebServiceRequest)completeMultipartUploadRequest, S3BlobContainer.this.blobStore, S3BlobStore.Operation.PUT_MULTIPART_OBJECT, this.purpose);
            SocketAccess.doPrivilegedVoid(() -> this.client.completeMultipartUpload(completeMultipartUploadRequest));
        }
    }
}

