/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractTransportSetUpgradeModeAction;
import org.elasticsearch.xpack.core.action.SetUpgradeModeActionRequest;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMetadata;

public class TransportSetTransformUpgradeModeAction
extends AbstractTransportSetUpgradeModeAction {
    private static final Logger logger = LogManager.getLogger(TransportSetTransformUpgradeModeAction.class);
    private final PersistentTasksClusterService persistentTasksClusterService;
    private final PersistentTasksService persistentTasksService;
    private final OriginSettingClient client;

    @Inject
    public TransportSetTransformUpgradeModeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksClusterService persistentTasksClusterService, PersistentTasksService persistentTasksService, Client client) {
        super("cluster:admin/transform/upgrade_mode", "transform", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.persistentTasksClusterService = persistentTasksClusterService;
        this.persistentTasksService = persistentTasksService;
        this.client = new OriginSettingClient(client, "transform");
    }

    protected String featureName() {
        return "transform-set-upgrade-mode";
    }

    protected boolean upgradeMode(ClusterState state) {
        return TransformMetadata.upgradeMode((ClusterState)state);
    }

    protected ClusterState createUpdatedState(SetUpgradeModeActionRequest request, ClusterState state) {
        TransformMetadata updatedTransformMetadata = TransformMetadata.getTransformMetadata((ClusterState)state).builder().upgradeMode(request.enabled()).build();
        Metadata updatedClusterMetadata = state.metadata().copyAndUpdate(b -> b.putCustom("transform", (Metadata.Custom)updatedTransformMetadata));
        return state.copyAndUpdate(b -> b.metadata(updatedClusterMetadata));
    }

    protected void upgradeModeSuccessfullyChanged(Task task, SetUpgradeModeActionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetadata tasksCustomMetadata = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        if (tasksCustomMetadata == null || tasksCustomMetadata.tasks().isEmpty() || tasksCustomMetadata.tasks().stream().noneMatch(this::isTransformTask)) {
            logger.info("No tasks to worry about after state update");
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        if (request.enabled()) {
            this.stopTransforms(request, state, listener);
        } else {
            this.waitForTransformsToRestart(request, listener);
        }
    }

    private void stopTransforms(SetUpgradeModeActionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.unassignTransforms(state, (ActionListener<Void>)listener.delegateFailureAndWrap((l, r) -> this.waitForTransformsToStop(request, (ActionListener<AcknowledgedResponse>)l)));
    }

    private void unassignTransforms(ClusterState state, ActionListener<Void> listener) {
        PersistentTasksCustomMetadata tasksCustomMetadata = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        List<PersistentTasksCustomMetadata.PersistentTask> transformTasks = tasksCustomMetadata.tasks().stream().filter(this::isTransformTask).sorted(Comparator.comparing(PersistentTasksCustomMetadata.PersistentTask::getTaskName)).toList();
        logger.info("Un-assigning persistent tasks : {}", new Supplier[]{() -> transformTasks.stream().map(PersistentTasksCustomMetadata.PersistentTask::getId).collect(Collectors.joining(", ", "[ ", " ]"))});
        SubscribableListener chainListener = SubscribableListener.newSucceeded(null);
        for (PersistentTasksCustomMetadata.PersistentTask task : transformTasks) {
            chainListener = chainListener.andThen(this.executor, this.threadPool.getThreadContext(), (l, unused) -> this.persistentTasksClusterService.unassignPersistentTask(task.getId(), task.getAllocationId(), TransformField.AWAITING_UPGRADE.getExplanation(), l.delegateResponse((ll, ex) -> {
                if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)ex) instanceof ResourceNotFoundException) {
                    ll.onResponse(null);
                } else {
                    ll.onFailure(ex);
                }
            })));
        }
        chainListener.addListener(listener.delegateFailure((l, ignored) -> l.onResponse(null)), this.executor, this.threadPool.getThreadContext());
    }

    private void waitForTransformsToStop(SetUpgradeModeActionRequest request, ActionListener<AcknowledgedResponse> listener) {
        ((ListTasksRequestBuilder)((ListTasksRequestBuilder)this.client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"data_frame/transforms[c]"})).setWaitForCompletion(true).setTimeout(request.ackTimeout())).execute(listener.delegateFailureAndWrap((l, r) -> {
            try {
                logger.info("Waited for tasks to be unassigned");
                if (!r.getNodeFailures().isEmpty()) {
                    logger.info("There were node failures waiting for tasks", (Throwable)r.getNodeFailures().get(0));
                }
                ExceptionsHelper.rethrowAndSuppress((List)r.getNodeFailures());
                l.onResponse((Object)AcknowledgedResponse.TRUE);
            }
            catch (ElasticsearchException ex) {
                logger.info("Caught node failures waiting for tasks to be unassigned", (Throwable)ex);
                l.onFailure((Exception)((Object)ex));
            }
        }));
    }

    private boolean isTransformTask(PersistentTasksCustomMetadata.PersistentTask<?> task) {
        return "data_frame/transforms".equals(task.getTaskName());
    }

    private void waitForTransformsToRestart(SetUpgradeModeActionRequest request, ActionListener<AcknowledgedResponse> listener) {
        logger.info("Disabling upgrade mode for Transforms, must wait for tasks to not have AWAITING_UPGRADE assignment");
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> persistentTasksCustomMetadata.tasks().stream().noneMatch(t -> this.isTransformTask((PersistentTasksCustomMetadata.PersistentTask<?>)t) && t.getAssignment().equals((Object)TransformField.AWAITING_UPGRADE)), request.ackTimeout(), listener.delegateFailureAndWrap((d, r) -> d.onResponse((Object)AcknowledgedResponse.TRUE)));
    }
}

