/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.filtering;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;

public class FilteringAdvancedSnippet
implements Writeable,
ToXContentObject {
    @Nullable
    private final Instant advancedSnippetCreatedAt;
    @Nullable
    private final Instant advancedSnippetUpdatedAt;
    private final Object advancedSnippetValue;
    private static final ParseField CREATED_AT_FIELD = new ParseField("created_at", new String[0]);
    private static final ParseField UPDATED_AT_FIELD = new ParseField("updated_at", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<FilteringAdvancedSnippet, Void> PARSER = new ConstructingObjectParser("connector_filtering_advanced_snippet", true, args -> new Builder().setAdvancedSnippetCreatedAt((Instant)args[0]).setAdvancedSnippetUpdatedAt((Instant)args[1]).setAdvancedSnippetValue(args[2]).build());

    private FilteringAdvancedSnippet(Instant advancedSnippetCreatedAt, Instant advancedSnippetUpdatedAt, Object advancedSnippetValue) {
        this.advancedSnippetCreatedAt = advancedSnippetCreatedAt;
        this.advancedSnippetUpdatedAt = advancedSnippetUpdatedAt;
        this.advancedSnippetValue = advancedSnippetValue;
    }

    public FilteringAdvancedSnippet(StreamInput in) throws IOException {
        this.advancedSnippetCreatedAt = in.readOptionalInstant();
        this.advancedSnippetUpdatedAt = in.readOptionalInstant();
        this.advancedSnippetValue = in.readGenericValue();
    }

    public Instant getAdvancedSnippetCreatedAt() {
        return this.advancedSnippetCreatedAt;
    }

    public Instant getAdvancedSnippetUpdatedAt() {
        return this.advancedSnippetUpdatedAt;
    }

    public Object getAdvancedSnippetValue() {
        return this.advancedSnippetValue;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CREATED_AT_FIELD.getPreferredName(), (Object)this.advancedSnippetCreatedAt);
        builder.field(UPDATED_AT_FIELD.getPreferredName(), (Object)this.advancedSnippetUpdatedAt);
        builder.field(VALUE_FIELD.getPreferredName(), this.advancedSnippetValue);
        builder.endObject();
        return builder;
    }

    public static FilteringAdvancedSnippet fromXContent(XContentParser parser) throws IOException {
        return (FilteringAdvancedSnippet)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInstant(this.advancedSnippetCreatedAt);
        out.writeOptionalInstant(this.advancedSnippetUpdatedAt);
        out.writeGenericValue(this.advancedSnippetValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringAdvancedSnippet that = (FilteringAdvancedSnippet)o;
        return Objects.equals(this.advancedSnippetCreatedAt, that.advancedSnippetCreatedAt) && Objects.equals(this.advancedSnippetUpdatedAt, that.advancedSnippetUpdatedAt) && Objects.equals(this.advancedSnippetValue, that.advancedSnippetValue);
    }

    public int hashCode() {
        return Objects.hash(this.advancedSnippetCreatedAt, this.advancedSnippetUpdatedAt, this.advancedSnippetValue);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseInstant(p, CREATED_AT_FIELD.getPreferredName()), CREATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseInstant(p, UPDATED_AT_FIELD.getPreferredName()), UPDATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.START_ARRAY) {
                return p.list();
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                return p.map();
            }
            throw new XContentParseException("Unsupported token [" + String.valueOf(p.currentToken()) + "]. Expected an array or an object.");
        }, VALUE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public static class Builder {
        private Instant advancedSnippetCreatedAt;
        private Instant advancedSnippetUpdatedAt;
        private Object advancedSnippetValue;
        private final Instant currentTimestamp = Instant.now();

        public Builder setAdvancedSnippetCreatedAt(Instant advancedSnippetCreatedAt) {
            this.advancedSnippetCreatedAt = Objects.requireNonNullElse(advancedSnippetCreatedAt, this.currentTimestamp);
            return this;
        }

        public Builder setAdvancedSnippetUpdatedAt(Instant advancedSnippetUpdatedAt) {
            this.advancedSnippetUpdatedAt = Objects.requireNonNullElse(advancedSnippetUpdatedAt, this.currentTimestamp);
            return this;
        }

        public Builder setAdvancedSnippetValue(Object advancedSnippetValue) {
            this.advancedSnippetValue = advancedSnippetValue;
            return this;
        }

        public FilteringAdvancedSnippet build() {
            return new FilteringAdvancedSnippet(this.advancedSnippetCreatedAt, this.advancedSnippetUpdatedAt, this.advancedSnippetValue);
        }
    }
}

