/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal.geo;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.ConstantNamedWriteable;

public class GeoShape
implements ToXContentFragment,
ConstantNamedWriteable {
    public static final String NAME = "geo";
    private final Geometry shape;
    private static final GeometryParser GEOMETRY_PARSER = new GeometryParser(true, true, true);

    public GeoShape(double lon, double lat) {
        this.shape = new Point(lon, lat);
    }

    public GeoShape(Object value) throws IOException {
        try {
            this.shape = GeoShape.parse(value);
        }
        catch (ParseException ex) {
            throw new InvalidArgumentException("Cannot parse [" + String.valueOf(value) + "] as a geo_shape or shape value", new Object[]{ex});
        }
    }

    public GeoShape(StreamInput in) throws IOException {
        String value = in.readString();
        try {
            this.shape = GeoShape.parse(value);
        }
        catch (ParseException ex) {
            throw new InvalidArgumentException("Cannot parse [" + value + "] as a geo_shape or shape value", new Object[]{ex});
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(WellKnownText.toWKT((Geometry)this.shape));
    }

    public String toString() {
        return WellKnownText.toWKT((Geometry)this.shape);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(WellKnownText.toWKT((Geometry)this.shape));
    }

    public Geometry toGeometry() {
        return this.shape;
    }

    public Point firstPoint() {
        return (Point)this.shape.visit((GeometryVisitor)new GeometryVisitor<Point, RuntimeException>(){

            public Point visit(Circle circle) {
                return new Point(circle.getX(), circle.getY(), circle.hasZ() ? circle.getZ() : Double.NaN);
            }

            public Point visit(GeometryCollection<?> collection) {
                if (collection.size() > 0) {
                    return (Point)collection.get(0).visit((GeometryVisitor)this);
                }
                return null;
            }

            public Point visit(Line line) {
                if (line.length() > 0) {
                    return new Point(line.getX(0), line.getY(0), line.hasZ() ? line.getZ(0) : Double.NaN);
                }
                return null;
            }

            public Point visit(LinearRing ring) {
                return this.visit((Line)ring);
            }

            public Point visit(MultiLine multiLine) {
                return this.visit((GeometryCollection<?>)multiLine);
            }

            public Point visit(MultiPoint multiPoint) {
                return this.visit((GeometryCollection<?>)multiPoint);
            }

            public Point visit(MultiPolygon multiPolygon) {
                return this.visit((GeometryCollection<?>)multiPolygon);
            }

            public Point visit(Point point) {
                return point;
            }

            public Point visit(Polygon polygon) {
                return this.visit(polygon.getPolygon());
            }

            public Point visit(Rectangle rectangle) {
                return new Point(rectangle.getMinX(), rectangle.getMinY(), rectangle.getMinZ());
            }
        });
    }

    public Double getX() {
        Point firstPoint = this.firstPoint();
        return firstPoint != null ? Double.valueOf(firstPoint.getX()) : null;
    }

    public Double getY() {
        Point firstPoint = this.firstPoint();
        return firstPoint != null ? Double.valueOf(firstPoint.getY()) : null;
    }

    public Double getZ() {
        Point firstPoint = this.firstPoint();
        return firstPoint != null && firstPoint.hasZ() ? Double.valueOf(firstPoint.getZ()) : null;
    }

    public String getGeometryType() {
        return this.toGeometry().type().name();
    }

    public static double distance(GeoShape shape1, GeoShape shape2) {
        if (!(shape1.shape instanceof Point)) {
            throw new QlIllegalArgumentException("distance calculation is only supported for points; received [{}]", new Object[]{shape1});
        }
        if (!(shape2.shape instanceof Point)) {
            throw new QlIllegalArgumentException("distance calculation is only supported for points; received [{}]", new Object[]{shape2});
        }
        double srcLat = ((Point)shape1.shape).getY();
        double srcLon = ((Point)shape1.shape).getX();
        double dstLat = ((Point)shape2.shape).getY();
        double dstLon = ((Point)shape2.shape).getX();
        return GeoUtils.arcDistance((double)srcLat, (double)srcLon, (double)dstLat, (double)dstLon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoShape geoShape = (GeoShape)o;
        return this.shape.equals(geoShape.shape);
    }

    public int hashCode() {
        return Objects.hash(this.shape);
    }

    public String getWriteableName() {
        return NAME;
    }

    private static Geometry parse(Object value) throws IOException, ParseException {
        XContentBuilder content = JsonXContent.contentBuilder();
        content.startObject();
        content.field("value", value);
        content.endObject();
        try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)BytesReference.bytes((XContentBuilder)content), (XContentType)XContentType.JSON);){
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            Geometry geometry = GEOMETRY_PARSER.parse(parser);
            return geometry;
        }
    }
}

