/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.SuppressForbidden;

public class IndexInputStats {
    static final ByteSizeValue SEEKING_THRESHOLD = new ByteSizeValue(8L, ByteSizeUnit.MB);
    private final long numFiles;
    private final long totalSize;
    private final long minSize;
    private final long maxSize;
    private final long seekingThreshold;
    private final LongSupplier currentTimeNanos;
    private final LongAdder opened = new LongAdder();
    private final LongAdder closed = new LongAdder();
    private final Counter forwardSmallSeeks = new Counter();
    private final Counter backwardSmallSeeks = new Counter();
    private final Counter forwardLargeSeeks = new Counter();
    private final Counter backwardLargeSeeks = new Counter();
    private final Counter contiguousReads = new Counter();
    private final Counter nonContiguousReads = new Counter();
    private final TimedCounter directBytesRead = new TimedCounter();
    private final TimedCounter optimizedBytesRead = new TimedCounter();
    private final Counter cachedBytesRead = new Counter();
    private final Counter indexCacheBytesRead = new Counter();
    private final TimedCounter cachedBytesWritten = new TimedCounter();
    private final Counter blobStoreBytesRequested = new Counter();
    private final AtomicLong currentIndexCacheFills = new AtomicLong();
    private final Counter luceneBytesRead = new Counter();

    public IndexInputStats(long numFiles, long totalSize, long minSize, long maxSize, LongSupplier currentTimeNanos) {
        this(numFiles, totalSize, minSize, maxSize, SEEKING_THRESHOLD.getBytes(), currentTimeNanos);
    }

    public IndexInputStats(long numFiles, long totalSize, long minSize, long maxSize, long seekingThreshold, LongSupplier currentTimeNanos) {
        this.numFiles = numFiles;
        this.totalSize = totalSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.seekingThreshold = seekingThreshold;
        this.currentTimeNanos = currentTimeNanos;
    }

    public long currentTimeNanos() {
        return this.currentTimeNanos.getAsLong();
    }

    public void incrementOpenCount() {
        this.opened.increment();
    }

    public void incrementCloseCount() {
        this.closed.increment();
    }

    public void addCachedBytesRead(int bytesRead) {
        this.cachedBytesRead.add(bytesRead);
    }

    public void addIndexCacheBytesRead(int bytesRead) {
        this.indexCacheBytesRead.add(bytesRead);
    }

    public void addCachedBytesWritten(long bytesWritten, long nanoseconds) {
        this.cachedBytesWritten.add(bytesWritten, nanoseconds);
    }

    public void addDirectBytesRead(int bytesRead, long nanoseconds) {
        this.directBytesRead.add(bytesRead, nanoseconds);
    }

    public void addOptimizedBytesRead(int bytesRead, long nanoseconds) {
        this.optimizedBytesRead.add(bytesRead, nanoseconds);
    }

    public void incrementBytesRead(long previousPosition, long currentPosition, int bytesRead) {
        LongConsumer incBytesRead = previousPosition == currentPosition ? this.contiguousReads::add : this.nonContiguousReads::add;
        incBytesRead.accept(bytesRead);
    }

    public void incrementSeeks(long currentPosition, long newPosition) {
        long delta = newPosition - currentPosition;
        if (delta == 0L) {
            return;
        }
        boolean isLarge = this.isLargeSeek(delta);
        if (delta > 0L) {
            if (isLarge) {
                this.forwardLargeSeeks.add(delta);
            } else {
                this.forwardSmallSeeks.add(delta);
            }
        } else if (isLarge) {
            this.backwardLargeSeeks.add(-delta);
        } else {
            this.backwardSmallSeeks.add(-delta);
        }
    }

    public void addBlobStoreBytesRequested(long bytesRequested) {
        this.blobStoreBytesRequested.add(bytesRequested);
    }

    public Releasable addIndexCacheFill() {
        long openValue = this.currentIndexCacheFills.incrementAndGet();
        assert (openValue > 0L) : openValue;
        return () -> {
            long closeValue = this.currentIndexCacheFills.decrementAndGet();
            assert (closeValue >= 0L) : closeValue;
        };
    }

    public void addLuceneBytesRead(int bytesRead) {
        this.luceneBytesRead.add(bytesRead);
    }

    public long getNumFiles() {
        return this.numFiles;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public LongAdder getOpened() {
        return this.opened;
    }

    public LongAdder getClosed() {
        return this.closed;
    }

    public Counter getForwardSmallSeeks() {
        return this.forwardSmallSeeks;
    }

    public Counter getBackwardSmallSeeks() {
        return this.backwardSmallSeeks;
    }

    public Counter getForwardLargeSeeks() {
        return this.forwardLargeSeeks;
    }

    public Counter getBackwardLargeSeeks() {
        return this.backwardLargeSeeks;
    }

    public Counter getContiguousReads() {
        return this.contiguousReads;
    }

    public Counter getNonContiguousReads() {
        return this.nonContiguousReads;
    }

    public TimedCounter getDirectBytesRead() {
        return this.directBytesRead;
    }

    public TimedCounter getOptimizedBytesRead() {
        return this.optimizedBytesRead;
    }

    public Counter getCachedBytesRead() {
        return this.cachedBytesRead;
    }

    public Counter getIndexCacheBytesRead() {
        return this.indexCacheBytesRead;
    }

    public TimedCounter getCachedBytesWritten() {
        return this.cachedBytesWritten;
    }

    public Counter getBlobStoreBytesRequested() {
        return this.blobStoreBytesRequested;
    }

    public Counter getLuceneBytesRead() {
        return this.luceneBytesRead;
    }

    @SuppressForbidden(reason="Handles Long.MIN_VALUE before using Math.abs()")
    public boolean isLargeSeek(long delta) {
        return delta != Long.MIN_VALUE && Math.abs(delta) > this.seekingThreshold;
    }

    public long getCurrentIndexCacheFills() {
        return this.currentIndexCacheFills.get();
    }

    public static class Counter {
        private final LongAdder count = new LongAdder();
        private final LongAdder total = new LongAdder();
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

        void add(long value) {
            this.count.increment();
            this.total.add(value);
            this.min.accumulateAndGet(value, Math::min);
            this.max.accumulateAndGet(value, Math::max);
        }

        public long count() {
            return this.count.sum();
        }

        public long total() {
            return this.total.sum();
        }

        public long min() {
            long value = this.min.get();
            if (value == Long.MAX_VALUE) {
                return 0L;
            }
            return value;
        }

        public long max() {
            long value = this.max.get();
            if (value == Long.MIN_VALUE) {
                return 0L;
            }
            return value;
        }
    }

    public static class TimedCounter
    extends Counter {
        private final LongAdder totalNanoseconds = new LongAdder();

        void add(long value, long nanoseconds) {
            super.add(value);
            this.totalNanoseconds.add(nanoseconds);
        }

        public long totalNanoseconds() {
            return this.totalNanoseconds.sum();
        }
    }
}

