/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.FloatBigArrayBlock;
import org.elasticsearch.compute.data.FloatBigArrayVector;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;

final class FloatBlockBuilder
extends AbstractBlockBuilder
implements FloatBlock.Builder {
    private float[] values;

    FloatBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + initialSize * this.elementSize());
        this.values = new float[initialSize];
    }

    @Override
    public FloatBlockBuilder appendFloat(float value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 4;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public FloatBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public FloatBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public FloatBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public FloatBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((FloatBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public FloatBlockBuilder copyFrom(FloatBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        FloatVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(FloatBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.copyFrom(block, p);
        }
    }

    private void copyFromVector(FloatVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendFloat(vector.getFloat(p));
        }
    }

    @Override
    public FloatBlockBuilder copyFrom(FloatBlock block, int position) {
        if (block.isNull(position)) {
            this.appendNull();
            return this;
        }
        int count = block.getValueCount(position);
        int i = block.getFirstValueIndex(position);
        if (count == 1) {
            this.appendFloat(block.getFloat(i++));
            return this;
        }
        this.beginPositionEntry();
        for (int v = 0; v < count; ++v) {
            this.appendFloat(block.getFloat(i++));
        }
        this.endPositionEntry();
        return this;
    }

    @Override
    public FloatBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    private FloatBlock buildBigArraysBlock() {
        FloatArray array = this.blockFactory.bigArrays().newFloatArray((long)this.valueCount, false);
        for (int i = 0; i < this.valueCount; ++i) {
            array.set((long)i, this.values[i]);
        }
        FloatBlock theBlock = this.isDense() && this.singleValued() ? new FloatBigArrayVector(array, this.positionCount, this.blockFactory).asBlock() : new FloatBigArrayBlock(array, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.blockFactory);
        this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes - array.ramBytesUsed());
        return theBlock;
    }

    @Override
    public FloatBlock build() {
        try {
            this.finish();
            FloatBlock theBlock = this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1 ? this.blockFactory.newConstantFloatBlockWith(this.values[0], 1, this.estimatedBytes) : (this.estimatedBytes > this.blockFactory.maxPrimitiveArrayBytes() ? this.buildBigArraysBlock() : (this.isDense() && this.singleValued() ? this.blockFactory.newFloatArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newFloatArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes)));
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

