/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneMinMaxOperator;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.search.MultiValueMode;

public final class LuceneMinFactory
extends LuceneOperator.Factory {
    private final String fieldName;
    private final NumberType numberType;

    public LuceneMinFactory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, String fieldName, NumberType numberType, int limit) {
        super(contexts, queryFunction, dataPartitioning, taskConcurrency, limit, ScoreMode.COMPLETE_NO_SCORES);
        this.fieldName = fieldName;
        this.numberType = numberType;
    }

    @Override
    public SourceOperator get(DriverContext driverContext) {
        return new LuceneMinMaxOperator(driverContext.blockFactory(), this.sliceQueue, this.fieldName, this.numberType, this.limit, Long.MAX_VALUE);
    }

    @Override
    public String describe() {
        return "LuceneMinOperator[type = " + this.numberType.name() + ", dataPartitioning = " + String.valueOf((Object)this.dataPartitioning) + ", fieldName = " + this.fieldName + ", limit = " + this.limit + "]";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NumberType implements LuceneMinMaxOperator.NumberType
    {
        INTEGER{

            @Override
            public Block buildResult(BlockFactory blockFactory, long result, int pageSize) {
                return blockFactory.newConstantIntBlockWith(Math.toIntExact(result), pageSize);
            }

            @Override
            public Block buildEmptyResult(BlockFactory blockFactory, int pageSize) {
                return blockFactory.newConstantIntBlockWith(Integer.MAX_VALUE, pageSize);
            }

            @Override
            long bytesToLong(byte[] bytes) {
                return NumericUtils.sortableBytesToInt((byte[])bytes, (int)0);
            }
        }
        ,
        FLOAT{

            @Override
            public Block buildResult(BlockFactory blockFactory, long result, int pageSize) {
                return blockFactory.newConstantFloatBlockWith(NumericUtils.sortableIntToFloat((int)Math.toIntExact(result)), pageSize);
            }

            @Override
            public Block buildEmptyResult(BlockFactory blockFactory, int pageSize) {
                return blockFactory.newConstantFloatBlockWith(Float.POSITIVE_INFINITY, pageSize);
            }

            @Override
            long bytesToLong(byte[] bytes) {
                return NumericUtils.sortableBytesToInt((byte[])bytes, (int)0);
            }
        }
        ,
        LONG{

            @Override
            public Block buildResult(BlockFactory blockFactory, long result, int pageSize) {
                return blockFactory.newConstantLongBlockWith(result, pageSize);
            }

            @Override
            public Block buildEmptyResult(BlockFactory blockFactory, int pageSize) {
                return blockFactory.newConstantLongBlockWith(Long.MAX_VALUE, pageSize);
            }

            @Override
            long bytesToLong(byte[] bytes) {
                return NumericUtils.sortableBytesToLong((byte[])bytes, (int)0);
            }
        }
        ,
        DOUBLE{

            @Override
            public Block buildResult(BlockFactory blockFactory, long result, int pageSize) {
                return blockFactory.newConstantDoubleBlockWith(NumericUtils.sortableLongToDouble((long)result), pageSize);
            }

            @Override
            public Block buildEmptyResult(BlockFactory blockFactory, int pageSize) {
                return blockFactory.newConstantDoubleBlockWith(Double.POSITIVE_INFINITY, pageSize);
            }

            @Override
            long bytesToLong(byte[] bytes) {
                return NumericUtils.sortableBytesToLong((byte[])bytes, (int)0);
            }
        };


        @Override
        public final NumericDocValues multiValueMode(SortedNumericDocValues sortedNumericDocValues) {
            return MultiValueMode.MIN.select(sortedNumericDocValues);
        }

        @Override
        public final long fromPointValues(PointValues pointValues) throws IOException {
            return this.bytesToLong(pointValues.getMinPackedValue());
        }

        @Override
        public final long evaluate(long value1, long value2) {
            return Math.min(value1, value2);
        }

        abstract long bytesToLong(byte[] var1);
    }
}

