/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;

public class ProjectOperator
extends AbstractPageMappingOperator {
    private final int[] projection;

    public ProjectOperator(List<Integer> projection) {
        this.projection = projection.stream().mapToInt(Integer::intValue).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page process(Page page) {
        int blockCount = page.getBlockCount();
        if (blockCount == 0) {
            return page;
        }
        try {
            Page page2 = page.projectBlocks(this.projection);
            return page2;
        }
        finally {
            page.releaseBlocks();
        }
    }

    @Override
    public String toString() {
        if (this.projection.length < 10) {
            return "ProjectOperator[projection = " + Arrays.toString(this.projection) + "]";
        }
        return "ProjectOperator[projection = [" + this.projection.length + " fields]]";
    }

    public record ProjectOperatorFactory(List<Integer> projection) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ProjectOperator(this.projection);
        }

        @Override
        public String describe() {
            if (this.projection.size() < 10) {
                return "ProjectOperator[projection = " + String.valueOf(this.projection) + "]";
            }
            return "ProjectOperator[projection = [" + this.projection.size() + " fields]]";
        }
    }
}

