/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.exchange.ExchangeRequest;
import org.elasticsearch.compute.operator.exchange.ExchangeResponse;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public final class ExchangeService
extends AbstractLifecycleComponent {
    public static final String EXCHANGE_ACTION_NAME = "internal:data/read/esql/exchange";
    public static final String EXCHANGE_ACTION_NAME_FOR_CCS = "cluster:internal:data/read/esql/exchange";
    private static final String OPEN_EXCHANGE_ACTION_NAME = "internal:data/read/esql/open_exchange";
    private static final String OPEN_EXCHANGE_ACTION_NAME_FOR_CCS = "cluster:internal:data/read/esql/open_exchange";
    public static final String INACTIVE_SINKS_INTERVAL_SETTING = "esql.exchange.sink_inactive_interval";
    public static final TimeValue INACTIVE_SINKS_INTERVAL_DEFAULT = TimeValue.timeValueMinutes((long)5L);
    private static final Logger LOGGER = LogManager.getLogger(ExchangeService.class);
    private final ThreadPool threadPool;
    private final Executor executor;
    private final BlockFactory blockFactory;
    private final Map<String, ExchangeSinkHandler> sinks = ConcurrentCollections.newConcurrentMap();
    private final Map<String, ExchangeSourceHandler> exchangeSources = ConcurrentCollections.newConcurrentMap();

    public ExchangeService(Settings settings, ThreadPool threadPool, String executorName, BlockFactory blockFactory) {
        this.threadPool = threadPool;
        this.executor = threadPool.executor(executorName);
        this.blockFactory = blockFactory;
        TimeValue inactiveInterval = settings.getAsTime(INACTIVE_SINKS_INTERVAL_SETTING, INACTIVE_SINKS_INTERVAL_DEFAULT);
        this.threadPool.scheduleWithFixedDelay((Runnable)((Object)new InactiveSinksReaper(LOGGER, threadPool, inactiveInterval)), TimeValue.timeValueMillis((long)Math.max(1L, inactiveInterval.millis() / 2L)), this.executor);
    }

    public void registerTransportHandler(TransportService transportService) {
        transportService.registerRequestHandler(EXCHANGE_ACTION_NAME, this.executor, ExchangeRequest::new, (TransportRequestHandler)new ExchangeTransportAction());
        transportService.registerRequestHandler(OPEN_EXCHANGE_ACTION_NAME, this.executor, OpenExchangeRequest::new, (TransportRequestHandler)new OpenExchangeRequestHandler());
        transportService.registerRequestHandler(EXCHANGE_ACTION_NAME_FOR_CCS, this.executor, ExchangeRequest::new, (TransportRequestHandler)new ExchangeTransportAction());
        transportService.registerRequestHandler(OPEN_EXCHANGE_ACTION_NAME_FOR_CCS, this.executor, OpenExchangeRequest::new, (TransportRequestHandler)new OpenExchangeRequestHandler());
    }

    public ExchangeSinkHandler createSinkHandler(String exchangeId, int maxBufferSize) {
        ExchangeSinkHandler sinkHandler = new ExchangeSinkHandler(this.blockFactory, maxBufferSize, this.threadPool.relativeTimeInMillisSupplier());
        if (this.sinks.putIfAbsent(exchangeId, sinkHandler) != null) {
            throw new IllegalStateException("sink exchanger for id [" + exchangeId + "] already exists");
        }
        return sinkHandler;
    }

    public ExchangeSinkHandler getSinkHandler(String exchangeId) {
        ExchangeSinkHandler sinkHandler = this.sinks.get(exchangeId);
        if (sinkHandler == null) {
            throw new ResourceNotFoundException("sink exchanger for id [{}] doesn't exist", new Object[]{exchangeId});
        }
        return sinkHandler;
    }

    public void finishSinkHandler(String exchangeId, @Nullable Exception failure) {
        ExchangeSinkHandler sinkHandler = this.sinks.remove(exchangeId);
        if (sinkHandler != null) {
            if (failure != null) {
                sinkHandler.onFailure(failure);
            }
            assert (sinkHandler.isFinished()) : "Exchange sink " + exchangeId + " wasn't finished yet";
        }
    }

    public static void openExchange(TransportService transportService, Transport.Connection connection, String sessionId, int exchangeBuffer, Executor responseExecutor, ActionListener<Void> listener) {
        transportService.sendRequest(connection, OPEN_EXCHANGE_ACTION_NAME, (TransportRequest)new OpenExchangeRequest(sessionId, exchangeBuffer), TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener.map(unused -> null), in -> TransportResponse.Empty.INSTANCE, responseExecutor));
    }

    public void addExchangeSourceHandler(String sessionId, ExchangeSourceHandler sourceHandler) {
        this.exchangeSources.put(sessionId, sourceHandler);
    }

    public ExchangeSourceHandler removeExchangeSourceHandler(String sessionId) {
        return this.exchangeSources.remove(sessionId);
    }

    public void finishSessionEarly(String sessionId, ActionListener<Void> listener) {
        ExchangeSourceHandler exchangeSource = this.removeExchangeSourceHandler(sessionId);
        if (exchangeSource != null) {
            exchangeSource.finishEarly(false, listener);
        } else {
            listener.onResponse(null);
        }
    }

    public RemoteSink newRemoteSink(Task parentTask, String exchangeId, TransportService transportService, Transport.Connection conn) {
        return new TransportRemoteSink(transportService, this.blockFactory, conn, parentTask, exchangeId, this.executor);
    }

    public boolean isEmpty() {
        return this.sinks.isEmpty();
    }

    public Set<String> sinkKeys() {
        return this.sinks.keySet();
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
        this.doStop();
    }

    public String toString() {
        return "ExchangeService{sinks=" + String.valueOf(this.sinks.keySet()) + "}";
    }

    private final class InactiveSinksReaper
    extends AbstractRunnable {
        private final Logger logger;
        private final TimeValue keepAlive;
        private final ThreadPool threadPool;

        InactiveSinksReaper(Logger logger, ThreadPool threadPool, TimeValue keepAlive) {
            this.logger = logger;
            this.keepAlive = keepAlive;
            this.threadPool = threadPool;
        }

        public void onFailure(Exception e) {
            this.logger.error("unexpected error when closing inactive sinks", (Throwable)e);
            assert (false) : e;
        }

        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            if (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) {
                this.logger.debug("rejected execution when closing inactive sinks");
            } else {
                this.onFailure(e);
            }
        }

        public boolean isForceExecution() {
            return true;
        }

        protected void doRun() {
            assert (Transports.assertNotTransportThread((String)"reaping inactive exchanges can be expensive"));
            assert (ThreadPool.assertNotScheduleThread((String)"reaping inactive exchanges can be expensive"));
            this.logger.debug("start removing inactive sinks");
            long nowInMillis = this.threadPool.relativeTimeInMillis();
            for (Map.Entry<String, ExchangeSinkHandler> e : ExchangeService.this.sinks.entrySet()) {
                long elapsedInMillis;
                ExchangeSinkHandler sink = e.getValue();
                if (sink.hasData() && sink.hasListeners() || (elapsedInMillis = nowInMillis - sink.lastUpdatedTimeInMillis()) <= this.keepAlive.millis()) continue;
                TimeValue elapsedTime = TimeValue.timeValueMillis((long)elapsedInMillis);
                this.logger.debug("removed sink {} inactive for {}", (Object)e.getKey(), (Object)elapsedTime);
                ExchangeService.this.finishSinkHandler(e.getKey(), (Exception)new ElasticsearchTimeoutException("Exchange sink {} has been inactive for {}", new Object[]{e.getKey(), elapsedTime}));
            }
        }
    }

    private class ExchangeTransportAction
    implements TransportRequestHandler<ExchangeRequest> {
        private ExchangeTransportAction() {
        }

        public void messageReceived(ExchangeRequest request, TransportChannel channel, Task exchangeTask) {
            String exchangeId = request.exchangeId();
            ChannelActionListener listener = new ChannelActionListener(channel);
            ExchangeSinkHandler sinkHandler = ExchangeService.this.sinks.get(exchangeId);
            if (sinkHandler == null) {
                listener.onResponse((Object)new ExchangeResponse(ExchangeService.this.blockFactory, null, true));
            } else {
                CancellableTask task = (CancellableTask)exchangeTask;
                task.addListener(() -> sinkHandler.onFailure((Exception)((Object)new TaskCancelledException("request cancelled " + task.getReasonCancelled()))));
                sinkHandler.fetchPageAsync(request.sourcesFinished(), (ActionListener<ExchangeResponse>)listener);
            }
        }
    }

    private class OpenExchangeRequestHandler
    implements TransportRequestHandler<OpenExchangeRequest> {
        private OpenExchangeRequestHandler() {
        }

        public void messageReceived(OpenExchangeRequest request, TransportChannel channel, Task task) throws Exception {
            ExchangeService.this.createSinkHandler(request.sessionId, request.exchangeBuffer);
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        }
    }

    private static class OpenExchangeRequest
    extends TransportRequest {
        private final String sessionId;
        private final int exchangeBuffer;

        OpenExchangeRequest(String sessionId, int exchangeBuffer) {
            this.sessionId = sessionId;
            this.exchangeBuffer = exchangeBuffer;
        }

        OpenExchangeRequest(StreamInput in) throws IOException {
            super(in);
            this.sessionId = in.readString();
            this.exchangeBuffer = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeVInt(this.exchangeBuffer);
        }
    }

    static final class TransportRemoteSink
    implements RemoteSink {
        final TransportService transportService;
        final BlockFactory blockFactory;
        final Transport.Connection connection;
        final Task parentTask;
        final String exchangeId;
        final Executor responseExecutor;
        final AtomicLong estimatedPageSizeInBytes = new AtomicLong(0L);
        final AtomicReference<SubscribableListener<Void>> completionListenerRef = new AtomicReference<Object>(null);

        TransportRemoteSink(TransportService transportService, BlockFactory blockFactory, Transport.Connection connection, Task parentTask, String exchangeId, Executor responseExecutor) {
            this.transportService = transportService;
            this.blockFactory = blockFactory;
            this.connection = connection;
            this.parentTask = parentTask;
            this.exchangeId = exchangeId;
            this.responseExecutor = responseExecutor;
        }

        @Override
        public void fetchPageAsync(boolean allSourcesFinished, ActionListener<ExchangeResponse> listener) {
            if (allSourcesFinished) {
                this.close((ActionListener<Void>)listener.map(unused -> new ExchangeResponse(this.blockFactory, null, true)));
                return;
            }
            SubscribableListener<Void> completionListener = this.completionListenerRef.get();
            if (completionListener != null) {
                completionListener.addListener(listener.map(unused -> new ExchangeResponse(this.blockFactory, null, true)));
                return;
            }
            this.doFetchPageAsync(false, (ActionListener<ExchangeResponse>)ActionListener.wrap(r -> {
                if (r.finished()) {
                    this.completionListenerRef.compareAndSet(null, (SubscribableListener<Void>)SubscribableListener.newSucceeded(null));
                }
                listener.onResponse((Object)r);
            }, e -> this.close((ActionListener<Void>)ActionListener.running(() -> listener.onFailure(e)))));
        }

        private void doFetchPageAsync(boolean allSourcesFinished, ActionListener<ExchangeResponse> listener) {
            long reservedBytes;
            long l = reservedBytes = allSourcesFinished ? 0L : this.estimatedPageSizeInBytes.get();
            if (reservedBytes > 0L) {
                try {
                    this.blockFactory.breaker().addEstimateBytesAndMaybeBreak(reservedBytes, "fetch page");
                }
                catch (Exception e) {
                    assert (e instanceof CircuitBreakingException) : new AssertionError((Object)e);
                    listener.onFailure(e);
                    return;
                }
                listener = ActionListener.runAfter(listener, () -> this.blockFactory.breaker().addWithoutBreaking(-reservedBytes));
            }
            this.transportService.sendChildRequest(this.connection, ExchangeService.EXCHANGE_ACTION_NAME, (TransportRequest)new ExchangeRequest(this.exchangeId, allSourcesFinished), this.parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, in -> {
                try (BlockStreamInput bsi = new BlockStreamInput(in, this.blockFactory);){
                    ExchangeResponse resp = new ExchangeResponse(bsi);
                    long responseBytes = resp.ramBytesUsedByPage();
                    this.estimatedPageSizeInBytes.getAndUpdate(curr -> Math.max(responseBytes, curr / 2L));
                    ExchangeResponse exchangeResponse = resp;
                    return exchangeResponse;
                }
            }, this.responseExecutor));
        }

        @Override
        public void close(ActionListener<Void> listener) {
            SubscribableListener candidate = new SubscribableListener();
            SubscribableListener<Void> actual = this.completionListenerRef.updateAndGet(curr -> Objects.requireNonNullElse(curr, candidate));
            actual.addListener(listener);
            if (candidate == actual) {
                this.doFetchPageAsync(true, (ActionListener<ExchangeResponse>)ActionListener.wrap(r -> {
                    Page page = r.takePage();
                    if (page != null) {
                        page.releaseBlocks();
                    }
                    candidate.onResponse(null);
                }, e -> candidate.onResponse(null)));
            }
        }
    }
}

