/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExchangeSinkOperator
extends SinkOperator {
    private final ExchangeSink sink;
    private final Function<Page, Page> transformer;
    private int pagesReceived;
    private long rowsReceived;

    public ExchangeSinkOperator(ExchangeSink sink, Function<Page, Page> transformer) {
        this.sink = sink;
        this.transformer = transformer;
    }

    @Override
    public boolean isFinished() {
        return this.sink.isFinished();
    }

    public void addCompletionListener(ActionListener<Void> listener) {
        this.sink.addCompletionListener(listener);
    }

    @Override
    public void finish() {
        this.sink.finish();
    }

    @Override
    public IsBlockedResult isBlocked() {
        return this.sink.waitForWriting();
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.isBlocked().listener().isDone();
    }

    @Override
    protected void doAddInput(Page page) {
        ++this.pagesReceived;
        this.rowsReceived += (long)page.getPositionCount();
        this.sink.addPage(this.transformer.apply(page));
    }

    @Override
    public void close() {
        this.finish();
    }

    public String toString() {
        return "ExchangeSinkOperator";
    }

    @Override
    public Status status() {
        return new Status(this.pagesReceived, this.rowsReceived);
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "exchange_sink", Status::new);
        private final int pagesReceived;
        private final long rowsReceived;

        Status(int pagesReceived, long rowsReceived) {
            this.pagesReceived = pagesReceived;
            this.rowsReceived = rowsReceived;
        }

        Status(StreamInput in) throws IOException {
            this.pagesReceived = in.readVInt();
            this.rowsReceived = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED) ? in.readVLong() : 0L;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.pagesReceived);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED)) {
                out.writeVLong(this.rowsReceived);
            }
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesReceived() {
            return this.pagesReceived;
        }

        public long rowsReceived() {
            return this.rowsReceived;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("pages_received", this.pagesReceived);
            builder.field("rows_received", this.rowsReceived);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.pagesReceived == status.pagesReceived && this.rowsReceived == status.rowsReceived;
        }

        public int hashCode() {
            return Objects.hash(this.pagesReceived, this.rowsReceived);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }

    public record ExchangeSinkOperatorFactory(Supplier<ExchangeSink> exchangeSinks, Function<Page, Page> transformer) implements SinkOperator.SinkOperatorFactory
    {
        @Override
        public SinkOperator get(DriverContext driverContext) {
            return new ExchangeSinkOperator(this.exchangeSinks.get(), this.transformer);
        }

        @Override
        public String describe() {
            return "ExchangeSinkOperator";
        }
    }
}

