/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;

public class TransportCreateServiceAccountTokenAction
extends HandledTransportAction<CreateServiceAccountTokenRequest, CreateServiceAccountTokenResponse> {
    private final ServiceAccountService serviceAccountService;
    private final SecurityContext securityContext;

    @Inject
    public TransportCreateServiceAccountTokenAction(TransportService transportService, ActionFilters actionFilters, ServiceAccountService serviceAccountService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/service_account/token/create", transportService, actionFilters, CreateServiceAccountTokenRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.serviceAccountService = serviceAccountService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, CreateServiceAccountTokenRequest request, ActionListener<CreateServiceAccountTokenResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        } else {
            this.serviceAccountService.createIndexToken(authentication, request, listener);
        }
    }
}

