/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.painless.PainlessError;
import org.elasticsearch.painless.PainlessExplainError;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

class ErrorCauseWrapper
extends ElasticsearchException {
    private static final List<Class<? extends Error>> wrappedErrors = List.of(PainlessError.class, PainlessExplainError.class, OutOfMemoryError.class, StackOverflowError.class, LinkageError.class);
    final Throwable realCause;

    private ErrorCauseWrapper(Throwable realCause) {
        super(realCause.getMessage(), new Object[0]);
        this.realCause = realCause;
    }

    protected XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, int nestedLevel) throws IOException {
        builder.field("type", ErrorCauseWrapper.getExceptionName((Throwable)this.realCause));
        builder.field("reason", this.realCause.getMessage());
        return builder;
    }

    static Throwable maybeWrap(Throwable t) {
        if (wrappedErrors.contains(t.getClass())) {
            return new ErrorCauseWrapper(t);
        }
        return t;
    }
}

