/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class RemoteClusterFeatureSetUsage
extends XPackFeatureUsage {
    private final List<RemoteConnectionInfo> remoteConnectionInfos;

    public RemoteClusterFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.remoteConnectionInfos = in.readCollectionAsImmutableList(RemoteConnectionInfo::new);
    }

    public RemoteClusterFeatureSetUsage(List<RemoteConnectionInfo> remoteConnectionInfos) {
        super("remote_clusters", true, true);
        this.remoteConnectionInfos = remoteConnectionInfos;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.remoteConnectionInfos);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        int size = this.remoteConnectionInfos.size();
        builder.field("size", size);
        int numberOfSniffModes = 0;
        int numberOfApiKeySecured = 0;
        for (RemoteConnectionInfo info : this.remoteConnectionInfos) {
            if ("sniff".equals(info.getModeInfo().modeName())) {
                ++numberOfSniffModes;
            } else assert ("proxy".equals(info.getModeInfo().modeName()));
            if (!info.hasClusterCredentials()) continue;
            ++numberOfApiKeySecured;
        }
        builder.startObject("mode");
        builder.field("proxy", size - numberOfSniffModes);
        builder.field("sniff", numberOfSniffModes);
        builder.endObject();
        builder.startObject("security");
        builder.field("cert", size - numberOfApiKeySecured);
        builder.field("api_key", numberOfApiKeySecured);
        builder.endObject();
    }
}

