/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.SetUpgradeModeActionRequest;

public abstract class AbstractTransportSetUpgradeModeAction
extends AcknowledgedTransportMasterNodeAction<SetUpgradeModeActionRequest> {
    private static final Logger logger = LogManager.getLogger(AbstractTransportSetUpgradeModeAction.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final MasterServiceTaskQueue<UpdateModeStateListener> taskQueue;

    public AbstractTransportSetUpgradeModeAction(String actionName, String taskQueuePrefix, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, SetUpgradeModeActionRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.taskQueue = clusterService.createTaskQueue(taskQueuePrefix + " upgrade mode", Priority.NORMAL, (ClusterStateTaskExecutor)new UpdateModeExecutor());
    }

    protected void masterOperation(Task task, SetUpgradeModeActionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.isRunning.compareAndSet(false, true)) {
            String msg = Strings.format((String)"Attempted to set [upgrade_mode] for feature name [%s] to [%s] from [%s] while previous request was processing.", (Object[])new Object[]{this.featureName(), request.enabled(), this.upgradeMode(state)});
            logger.info(msg);
            IllegalStateException detail = new IllegalStateException(msg);
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot change [upgrade_mode] for feature name [{}]. Previous request is still being processed.", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[]{this.featureName()}));
            return;
        }
        boolean upgradeMode = this.upgradeMode(state);
        if (request.enabled() == upgradeMode) {
            logger.info("Upgrade mode noop");
            this.isRunning.set(false);
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        logger.info("Starting to set [upgrade_mode] for feature name [{}] to [{}] from [{}]", (Object)this.featureName(), (Object)request.enabled(), (Object)upgradeMode);
        ActionListener wrappedListener = ActionListener.wrap(r -> {
            logger.info("Finished setting [upgrade_mode] for feature name [{}]", (Object)this.featureName());
            this.isRunning.set(false);
            listener.onResponse(r);
        }, e -> {
            logger.info("Failed to set [upgrade_mode] for feature name [{}]", (Object)this.featureName());
            this.isRunning.set(false);
            listener.onFailure(e);
        });
        ActionListener setUpgradeModeListener = wrappedListener.delegateFailure((delegate, ack) -> {
            if (ack.isAcknowledged()) {
                this.upgradeModeSuccessfullyChanged(task, request, state, (ActionListener<AcknowledgedResponse>)delegate);
            } else {
                logger.info("Cluster state update is NOT acknowledged");
                wrappedListener.onFailure((Exception)new ElasticsearchTimeoutException("Unknown error occurred while updating cluster state", new Object[0]));
            }
        });
        this.taskQueue.submitTask(this.featureName(), (ClusterStateTaskListener)new UpdateModeStateListener(request, (ActionListener<AcknowledgedResponse>)setUpgradeModeListener), request.ackTimeout());
    }

    protected abstract String featureName();

    protected abstract boolean upgradeMode(ClusterState var1);

    protected abstract ClusterState createUpdatedState(SetUpgradeModeActionRequest var1, ClusterState var2);

    protected abstract void upgradeModeSuccessfullyChanged(Task var1, SetUpgradeModeActionRequest var2, ClusterState var3, ActionListener<AcknowledgedResponse> var4);

    protected ClusterBlockException checkBlock(SetUpgradeModeActionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private class UpdateModeExecutor
    extends SimpleBatchedExecutor<UpdateModeStateListener, Void> {
        private UpdateModeExecutor() {
        }

        public Tuple<ClusterState, Void> executeTask(UpdateModeStateListener clusterStateListener, ClusterState clusterState) {
            return Tuple.tuple((Object)AbstractTransportSetUpgradeModeAction.this.createUpdatedState(clusterStateListener.request(), clusterState), null);
        }

        public void taskSucceeded(UpdateModeStateListener clusterStateListener, Void unused) {
            clusterStateListener.listener().onResponse((Object)AcknowledgedResponse.TRUE);
        }
    }

    private record UpdateModeStateListener(SetUpgradeModeActionRequest request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

