/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action.util;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class QueryPage<T extends ToXContent & Writeable>
implements ToXContentObject,
Writeable {
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    public static final ParseField DEFAULT_RESULTS_FIELD = new ParseField("results_field", new String[0]);
    private final ParseField resultsField;
    private final List<T> results;
    private final long count;

    public QueryPage(List<T> results, long count, ParseField resultsField) {
        this.results = results;
        this.count = count;
        this.resultsField = Objects.requireNonNull(resultsField);
    }

    public QueryPage(StreamInput in, Writeable.Reader<T> hitReader) throws IOException {
        this.resultsField = new ParseField(in.readString(), new String[0]);
        this.results = in.readCollectionAsList(hitReader);
        this.count = in.readLong();
    }

    public static ResourceNotFoundException emptyQueryPage(ParseField resultsField) {
        return new ResourceNotFoundException("Could not find requested " + resultsField.getPreferredName(), new Object[0]);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField.getPreferredName());
        out.writeCollection(this.results);
        out.writeLong(this.count);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(COUNT.getPreferredName(), this.count);
        builder.startArray(this.resultsField.getPreferredName());
        for (ToXContent result : this.results) {
            if (result == null) continue;
            result.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public List<T> results() {
        return this.results;
    }

    public long count() {
        return this.count;
    }

    public ParseField getResultsField() {
        return this.resultsField;
    }

    public int hashCode() {
        return Objects.hash(this.results, this.count);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryPage other = (QueryPage)obj;
        return Objects.equals(this.results, other.results) && Objects.equals(this.count, other.count);
    }
}

