/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.Map;

public class MetadataUtils {
    public static final String RESERVED_PREFIX = "_";
    public static final String RESERVED_METADATA_KEY = "_reserved";
    public static final String DEPRECATED_METADATA_KEY = "_deprecated";
    public static final String DEPRECATED_REASON_METADATA_KEY = "_deprecated_reason";
    public static final Map<String, Object> DEFAULT_RESERVED_METADATA = Map.of("_reserved", true);

    private MetadataUtils() {
    }

    public static boolean containsReservedMetadata(Map<String, Object> metadata) {
        for (String key : metadata.keySet()) {
            if (!key.startsWith(RESERVED_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> getDeprecatedReservedMetadata(String reason) {
        return Map.of(RESERVED_METADATA_KEY, true, DEPRECATED_METADATA_KEY, true, DEPRECATED_REASON_METADATA_KEY, reason);
    }
}

