// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, DataSource, MapProjection, MapSource};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "ShumateRasterRenderer")]
    pub struct RasterRenderer(Object<ffi::ShumateRasterRenderer, ffi::ShumateRasterRendererClass>) @extends MapSource;

    match fn {
        type_ => || ffi::shumate_raster_renderer_get_type(),
    }
}

impl RasterRenderer {
    #[doc(alias = "shumate_raster_renderer_new")]
    pub fn new(data_source: &impl IsA<DataSource>) -> RasterRenderer {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::shumate_raster_renderer_new(
                data_source.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_raster_renderer_new_from_url")]
    #[doc(alias = "new_from_url")]
    pub fn from_url(url_template: &str) -> RasterRenderer {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::shumate_raster_renderer_new_from_url(
                url_template.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_raster_renderer_new_full")]
    pub fn new_full(
        id: &str,
        name: &str,
        license: &str,
        license_uri: &str,
        min_zoom: u32,
        max_zoom: u32,
        tile_size: u32,
        projection: MapProjection,
        data_source: &impl IsA<DataSource>,
    ) -> RasterRenderer {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::shumate_raster_renderer_new_full(
                id.to_glib_none().0,
                name.to_glib_none().0,
                license.to_glib_none().0,
                license_uri.to_glib_none().0,
                min_zoom,
                max_zoom,
                tile_size,
                projection.into_glib(),
                data_source.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_raster_renderer_new_full_from_url")]
    pub fn new_full_from_url(
        id: &str,
        name: &str,
        license: &str,
        license_uri: &str,
        min_zoom: u32,
        max_zoom: u32,
        tile_size: u32,
        projection: MapProjection,
        url_template: &str,
    ) -> RasterRenderer {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::shumate_raster_renderer_new_full_from_url(
                id.to_glib_none().0,
                name.to_glib_none().0,
                license.to_glib_none().0,
                license_uri.to_glib_none().0,
                min_zoom,
                max_zoom,
                tile_size,
                projection.into_glib(),
                url_template.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`RasterRenderer`] objects.
    ///
    /// This method returns an instance of [`RasterRendererBuilder`](crate::builders::RasterRendererBuilder) which can be used to create [`RasterRenderer`] objects.
    pub fn builder() -> RasterRendererBuilder {
        RasterRendererBuilder::new()
    }

    #[doc(alias = "data-source")]
    pub fn data_source(&self) -> Option<DataSource> {
        ObjectExt::property(self, "data-source")
    }
}

impl Default for RasterRenderer {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`RasterRenderer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RasterRendererBuilder {
    builder: glib::object::ObjectBuilder<'static, RasterRenderer>,
}

impl RasterRendererBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn data_source(self, data_source: &impl IsA<DataSource>) -> Self {
        Self {
            builder: self
                .builder
                .property("data-source", data_source.clone().upcast()),
        }
    }

    pub fn id(self, id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("id", id.into()),
        }
    }

    pub fn license(self, license: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("license", license.into()),
        }
    }

    pub fn license_uri(self, license_uri: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("license-uri", license_uri.into()),
        }
    }

    pub fn max_zoom_level(self, max_zoom_level: u32) -> Self {
        Self {
            builder: self.builder.property("max-zoom-level", max_zoom_level),
        }
    }

    pub fn min_zoom_level(self, min_zoom_level: u32) -> Self {
        Self {
            builder: self.builder.property("min-zoom-level", min_zoom_level),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn projection(self, projection: MapProjection) -> Self {
        Self {
            builder: self.builder.property("projection", projection),
        }
    }

    pub fn tile_size(self, tile_size: u32) -> Self {
        Self {
            builder: self.builder.property("tile-size", tile_size),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`RasterRenderer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> RasterRenderer {
        self.builder.build()
    }
}
