#include <limits>
#include <iostream>
#include "../common/spline-interpolation.hpp"

constexpr double interpolationAbsoluteTolerance=1.2e-10;
#define FAIL(details) { std::cerr << __FILE__ << ":" << __LINE__  << ": test failed: " << details << "\n"; return 1; }

struct Point
{
    double x, y;
};

int main()
{
    // Uniformly distributed random reals in [-5,5]
    const std::vector<Point> input{{-4.85401463528297,-0.669532554114154}, {-4.51404088984147,4.2698990297673},
        {-4.38570356441999,4.58526039845011}, {-4.36485900148671,-1.94195940931437},
        {-3.69648869340974,2.10579020077083}, {-2.56470816837255,3.96183431972245},
        {-2.28504263062175,1.89990573386456}, {-2.22022590075474,-4.93360555378858},
        {-1.29802947507665,-2.56510050309937}, {-1.12935320089733,-3.56749653658252},
        {-0.31380778626463,2.51608776267202}, {-0.0677059787424894,0.619000205672691},
        {0.43112934213019,3.10168959230928}, {1.14077843545086,-3.96194747515895}, {1.28327986067432,2.62768997542679},
        {1.61514836126665,2.18437751270008}, {1.74373534266612,-0.352878185816652}, {2.0822519470107,-1.345792091787},
        {2.3814499803764,-2.49159018990558}, {2.7429742914518,1.41547403483686}, {3.09422271858495,-3.48718432614314},
        {4.03684917522953,-1.81771627556167}, {4.54463276140721,2.58709236726711}};

    const std::vector<Point> reference{{-4.85401463528297,-0.669532554114154}, {-4.7204388334822,-3.85771119631952},
        {-4.58686303168143,-0.407309541407802}, {-4.45328722988066,9.68167241062094},
        {-4.3197114280799,-14.9026200572415}, {-4.18613562627913,-37.0640747186476},
        {-4.05255982447836,-35.0331828769312}, {-3.91898402267759,-18.469008209895},
        {-3.78540822087682,-4.97239696676153}, {-3.65183241907605,5.08576549461799},
        {-3.51825661727528,11.7054791742435}, {-3.38468081547451,14.8867440721151},
        {-3.25110501367375,14.6295601882326}, {-3.11752921187298,10.9578683654}, {-2.98395341007221,6.81406509565526},
        {-2.85037760827144,4.2336063168637}, {-2.71680180647067,3.2164920290253}, {-2.5832260046699,3.76272223214005},
        {-2.44965020286913,5.87229692620797}, {-2.31607440106836,4.2646274475904}, {-2.1824985992676,-8.59140004025125},
        {-2.04892279746683,-17.5685137139841}, {-1.91534699566606,-20.3488052539715},
        {-1.78177119386529,-16.9322746602134}, {-1.64819539206452,-10.204967442167},
        {-1.51461959026375,-5.52957521517595}, {-1.38104378846298,-3.02634505226522},
        {-1.24746798666221,-2.69527695343482}, {-1.11389218486144,-3.63375140751588},
        {-0.980316383060676,-3.61380483569035}, {-0.846740581259907,-2.53204590883772},
        {-0.713164779459138,-0.392664555686304}, {-0.57958897765837,1.62415886321819},
        {-0.446013175857601,2.591687557241}, {-0.312437374056832,2.50992152638213},
        {-0.178861572256063,1.38803061371587}, {-0.0452857704552945,0.569904433845974},
        {0.0882900313454743,1.01505908911452}, {0.221865833146243,2.59809975896347},
        {0.355441634947012,3.34791360920874}, {0.489017436747781,2.5857445126493},
        {0.622593238548549,0.311592469285142}, {0.756169040349318,-3.47454252088373},
        {0.889744842150087,-7.15905007302888}, {1.02332064395086,-7.14320797201852},
        {1.15689644575162,-3.29413289878681}, {1.29047224755239,2.87406006060709}, {1.42404804935316,4.84261014589466},
        {1.55762385115393,3.19866739807215}, {1.6911996529547,0.599992069499187}, {1.82477545475547,-1.23115290858521},
        {1.95835125655624,-1.26199500516125}, {2.09192705835701,-1.37588142554114},
        {2.22550286015778,-2.13992087885673}, {2.35907866195854,-2.56833123419287},
        {2.49265446375931,-1.47613138462732}, {2.62623026556008,0.730660859720204}, {2.75980606736085,1.38608257313888},
        {2.89338186916162,0.00791245313850988}, {3.02695767096239,-2.4884583536782}, {3.16053347276316,-4.285969843302},
        {3.29410927456393,-5.33504850288819}, {3.42768507636469,-5.63569433243678},
        {3.56126087816546,-5.18790733194778}, {3.69483667996623,-4.31534455628158}, {3.828412481767,-3.38482114849937},
        {3.96198828356777,-2.39669091795357}, {4.09556408536854,-1.35095386464418},
        {4.22913988716931,-0.247609988571175}, {4.36271568897008,0.913340710265416},
        {4.49629149077084,2.1318982318656}};

    const auto interpolated=splineInterpolationOrder2(input.data(), input.size());

    for(unsigned k=0; k<reference.size(); ++k)
    {
        const auto& p=reference[k];
        const auto diff = interpolated.sample(p.x)-p.y;
        if(std::abs(diff) > interpolationAbsoluteTolerance)
            FAIL("sample at x=" << p.x << " (k=" << k << ") differs from reference by " << diff << ", which is more than "
                 << interpolationAbsoluteTolerance << "\n");
    }

    return 0;
}
