// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetACLFrontendOKCode is the HTTP code returned for type GetACLFrontendOK
const GetACLFrontendOKCode int = 200

/*
GetACLFrontendOK Successful operation

swagger:response getAclFrontendOK
*/
type GetACLFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewGetACLFrontendOK creates GetACLFrontendOK with default headers values
func NewGetACLFrontendOK() *GetACLFrontendOK {

	return &GetACLFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Acl frontend o k response
func (o *GetACLFrontendOK) WithConfigurationVersion(configurationVersion string) *GetACLFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Acl frontend o k response
func (o *GetACLFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Acl frontend o k response
func (o *GetACLFrontendOK) WithPayload(payload *models.ACL) *GetACLFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Acl frontend o k response
func (o *GetACLFrontendOK) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetACLFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetACLFrontendNotFoundCode is the HTTP code returned for type GetACLFrontendNotFound
const GetACLFrontendNotFoundCode int = 404

/*
GetACLFrontendNotFound The specified resource was not found

swagger:response getAclFrontendNotFound
*/
type GetACLFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetACLFrontendNotFound creates GetACLFrontendNotFound with default headers values
func NewGetACLFrontendNotFound() *GetACLFrontendNotFound {

	return &GetACLFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Acl frontend not found response
func (o *GetACLFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetACLFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Acl frontend not found response
func (o *GetACLFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Acl frontend not found response
func (o *GetACLFrontendNotFound) WithPayload(payload *models.Error) *GetACLFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Acl frontend not found response
func (o *GetACLFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetACLFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetACLFrontendDefault General Error

swagger:response getAclFrontendDefault
*/
type GetACLFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetACLFrontendDefault creates GetACLFrontendDefault with default headers values
func NewGetACLFrontendDefault(code int) *GetACLFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetACLFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get Acl frontend default response
func (o *GetACLFrontendDefault) WithStatusCode(code int) *GetACLFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get Acl frontend default response
func (o *GetACLFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get Acl frontend default response
func (o *GetACLFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetACLFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Acl frontend default response
func (o *GetACLFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Acl frontend default response
func (o *GetACLFrontendDefault) WithPayload(payload *models.Error) *GetACLFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Acl frontend default response
func (o *GetACLFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetACLFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
