// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// EditClusterOKCode is the HTTP code returned for type EditClusterOK
const EditClusterOKCode int = 200

/*
EditClusterOK Cluster settings changed

swagger:response editClusterOK
*/
type EditClusterOK struct {

	/*
	  In: Body
	*/
	Payload *models.ClusterSettings `json:"body,omitempty"`
}

// NewEditClusterOK creates EditClusterOK with default headers values
func NewEditClusterOK() *EditClusterOK {

	return &EditClusterOK{}
}

// WithPayload adds the payload to the edit cluster o k response
func (o *EditClusterOK) WithPayload(payload *models.ClusterSettings) *EditClusterOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit cluster o k response
func (o *EditClusterOK) SetPayload(payload *models.ClusterSettings) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditClusterOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// EditClusterBadRequestCode is the HTTP code returned for type EditClusterBadRequest
const EditClusterBadRequestCode int = 400

/*
EditClusterBadRequest Bad request

swagger:response editClusterBadRequest
*/
type EditClusterBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewEditClusterBadRequest creates EditClusterBadRequest with default headers values
func NewEditClusterBadRequest() *EditClusterBadRequest {

	return &EditClusterBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the edit cluster bad request response
func (o *EditClusterBadRequest) WithConfigurationVersion(configurationVersion string) *EditClusterBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the edit cluster bad request response
func (o *EditClusterBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the edit cluster bad request response
func (o *EditClusterBadRequest) WithPayload(payload *models.Error) *EditClusterBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit cluster bad request response
func (o *EditClusterBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditClusterBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
EditClusterDefault General Error

swagger:response editClusterDefault
*/
type EditClusterDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewEditClusterDefault creates EditClusterDefault with default headers values
func NewEditClusterDefault(code int) *EditClusterDefault {
	if code <= 0 {
		code = 500
	}

	return &EditClusterDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the edit cluster default response
func (o *EditClusterDefault) WithStatusCode(code int) *EditClusterDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the edit cluster default response
func (o *EditClusterDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the edit cluster default response
func (o *EditClusterDefault) WithConfigurationVersion(configurationVersion string) *EditClusterDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the edit cluster default response
func (o *EditClusterDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the edit cluster default response
func (o *EditClusterDefault) WithPayload(payload *models.Error) *EditClusterDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit cluster default response
func (o *EditClusterDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditClusterDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
