// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPErrorRuleBackendAcceptedCode is the HTTP code returned for type DeleteHTTPErrorRuleBackendAccepted
const DeleteHTTPErrorRuleBackendAcceptedCode int = 202

/*
DeleteHTTPErrorRuleBackendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpErrorRuleBackendAccepted
*/
type DeleteHTTPErrorRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPErrorRuleBackendAccepted creates DeleteHTTPErrorRuleBackendAccepted with default headers values
func NewDeleteHTTPErrorRuleBackendAccepted() *DeleteHTTPErrorRuleBackendAccepted {

	return &DeleteHTTPErrorRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http error rule backend accepted response
func (o *DeleteHTTPErrorRuleBackendAccepted) WithReloadID(reloadID string) *DeleteHTTPErrorRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http error rule backend accepted response
func (o *DeleteHTTPErrorRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPErrorRuleBackendNoContentCode is the HTTP code returned for type DeleteHTTPErrorRuleBackendNoContent
const DeleteHTTPErrorRuleBackendNoContentCode int = 204

/*
DeleteHTTPErrorRuleBackendNoContent HTTP Error Rule deleted

swagger:response deleteHttpErrorRuleBackendNoContent
*/
type DeleteHTTPErrorRuleBackendNoContent struct {
}

// NewDeleteHTTPErrorRuleBackendNoContent creates DeleteHTTPErrorRuleBackendNoContent with default headers values
func NewDeleteHTTPErrorRuleBackendNoContent() *DeleteHTTPErrorRuleBackendNoContent {

	return &DeleteHTTPErrorRuleBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPErrorRuleBackendNotFoundCode is the HTTP code returned for type DeleteHTTPErrorRuleBackendNotFound
const DeleteHTTPErrorRuleBackendNotFoundCode int = 404

/*
DeleteHTTPErrorRuleBackendNotFound The specified resource was not found

swagger:response deleteHttpErrorRuleBackendNotFound
*/
type DeleteHTTPErrorRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPErrorRuleBackendNotFound creates DeleteHTTPErrorRuleBackendNotFound with default headers values
func NewDeleteHTTPErrorRuleBackendNotFound() *DeleteHTTPErrorRuleBackendNotFound {

	return &DeleteHTTPErrorRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http error rule backend not found response
func (o *DeleteHTTPErrorRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPErrorRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http error rule backend not found response
func (o *DeleteHTTPErrorRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http error rule backend not found response
func (o *DeleteHTTPErrorRuleBackendNotFound) WithPayload(payload *models.Error) *DeleteHTTPErrorRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http error rule backend not found response
func (o *DeleteHTTPErrorRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPErrorRuleBackendDefault General Error

swagger:response deleteHttpErrorRuleBackendDefault
*/
type DeleteHTTPErrorRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPErrorRuleBackendDefault creates DeleteHTTPErrorRuleBackendDefault with default headers values
func NewDeleteHTTPErrorRuleBackendDefault(code int) *DeleteHTTPErrorRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPErrorRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP error rule backend default response
func (o *DeleteHTTPErrorRuleBackendDefault) WithStatusCode(code int) *DeleteHTTPErrorRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP error rule backend default response
func (o *DeleteHTTPErrorRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP error rule backend default response
func (o *DeleteHTTPErrorRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPErrorRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP error rule backend default response
func (o *DeleteHTTPErrorRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP error rule backend default response
func (o *DeleteHTTPErrorRuleBackendDefault) WithPayload(payload *models.Error) *DeleteHTTPErrorRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP error rule backend default response
func (o *DeleteHTTPErrorRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
