// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package information

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetInfoOKCode is the HTTP code returned for type GetInfoOK
const GetInfoOKCode int = 200

/*
GetInfoOK Success

swagger:response getInfoOK
*/
type GetInfoOK struct {

	/*
	  In: Body
	*/
	Payload *models.Info `json:"body,omitempty"`
}

// NewGetInfoOK creates GetInfoOK with default headers values
func NewGetInfoOK() *GetInfoOK {

	return &GetInfoOK{}
}

// WithPayload adds the payload to the get info o k response
func (o *GetInfoOK) WithPayload(payload *models.Info) *GetInfoOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get info o k response
func (o *GetInfoOK) SetPayload(payload *models.Info) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetInfoOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetInfoDefault General Error

swagger:response getInfoDefault
*/
type GetInfoDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetInfoDefault creates GetInfoDefault with default headers values
func NewGetInfoDefault(code int) *GetInfoDefault {
	if code <= 0 {
		code = 500
	}

	return &GetInfoDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get info default response
func (o *GetInfoDefault) WithStatusCode(code int) *GetInfoDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get info default response
func (o *GetInfoDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get info default response
func (o *GetInfoDefault) WithConfigurationVersion(configurationVersion string) *GetInfoDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get info default response
func (o *GetInfoDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get info default response
func (o *GetInfoDefault) WithPayload(payload *models.Error) *GetInfoDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get info default response
func (o *GetInfoDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetInfoDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
