// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_profile

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogProfilesOKCode is the HTTP code returned for type GetLogProfilesOK
const GetLogProfilesOKCode int = 200

/*
GetLogProfilesOK Successful operation

swagger:response getLogProfilesOK
*/
type GetLogProfilesOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogProfiles `json:"body,omitempty"`
}

// NewGetLogProfilesOK creates GetLogProfilesOK with default headers values
func NewGetLogProfilesOK() *GetLogProfilesOK {

	return &GetLogProfilesOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log profiles o k response
func (o *GetLogProfilesOK) WithConfigurationVersion(configurationVersion string) *GetLogProfilesOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log profiles o k response
func (o *GetLogProfilesOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log profiles o k response
func (o *GetLogProfilesOK) WithPayload(payload models.LogProfiles) *GetLogProfilesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log profiles o k response
func (o *GetLogProfilesOK) SetPayload(payload models.LogProfiles) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProfilesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogProfiles{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetLogProfilesDefault General Error

swagger:response getLogProfilesDefault
*/
type GetLogProfilesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogProfilesDefault creates GetLogProfilesDefault with default headers values
func NewGetLogProfilesDefault(code int) *GetLogProfilesDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogProfilesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log profiles default response
func (o *GetLogProfilesDefault) WithStatusCode(code int) *GetLogProfilesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log profiles default response
func (o *GetLogProfilesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log profiles default response
func (o *GetLogProfilesDefault) WithConfigurationVersion(configurationVersion string) *GetLogProfilesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log profiles default response
func (o *GetLogProfilesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log profiles default response
func (o *GetLogProfilesDefault) WithPayload(payload *models.Error) *GetLogProfilesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log profiles default response
func (o *GetLogProfilesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProfilesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
