// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetServerPeerOKCode is the HTTP code returned for type GetServerPeerOK
const GetServerPeerOKCode int = 200

/*
GetServerPeerOK Successful operation

swagger:response getServerPeerOK
*/
type GetServerPeerOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewGetServerPeerOK creates GetServerPeerOK with default headers values
func NewGetServerPeerOK() *GetServerPeerOK {

	return &GetServerPeerOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get server peer o k response
func (o *GetServerPeerOK) WithConfigurationVersion(configurationVersion string) *GetServerPeerOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server peer o k response
func (o *GetServerPeerOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server peer o k response
func (o *GetServerPeerOK) WithPayload(payload *models.Server) *GetServerPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server peer o k response
func (o *GetServerPeerOK) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetServerPeerNotFoundCode is the HTTP code returned for type GetServerPeerNotFound
const GetServerPeerNotFoundCode int = 404

/*
GetServerPeerNotFound The specified resource was not found

swagger:response getServerPeerNotFound
*/
type GetServerPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerPeerNotFound creates GetServerPeerNotFound with default headers values
func NewGetServerPeerNotFound() *GetServerPeerNotFound {

	return &GetServerPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get server peer not found response
func (o *GetServerPeerNotFound) WithConfigurationVersion(configurationVersion string) *GetServerPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server peer not found response
func (o *GetServerPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server peer not found response
func (o *GetServerPeerNotFound) WithPayload(payload *models.Error) *GetServerPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server peer not found response
func (o *GetServerPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetServerPeerDefault General Error

swagger:response getServerPeerDefault
*/
type GetServerPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerPeerDefault creates GetServerPeerDefault with default headers values
func NewGetServerPeerDefault(code int) *GetServerPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &GetServerPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get server peer default response
func (o *GetServerPeerDefault) WithStatusCode(code int) *GetServerPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get server peer default response
func (o *GetServerPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get server peer default response
func (o *GetServerPeerDefault) WithConfigurationVersion(configurationVersion string) *GetServerPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server peer default response
func (o *GetServerPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server peer default response
func (o *GetServerPeerDefault) WithPayload(payload *models.Error) *GetServerPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server peer default response
func (o *GetServerPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
