// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package stick_table

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/haproxytech/client-native/v6/models"
)

// SetStickTableEntriesHandlerFunc turns a function with the right signature into a set stick table entries handler
type SetStickTableEntriesHandlerFunc func(SetStickTableEntriesParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn SetStickTableEntriesHandlerFunc) Handle(params SetStickTableEntriesParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// SetStickTableEntriesHandler interface for that can handle valid set stick table entries params
type SetStickTableEntriesHandler interface {
	Handle(SetStickTableEntriesParams, interface{}) middleware.Responder
}

// NewSetStickTableEntries creates a new http.Handler for the set stick table entries operation
func NewSetStickTableEntries(ctx *middleware.Context, handler SetStickTableEntriesHandler) *SetStickTableEntries {
	return &SetStickTableEntries{Context: ctx, Handler: handler}
}

/*
	SetStickTableEntries swagger:route POST /services/haproxy/runtime/stick_tables/{parent_name}/entries StickTable setStickTableEntries

# Set Entry to Stick Table

Create or update a stick-table entry in the table.
*/
type SetStickTableEntries struct {
	Context *middleware.Context
	Handler SetStickTableEntriesHandler
}

func (o *SetStickTableEntries) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewSetStickTableEntriesParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// SetStickTableEntriesBody set stick table entries body
//
// swagger:model SetStickTableEntriesBody
type SetStickTableEntriesBody struct {

	// data type
	// Required: true
	DataType *models.StickTableEntry `json:"data_type"`

	// key
	// Required: true
	Key *string `json:"key"`
}

// Validate validates this set stick table entries body
func (o *SetStickTableEntriesBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SetStickTableEntriesBody) validateDataType(formats strfmt.Registry) error {

	if err := validate.Required("stick_table_entry"+"."+"data_type", "body", o.DataType); err != nil {
		return err
	}

	if o.DataType != nil {
		if err := o.DataType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stick_table_entry" + "." + "data_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stick_table_entry" + "." + "data_type")
			}
			return err
		}
	}

	return nil
}

func (o *SetStickTableEntriesBody) validateKey(formats strfmt.Registry) error {

	if err := validate.Required("stick_table_entry"+"."+"key", "body", o.Key); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this set stick table entries body based on the context it is used
func (o *SetStickTableEntriesBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SetStickTableEntriesBody) contextValidateDataType(ctx context.Context, formats strfmt.Registry) error {

	if o.DataType != nil {

		if err := o.DataType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stick_table_entry" + "." + "data_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stick_table_entry" + "." + "data_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SetStickTableEntriesBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SetStickTableEntriesBody) UnmarshalBinary(b []byte) error {
	var res SetStickTableEntriesBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
