# Breaking changes to make for v2

## `[1 ..]` syntax

Due to a bug in the parser we accept `[1, ..]` as a valid list value.

- [x] Emits warning when used.
- [x] Formatter rewrites it to desired syntax.

## `_ as a` syntax

This pattern doesn't make sense as one could write `a` instead. We don't want
two ways of doing the same thing.

- [x] Emits warning when used.
- [x] Formatter rewrites it to desired syntax.

## Shadowing imported values

Do not allow shadowing an imported value, the same way one can't define two
top level functions with the same name.

- [x] Emits warning when used.

## Import one module multiple times

Do not allow one module to be imported multiple times. This is currently
accepted so long as each import uses a different alias.

- [x] Emits warning when used.

## JavaScript runtime error `fn` property

On JavaScript there is a deprecated `fn` property. This was a mistake, it
should have been `function`. It still exists today due to backwards
compatibility.

## Do not allow guard with no condition

It doesn't make sense to have an `if` guard followed by no condition, but the
compiler allows this: `case wibble { big if -> True }`

- [x] Emits warning when used.
- [x] Formatter rewrites it to desired syntax.
