/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.Arrays;

public class Comment
implements TextBlock {
    private final String[] text;
    private final int startLineNo;
    private final int endLineNo;
    private final int startColNo;
    private final int endColNo;

    public Comment(String[] text, int firstCol, int lastLine, int lastCol) {
        this.text = (String[])text.clone();
        this.startLineNo = lastLine - text.length + 1;
        this.endLineNo = lastLine;
        this.startColNo = firstCol;
        this.endColNo = lastCol;
    }

    @Override
    public final String[] getText() {
        return (String[])this.text.clone();
    }

    @Override
    public final int getStartLineNo() {
        return this.startLineNo;
    }

    @Override
    public final int getEndLineNo() {
        return this.endLineNo;
    }

    @Override
    public int getStartColNo() {
        return this.startColNo;
    }

    @Override
    public int getEndColNo() {
        return this.endColNo;
    }

    @Override
    public boolean intersects(int startLine, int startCol, int endLine, int endCol) {
        long multiplier = Integer.MAX_VALUE;
        long thisStart = (long)this.startLineNo * Integer.MAX_VALUE + (long)this.startColNo;
        long thisEnd = (long)this.endLineNo * Integer.MAX_VALUE + (long)this.endColNo;
        long inStart = (long)startLine * Integer.MAX_VALUE + (long)startCol;
        long inEnd = (long)endLine * Integer.MAX_VALUE + (long)endCol;
        return thisEnd >= inStart && inEnd >= thisStart;
    }

    public String toString() {
        return "Comment[text=" + Arrays.toString(this.text) + ", startLineNo=" + this.startLineNo + ", endLineNo=" + this.endLineNo + ", startColNo=" + this.startColNo + ", endColNo=" + this.endColNo + ']';
    }
}

