/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.XmlLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;
import com.puppycrawl.tools.checkstyle.filters.XpathFilter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SuppressionsLoader
extends XmlLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Suppressions 1.0//EN";
    private static final String DTD_PUBLIC_CS_ID_1_0 = "-//Checkstyle//DTD SuppressionFilter Configuration 1.0//EN";
    private static final String DTD_SUPPRESSIONS_NAME_1_0 = "com/puppycrawl/tools/checkstyle/suppressions_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Suppressions 1.1//EN";
    private static final String DTD_PUBLIC_CS_ID_1_1 = "-//Checkstyle//DTD SuppressionFilter Configuration 1.1//EN";
    private static final String DTD_SUPPRESSIONS_NAME_1_1 = "com/puppycrawl/tools/checkstyle/suppressions_1_1.dtd";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Suppressions 1.2//EN";
    private static final String DTD_PUBLIC_CS_ID_1_2 = "-//Checkstyle//DTD SuppressionFilter Configuration 1.2//EN";
    private static final String DTD_SUPPRESSIONS_NAME_1_2 = "com/puppycrawl/tools/checkstyle/suppressions_1_2.dtd";
    private static final String DTD_PUBLIC_ID_1_1_XPATH = "-//Puppy Crawl//DTD Suppressions Xpath Experimental 1.1//EN";
    private static final String DTD_PUBLIC_CS_ID_1_1_XPATH = "-//Checkstyle//DTD SuppressionXpathFilter Experimental Configuration 1.1//EN";
    private static final String DTD_SUPPRESSIONS_NAME_1_1_XPATH = "com/puppycrawl/tools/checkstyle/suppressions_1_1_xpath_experimental.dtd";
    private static final String DTD_PUBLIC_ID_1_2_XPATH = "-//Puppy Crawl//DTD Suppressions Xpath Experimental 1.2//EN";
    private static final String DTD_PUBLIC_CS_ID_1_2_XPATH = "-//Checkstyle//DTD SuppressionXpathFilter Experimental Configuration 1.2//EN";
    private static final String DTD_SUPPRESSIONS_NAME_1_2_XPATH = "com/puppycrawl/tools/checkstyle/suppressions_1_2_xpath_experimental.dtd";
    private static final String UNABLE_TO_FIND_ERROR_MESSAGE = "Unable to find: ";
    private static final String ATTRIBUTE_NAME_FILES = "files";
    private static final String ATTRIBUTE_NAME_CHECKS = "checks";
    private static final String ATTRIBUTE_NAME_MESSAGE = "message";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_QUERY = "query";
    private static final String ATTRIBUTE_NAME_LINES = "lines";
    private static final String ATTRIBUTE_NAME_COLUMNS = "columns";
    private final FilterSet filterChain = new FilterSet();
    private final Set<TreeWalkerFilter> treeWalkerFilters = new HashSet<TreeWalkerFilter>();

    private SuppressionsLoader() throws ParserConfigurationException, SAXException {
        super(SuppressionsLoader.createIdToResourceNameMap());
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("suppress".equals(qName)) {
            SuppressElement suppress = SuppressionsLoader.getSuppressElement(attributes);
            this.filterChain.addFilter(suppress);
        } else if ("suppress-xpath".equals(qName)) {
            XpathFilter filter = SuppressionsLoader.getXpathFilter(attributes);
            this.treeWalkerFilters.add(filter);
        }
    }

    private static SuppressElement getSuppressElement(Attributes attributes) throws SAXException {
        SuppressElement suppress;
        String checks = attributes.getValue(ATTRIBUTE_NAME_CHECKS);
        String modId = attributes.getValue(ATTRIBUTE_NAME_ID);
        String message = attributes.getValue(ATTRIBUTE_NAME_MESSAGE);
        if (checks == null && modId == null && message == null) {
            throw new SAXException("missing checks or id or message attribute");
        }
        try {
            String files = attributes.getValue(ATTRIBUTE_NAME_FILES);
            String lines = attributes.getValue(ATTRIBUTE_NAME_LINES);
            String columns = attributes.getValue(ATTRIBUTE_NAME_COLUMNS);
            suppress = new SuppressElement(files, checks, message, modId, lines, columns);
        }
        catch (PatternSyntaxException ex) {
            throw new SAXException("invalid files or checks or message format", ex);
        }
        return suppress;
    }

    private static XpathFilter getXpathFilter(Attributes attributes) throws SAXException {
        XpathFilter filter;
        String checks = attributes.getValue(ATTRIBUTE_NAME_CHECKS);
        String modId = attributes.getValue(ATTRIBUTE_NAME_ID);
        String message = attributes.getValue(ATTRIBUTE_NAME_MESSAGE);
        if (checks == null && modId == null && message == null) {
            throw new SAXException("missing checks or id or message attribute for suppress-xpath");
        }
        try {
            String files = attributes.getValue(ATTRIBUTE_NAME_FILES);
            String xpathQuery = attributes.getValue(ATTRIBUTE_NAME_QUERY);
            filter = new XpathFilter(files, checks, message, modId, xpathQuery);
        }
        catch (PatternSyntaxException ex) {
            throw new SAXException("invalid files or checks or message format for suppress-xpath", ex);
        }
        return filter;
    }

    public static FilterSet loadSuppressions(String filename) throws CheckstyleException {
        URI uri = CommonUtil.getUriByFilename(filename);
        InputSource source = new InputSource(uri.toString());
        return SuppressionsLoader.loadSuppressions(source, filename);
    }

    private static FilterSet loadSuppressions(InputSource source, String sourceName) throws CheckstyleException {
        return SuppressionsLoader.getSuppressionLoader((InputSource)source, (String)sourceName).filterChain;
    }

    public static Set<TreeWalkerFilter> loadXpathSuppressions(String filename) throws CheckstyleException {
        URI uri = CommonUtil.getUriByFilename(filename);
        InputSource source = new InputSource(uri.toString());
        return SuppressionsLoader.loadXpathSuppressions(source, filename);
    }

    private static Set<TreeWalkerFilter> loadXpathSuppressions(InputSource source, String sourceName) throws CheckstyleException {
        return SuppressionsLoader.getSuppressionLoader((InputSource)source, (String)sourceName).treeWalkerFilters;
    }

    private static SuppressionsLoader getSuppressionLoader(InputSource source, String sourceName) throws CheckstyleException {
        try {
            SuppressionsLoader suppressionsLoader = new SuppressionsLoader();
            suppressionsLoader.parseInputSource(source);
            return suppressionsLoader;
        }
        catch (FileNotFoundException ex) {
            throw new CheckstyleException(UNABLE_TO_FIND_ERROR_MESSAGE + sourceName, ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            String message = String.format(Locale.ROOT, "Unable to parse %s - %s", sourceName, ex.getMessage());
            throw new CheckstyleException(message, ex);
        }
        catch (IOException ex) {
            throw new CheckstyleException("Unable to read " + sourceName, ex);
        }
        catch (NumberFormatException ex) {
            String message = String.format(Locale.ROOT, "Number format exception %s - %s", sourceName, ex.getMessage());
            throw new CheckstyleException(message, ex);
        }
    }

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DTD_PUBLIC_ID_1_0, DTD_SUPPRESSIONS_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_SUPPRESSIONS_NAME_1_1);
        map.put(DTD_PUBLIC_ID_1_2, DTD_SUPPRESSIONS_NAME_1_2);
        map.put(DTD_PUBLIC_ID_1_1_XPATH, DTD_SUPPRESSIONS_NAME_1_1_XPATH);
        map.put(DTD_PUBLIC_ID_1_2_XPATH, DTD_SUPPRESSIONS_NAME_1_2_XPATH);
        map.put(DTD_PUBLIC_CS_ID_1_0, DTD_SUPPRESSIONS_NAME_1_0);
        map.put(DTD_PUBLIC_CS_ID_1_1, DTD_SUPPRESSIONS_NAME_1_1);
        map.put(DTD_PUBLIC_CS_ID_1_2, DTD_SUPPRESSIONS_NAME_1_2);
        map.put(DTD_PUBLIC_CS_ID_1_1_XPATH, DTD_SUPPRESSIONS_NAME_1_1_XPATH);
        map.put(DTD_PUBLIC_CS_ID_1_2_XPATH, DTD_SUPPRESSIONS_NAME_1_2_XPATH);
        return map;
    }
}

