# Bitwarden Android troubleshooting

## General
Ever since the new Bitwarden Mobile clients, some issues keep arising.
These issues are mainly because the new clients are more strict regarding the JSON returned by the server.

Because the old clients were less strict, and Vaultwarden did not (and still isn't fully) filtered or corrected the input from all the clients to keep as flexible as possible when Bitwarden adds new features, sometimes the stored data might contain invalid values.
We try to correct all these items during the sync to fix all old invalid values where possible, and trust that the clients send correct new data.

Since we can not know all invalid data ever generated by any client, it's sometimes hard for the developers to figure out what the specific issues is. For this, we need the help of the community to troubleshoot and find the culprit.

Bellow are some troubleshooting guides which should help finding the issues which might help you fix it your self, or help the developers to fix it on the server side.

## Things to try first

The first thing to do is ensure the client does not have a invalid cached JSON locally. This is loaded before the sync request is done, and might cause issues we can not solve server side.

0. Ensure you have the latest version installed of the Android Client.<br>
   You can see the released versions here: https://github.com/bitwarden/android/releases
1. Logout from the mobile client
2. Clear cache and data of the Bitwarden app
3. Uninstall the Bitwarden app
4. And to be fully sure it is all cleaned, reboot
5. Install the Bitwarden app again
6. Configure the app to connect to your self-hosted instance
7. Login and cross your fingers

If the steps above did not solved your issue, then there might be something wrong with the data returned by Vaultwarden.
In that case continue below.

## Install Android Debugging tools (adb)

Most (if not all) Android devices are able to extract logs from the device by connecting your device to a computer which has the right tools installed. You can find a detailed guide per platform on how to install this here https://www.xda-developers.com/install-adb-windows-macos-linux/ .

**Please read everything regarding your platform first before actually installing the tools, sometimes there are multiple ways described and the first one might not be the easiest one.**

After you have installed those tools, and are able to connect to your phone you can continue to the next steps.

## The actual debugging

Now that everything is setup we can start extracting logs which hopefully help tracking the issue.

Run the following command to show only the Bitwarden Client logs:
```bash
adb logcat --pid=$(adb shell pidof -s com.x8bit.bitwarden)
```

> [!NOTE]
> You can exit the logcat by pressing ctrl+c (or cmd+c)

> [!TIP]
> If you want to log everything to a file you can append the command with the following on at least Linux
> ```bash
> # Directly to a file:
> > bitwarden-android.log
> # Or, to a file and on screen at the same time:
> > | tee -a bitwarden-android.log
> # Full examples:
> adb logcat --pid=$(adb shell pidof -s com.x8bit.bitwarden) > bitwarden-android.log
> adb logcat --pid=$(adb shell pidof -s com.x8bit.bitwarden) | tee -a bitwarden-android.log
> ```

This should start showing some logs, if so continue, if not, check the error message and try to resolve the issue.

Now with the logs outputting on the screen, try to trigger the error in the client and check the output.
This output is needed for the developers to try and figure out where the issue is.

### Getting more details

If there is no useful output, there is a way to get more details by using the Bitwarden Dev/Debug Android client.<br>
These versions are build via GitHub Actions and can be found here: https://github.com/bitwarden/android/actions/workflows/build.yml?query=is%3Asuccess

Basically, any successful build should contain an artifact file called `com.x8bit.bitwarden.dev.apk`.<br>
Download this file, which will be a zip file, extract that zip file, and install the extracted apk file.<br>
This can be done via the Android device it self if you have a File Manager which supports zip files.<br>
Or, use `adb` to install this like this:
```bash
adb install com.x8bit.bitwarden.dev.apk
```

Once this is done, you should have an extra Bitwarden client installed which should output more detailed logs.<br>
Follow the same steps as you normally do to login to your self-hosted instance.<br>
And to extract logs from this client, you need to adjust the `logcat` command a bit to look like this:
```bash
adb logcat --pid=$(adb shell pidof -s com.x8bit.bitwarden.dev)
```

This should provide much more details, and will be really helpful tracking down the issue.

> [!CAUTION]
> **The output of of the dev client contains the response sent by the Vaultwarden server, which might contain sensitive data!**<br>
> While most items are encrypted, some items like email address or your Vaultwarden domain are not!<br>
> **Be careful on how you share this output!**<br>
> While the full output is very useful to us developers, and helps troubleshooting, and we can't decrypt the data, still be careful!<br>

## Sharing the results

We suggest to share these files in a secure way either:
1. (_**Preferred**_) Via our Matrix chat: [![Matrix Chat](https://img.shields.io/matrix/vaultwarden:matrix.org.svg?style=flat-square&logo=matrix&logoColor=fff&color=953B00&cacheSeconds=14400)](https://matrix.to/#/#vaultwarden:matrix.org)
2. Via email, by sending an ![security-contact](https://github.com/dani-garcia/vaultwarden/raw/refs/heads/main/.github/security-contact.gif) to provide the details.
3. Via your self-hosted Vaultwarden using **Send** and a password (Shared via Matrix or email).<br>

If you have any questions regarding this topic, please start a new topic on our [![GitHub Discussions](https://img.shields.io/github/discussions/dani-garcia/vaultwarden?style=flat-square&logo=github&logoColor=fff&color=953B00&cacheSeconds=300)](https://github.com/dani-garcia/vaultwarden/discussions).